/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model.type;

import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.annotation.DefaultEntityAnnotationProcessor;
import com.impetus.kundera.metadata.model.annotation.EntityAnnotationProcessor;
import com.impetus.kundera.metadata.model.type.AbstractType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public abstract class AbstractManagedType<X>
extends AbstractType<X>
implements ManagedType<X> {
    private ManagedType<? super X> superClazzType;
    private Map<String, SingularAttribute<X, ?>> declaredSingluarAttribs;
    private Map<String, PluralAttribute<X, ?, ?>> declaredPluralAttributes;
    private static final List<Class<? extends Annotation>> validJPAAnnotations = Arrays.asList(AttributeOverrides.class, AttributeOverride.class);
    private Map<String, Column> columnBindings = new ConcurrentHashMap<String, Column>();
    private InheritanceModel model;
    private EntityAnnotationProcessor entityAnnotationProcessor;
    private List<ManagedType<X>> subManagedTypes = new ArrayList<ManagedType<X>>();
    private boolean hasLobAttribute;
    protected boolean hasValidationConstraints = false;
    private boolean hasEmbeddableAttribute;

    public boolean hasLobAttribute() {
        return this.hasLobAttribute;
    }

    public void setHasLobAttribute(boolean hasLobAttribute) {
        this.hasLobAttribute = hasLobAttribute;
    }

    AbstractManagedType(Class<X> clazz, Type.PersistenceType persistenceType, ManagedType<? super X> superClazzType) {
        super(clazz, persistenceType);
        this.superClazzType = superClazzType;
        this.bindTypeAnnotations();
        if (this.superClazzType != null) {
            ((AbstractManagedType)this.superClazzType).addSubManagedType(this);
        }
        this.model = this.buildInheritenceModel();
        this.entityAnnotationProcessor = new DefaultEntityAnnotationProcessor(clazz);
    }

    public Set<Attribute<? super X, ?>> getAttributes() {
        HashSet attributes = new HashSet();
        Set<Attribute<X, ?>> declaredAttribs = this.getDeclaredAttributes();
        if (declaredAttribs != null) {
            attributes.addAll(declaredAttribs);
        }
        if (this.superClazzType != null) {
            attributes.addAll(this.superClazzType.getAttributes());
        }
        return attributes;
    }

    public Set<Attribute<X, ?>> getDeclaredAttributes() {
        HashSet attributes = new HashSet();
        if (this.declaredSingluarAttribs != null) {
            attributes.addAll(this.declaredSingluarAttribs.values());
        }
        if (this.declaredPluralAttributes != null) {
            attributes.addAll(this.declaredPluralAttributes.values());
        }
        return attributes;
    }

    public <Y> SingularAttribute<? super X, Y> getSingularAttribute(String paramString, Class<Y> paramClass) {
        SingularAttribute<X, Y> attribute = this.getDeclaredSingularAttribute(paramString, paramClass, false);
        if (this.superClazzType != null && attribute == null) {
            return this.superClazzType.getSingularAttribute(paramString, paramClass);
        }
        this.checkForValid(paramString, (Attribute<? super X, ?>)attribute);
        return attribute;
    }

    public <Y> SingularAttribute<X, Y> getDeclaredSingularAttribute(String paramString, Class<Y> paramClass) {
        return this.getDeclaredSingularAttribute(paramString, paramClass, true);
    }

    public Set<SingularAttribute<? super X, ?>> getSingularAttributes() {
        Set<SingularAttribute<X, ?>> declaredAttribSet;
        Set parentAttrib;
        HashSet singularAttrib = new HashSet();
        if (this.superClazzType != null && (parentAttrib = this.superClazzType.getSingularAttributes()) != null) {
            singularAttrib.addAll(parentAttrib);
        }
        if ((declaredAttribSet = this.getDeclaredSingularAttributes()) != null) {
            singularAttrib.addAll(declaredAttribSet);
        }
        return singularAttrib;
    }

    public Set<SingularAttribute<X, ?>> getDeclaredSingularAttributes() {
        HashSet declaredAttribSet = null;
        if (this.declaredSingluarAttribs != null) {
            declaredAttribSet = new HashSet();
            declaredAttribSet.addAll(this.declaredSingluarAttribs.values());
        }
        return declaredAttribSet;
    }

    public <E> CollectionAttribute<? super X, E> getCollection(String paramName, Class<E> paramClass) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.onCheckCollectionAttribute(declaredAttrib, paramClass)) {
            return (CollectionAttribute)declaredAttrib;
        }
        PluralAttribute<X, ?, ?> superAttrib = this.getPluralAttriute(paramName);
        if (this.onCheckCollectionAttribute(superAttrib, paramClass)) {
            return (CollectionAttribute)superAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName + " , type:" + paramClass);
    }

    public <E> CollectionAttribute<X, E> getDeclaredCollection(String paramString, Class<E> paramClass) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramString);
        if (this.onCheckCollectionAttribute(declaredAttrib, paramClass)) {
            return (CollectionAttribute)declaredAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramString + " , type:" + paramClass);
    }

    public <E> SetAttribute<? super X, E> getSet(String paramName, Class<E> paramClass) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.onCheckSetAttribute(declaredAttrib, paramClass)) {
            return (SetAttribute)declaredAttrib;
        }
        PluralAttribute<X, ?, ?> superAttrib = this.getPluralAttriute(paramName);
        if (this.onCheckSetAttribute(superAttrib, paramClass)) {
            return (SetAttribute)superAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName + " , type:" + paramClass);
    }

    public <E> SetAttribute<X, E> getDeclaredSet(String paramName, Class<E> paramClass) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.onCheckSetAttribute(declaredAttrib, paramClass)) {
            return (SetAttribute)declaredAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName + " , type:" + paramClass);
    }

    public <E> ListAttribute<? super X, E> getList(String paramName, Class<E> paramClass) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.onCheckListAttribute(declaredAttrib, paramClass)) {
            return (ListAttribute)declaredAttrib;
        }
        PluralAttribute<X, ?, ?> superAttrib = this.getPluralAttriute(paramName);
        if (this.onCheckListAttribute(superAttrib, paramClass)) {
            return (ListAttribute)superAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName + " , type:" + paramClass);
    }

    public <E> ListAttribute<X, E> getDeclaredList(String paramName, Class<E> paramClass) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.onCheckListAttribute(declaredAttrib, paramClass)) {
            return (ListAttribute)declaredAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName + " , type:" + paramClass);
    }

    public <K, V> MapAttribute<? super X, K, V> getMap(String paramName, Class<K> keyClazz, Class<V> valueClazz) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.onCheckMapAttribute(declaredAttrib, valueClazz) && valueClazz != null && valueClazz.equals(((MapAttribute)declaredAttrib).getKeyJavaType())) {
            return (MapAttribute)declaredAttrib;
        }
        PluralAttribute<X, ?, ?> superAttrib = this.getPluralAttriute(paramName);
        if (this.onCheckMapAttribute(superAttrib, valueClazz) && valueClazz != null && valueClazz.equals(((MapAttribute)superAttrib).getKeyJavaType())) {
            return (MapAttribute)superAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed MapAttribute type, for name:" + paramName + " , value type:" + valueClazz + "key tpye:" + keyClazz);
    }

    public <K, V> MapAttribute<X, K, V> getDeclaredMap(String paramName, Class<K> keyClazz, Class<V> valueClazz) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.onCheckMapAttribute(declaredAttrib, valueClazz) && valueClazz != null && valueClazz.equals(((MapAttribute)declaredAttrib).getKeyJavaType())) {
            return (MapAttribute)declaredAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed MapAttribute type, for name:" + paramName + " , value type:" + valueClazz + "key tpye:" + keyClazz);
    }

    public Set<PluralAttribute<? super X, ?, ?>> getPluralAttributes() {
        HashSet pluralAttributes = new HashSet();
        Set<PluralAttribute<X, ?, ?>> declaredAttribSet = this.getDeclaredPluralAttributes();
        if (declaredAttribSet != null) {
            pluralAttributes.addAll(declaredAttribSet);
        }
        if (this.superClazzType != null) {
            pluralAttributes.addAll(this.superClazzType.getPluralAttributes());
        }
        return pluralAttributes;
    }

    public Set<PluralAttribute<X, ?, ?>> getDeclaredPluralAttributes() {
        HashSet declaredAttribSet = null;
        if (this.declaredPluralAttributes != null) {
            declaredAttribSet = new HashSet();
            declaredAttribSet.addAll(this.declaredPluralAttributes.values());
        }
        return declaredAttribSet;
    }

    public Attribute<? super X, ?> getAttribute(String paramName) {
        Attribute attribute = this.getDeclaredAttribute(paramName, false);
        if (attribute == null && this.superClazzType != null) {
            attribute = this.superClazzType.getAttribute(paramName);
        }
        this.checkForValid(paramName, attribute);
        return attribute;
    }

    public Attribute<X, ?> getDeclaredAttribute(String paramName) {
        Attribute<X, ?> attribute = this.getDeclaredAttribute(paramName, true);
        return attribute;
    }

    public SingularAttribute<? super X, ?> getSingularAttribute(String paramString) {
        SingularAttribute<X, ?> attribute = this.getSingularAttribute(paramString, true);
        return attribute;
    }

    private SingularAttribute<? super X, ?> getSingularAttribute(String paramString, boolean checkValidity) {
        SingularAttribute attribute = this.getDeclaredSingularAttribute(paramString, false);
        try {
            if (attribute == null && this.superClazzType != null) {
                attribute = this.superClazzType.getSingularAttribute(paramString);
            }
        }
        catch (IllegalArgumentException iaex) {
            attribute = null;
            this.onValidity(paramString, checkValidity, attribute);
        }
        this.onValidity(paramString, checkValidity, attribute);
        return attribute;
    }

    public SingularAttribute<X, ?> getDeclaredSingularAttribute(String paramString) {
        SingularAttribute<X, ?> attribute = this.getDeclaredSingularAttribute(paramString, true);
        return attribute;
    }

    public CollectionAttribute<? super X, ?> getCollection(String paramName) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.isCollectionAttribute(declaredAttrib)) {
            return (CollectionAttribute)declaredAttrib;
        }
        declaredAttrib = this.getPluralAttriute(paramName);
        if (this.isCollectionAttribute(declaredAttrib)) {
            return (CollectionAttribute)declaredAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName);
    }

    public CollectionAttribute<X, ?> getDeclaredCollection(String paramName) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.isCollectionAttribute(declaredAttrib)) {
            return (CollectionAttribute)declaredAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName);
    }

    public SetAttribute<? super X, ?> getSet(String paramName) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.isSetAttribute(declaredAttrib)) {
            return (SetAttribute)declaredAttrib;
        }
        declaredAttrib = this.getPluralAttriute(paramName);
        if (this.isSetAttribute(declaredAttrib)) {
            return (SetAttribute)declaredAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName);
    }

    public SetAttribute<X, ?> getDeclaredSet(String paramName) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.isSetAttribute(declaredAttrib)) {
            return (SetAttribute)declaredAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName);
    }

    public ListAttribute<? super X, ?> getList(String paramName) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.isListAttribute(declaredAttrib)) {
            return (ListAttribute)declaredAttrib;
        }
        declaredAttrib = this.getPluralAttriute(paramName);
        if (this.isListAttribute(declaredAttrib)) {
            return (ListAttribute)declaredAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName);
    }

    public ListAttribute<X, ?> getDeclaredList(String paramName) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.isListAttribute(declaredAttrib)) {
            return (ListAttribute)declaredAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName);
    }

    public MapAttribute<? super X, ?, ?> getMap(String paramName) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.isMapAttribute(declaredAttrib)) {
            return (MapAttribute)declaredAttrib;
        }
        declaredAttrib = this.getPluralAttriute(paramName);
        if (this.isMapAttribute(declaredAttrib)) {
            return (MapAttribute)declaredAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName);
    }

    public MapAttribute<X, ?, ?> getDeclaredMap(String paramName) {
        PluralAttribute<X, ?, ?> declaredAttrib = this.getDeclaredPluralAttribute(paramName);
        if (this.isMapAttribute(declaredAttrib)) {
            return (MapAttribute)declaredAttrib;
        }
        throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName);
    }

    ManagedType<? super X> getSuperClazzType() {
        return this.superClazzType;
    }

    public void addSingularAttribute(String attributeName, SingularAttribute<X, ?> attribute) {
        if (this.declaredSingluarAttribs == null) {
            this.declaredSingluarAttribs = new HashMap();
        }
        this.declaredSingluarAttribs.put(attributeName, attribute);
        this.onValidateAttributeConstraints((Field)attribute.getJavaMember());
        this.onEmbeddableAttribute((Field)attribute.getJavaMember());
    }

    public void addPluralAttribute(String attributeName, PluralAttribute<X, ?, ?> attribute) {
        if (this.declaredPluralAttributes == null) {
            this.declaredPluralAttributes = new HashMap();
        }
        this.declaredPluralAttributes.put(attributeName, attribute);
        this.onValidateAttributeConstraints((Field)attribute.getJavaMember());
        this.onEmbeddableAttribute((Field)attribute.getJavaMember());
    }

    public Column getAttributeBinding(Field attribute) {
        return this.columnBindings.get(attribute.getName());
    }

    private void addSubManagedType(ManagedType inheritedType) {
        if (Modifier.isAbstract(this.getJavaType().getModifiers())) {
            this.subManagedTypes.add(inheritedType);
        }
    }

    public List<ManagedType<X>> getSubManagedType() {
        return this.subManagedTypes;
    }

    private PluralAttribute<X, ?, ?> getDeclaredPluralAttribute(String paramName) {
        return this.declaredPluralAttributes != null ? this.declaredPluralAttributes.get(paramName) : null;
    }

    private PluralAttribute<? super X, ?, ?> getPluralAttriute(String paramName) {
        if (this.superClazzType != null) {
            return ((AbstractManagedType)this.superClazzType).getDeclaredPluralAttribute(paramName);
        }
        return null;
    }

    private <E> boolean onCheckCollectionAttribute(PluralAttribute<? super X, ?, ?> pluralAttribute, Class<E> paramClass) {
        return pluralAttribute != null && this.isCollectionAttribute(pluralAttribute) && this.isBindable((Bindable<?>)pluralAttribute, paramClass);
    }

    private <E> boolean onCheckSetAttribute(PluralAttribute<? super X, ?, ?> pluralAttribute, Class<E> paramClass) {
        return pluralAttribute != null && this.isSetAttribute(pluralAttribute) && this.isBindable((Bindable<?>)pluralAttribute, paramClass);
    }

    private <E> boolean onCheckListAttribute(PluralAttribute<? super X, ?, ?> pluralAttribute, Class<E> paramClass) {
        return pluralAttribute != null && this.isListAttribute(pluralAttribute) && this.isBindable((Bindable<?>)pluralAttribute, paramClass);
    }

    private <V> boolean onCheckMapAttribute(PluralAttribute<? super X, ?, ?> pluralAttribute, Class<V> valueClazz) {
        return pluralAttribute != null && this.isMapAttribute(pluralAttribute) && this.isBindable((Bindable<?>)pluralAttribute, (Class)valueClazz);
    }

    private boolean isCollectionAttribute(PluralAttribute<? super X, ?, ?> attribute) {
        return attribute != null && attribute.getCollectionType().equals((Object)PluralAttribute.CollectionType.COLLECTION);
    }

    private boolean isListAttribute(PluralAttribute<? super X, ?, ?> attribute) {
        return attribute != null && attribute.getCollectionType().equals((Object)PluralAttribute.CollectionType.LIST);
    }

    private boolean isSetAttribute(PluralAttribute<? super X, ?, ?> attribute) {
        return attribute != null && attribute.getCollectionType().equals((Object)PluralAttribute.CollectionType.SET);
    }

    private boolean isMapAttribute(PluralAttribute<? super X, ?, ?> attribute) {
        return attribute != null && attribute.getCollectionType().equals((Object)PluralAttribute.CollectionType.MAP);
    }

    private <E> boolean isBindable(Bindable<?> attribute, Class<E> elementType) {
        return attribute != null && attribute.getBindableJavaType().equals(elementType);
    }

    private void checkForValid(String paramName, Attribute<? super X, ?> attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramName);
        }
    }

    private Attribute<X, ?> getDeclaredAttribute(String paramName, boolean checkValidity) {
        SingularAttribute<X, ?> attribute = this.getSingularAttribute(paramName, false);
        if (attribute == null) {
            attribute = this.getDeclaredPluralAttribute(paramName);
        }
        if (checkValidity) {
            this.checkForValid(paramName, (Attribute<? super X, ?>)attribute);
        }
        return attribute;
    }

    private <Y> SingularAttribute<X, Y> getDeclaredSingularAttribute(String paramString, Class<Y> paramClass, boolean checkValidity) {
        SingularAttribute<X, ?> declaredAttrib = this.declaredSingluarAttribs.get(paramString);
        if (declaredAttrib != null && declaredAttrib.getBindableJavaType().equals(paramClass)) {
            return declaredAttrib;
        }
        if (checkValidity) {
            throw new IllegalArgumentException("attribute of the given name and type is not present in the managed type, for name:" + paramString + " , type:" + paramClass);
        }
        return null;
    }

    private SingularAttribute<X, ?> getDeclaredSingularAttribute(String paramString, boolean checkValidity) {
        SingularAttribute<X, ?> attribute = null;
        if (this.declaredSingluarAttribs != null) {
            attribute = this.declaredSingluarAttribs.get(paramString);
        }
        if (checkValidity) {
            this.checkForValid(paramString, (Attribute<? super X, ?>)attribute);
        }
        return attribute;
    }

    private void onValidity(String paramString, boolean checkValidity, SingularAttribute<? super X, ?> attribute) {
        if (checkValidity) {
            this.checkForValid(paramString, (Attribute<? super X, ?>)attribute);
        }
    }

    private void bindTypeAnnotations() {
        for (Class<? extends Annotation> ann : validJPAAnnotations) {
            AttributeOverride[] attribAnns;
            if (!this.getJavaType().isAnnotationPresent(ann)) continue;
            this.checkForValid();
            Annotation annotation = this.getJavaType().getAnnotation(ann);
            if (ann.isAssignableFrom(AttributeOverride.class)) {
                this.bindAttribute(annotation);
                continue;
            }
            if (!ann.isAssignableFrom(AttributeOverrides.class)) continue;
            for (AttributeOverride attribOverann : attribAnns = ((AttributeOverrides)annotation).value()) {
                this.bindAttribute((Annotation)attribOverann);
            }
        }
    }

    private void bindAttribute(Annotation annotation) {
        String fieldname = ((AttributeOverride)annotation).name();
        Column column = ((AttributeOverride)annotation).column();
        ((AbstractManagedType)this.superClazzType).columnBindings.put(fieldname, column);
    }

    private void checkForValid() {
        if (this.superClazzType == null) {
            throw new IllegalArgumentException("@AttributeOverride and @AttributeOverrides are only applicable if super class is @MappedSuperClass");
        }
    }

    private InheritanceModel buildInheritenceModel() {
        InheritanceModel model = null;
        if (this.superClazzType != null && this.superClazzType.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY) && this.superClazzType.getJavaType().isAnnotationPresent(Inheritance.class)) {
            Inheritance inheritenceAnn = this.superClazzType.getJavaType().getAnnotation(Inheritance.class);
            InheritanceType strategyType = inheritenceAnn.strategy();
            String descriminator = null;
            String descriminatorValue = null;
            String tableName = null;
            String schemaName = null;
            tableName = this.superClazzType.getJavaType().getSimpleName();
            if (this.superClazzType.getJavaType().isAnnotationPresent(Table.class)) {
                tableName = this.superClazzType.getJavaType().getAnnotation(Table.class).name();
                schemaName = this.superClazzType.getJavaType().getAnnotation(Table.class).schema();
            }
            model = this.onStrategyType(model, strategyType, descriminator, descriminatorValue, tableName, schemaName);
        }
        return model;
    }

    private InheritanceModel onStrategyType(InheritanceModel model, InheritanceType strategyType, String descriminator, String descriminatorValue, String tableName, String schemaName) {
        switch (strategyType) {
            case SINGLE_TABLE: {
                if (this.superClazzType.getJavaType().isAnnotationPresent(DiscriminatorColumn.class)) {
                    descriminator = this.superClazzType.getJavaType().getAnnotation(DiscriminatorColumn.class).name();
                    descriminatorValue = this.getJavaType().getAnnotation(DiscriminatorValue.class).value();
                }
                model = new InheritanceModel(InheritanceType.SINGLE_TABLE, descriminator, descriminatorValue, tableName, schemaName);
                break;
            }
            case JOINED: {
                model = new InheritanceModel(InheritanceType.JOINED, tableName, schemaName);
                break;
            }
            case TABLE_PER_CLASS: {
                model = new InheritanceModel(InheritanceType.TABLE_PER_CLASS, null, null);
                break;
            }
        }
        return model;
    }

    public boolean isInherited() {
        return this.model != null;
    }

    public InheritanceType getInheritenceType() {
        return this.isInherited() ? this.model.inheritenceType : null;
    }

    public String getDiscriminatorColumn() {
        return this.isInherited() ? this.model.discriminatorColumn : null;
    }

    public String getDiscriminatorValue() {
        return this.isInherited() ? this.model.discriminatorValue : null;
    }

    public String getTableName() {
        return this.isInherited() ? this.model.tableName : null;
    }

    public String getSchemaName() {
        return this.isInherited() ? this.model.schemaName : null;
    }

    public EntityAnnotationProcessor getEntityAnnotation() {
        return this.entityAnnotationProcessor;
    }

    public boolean hasValidationConstraints() {
        if (this.hasValidationConstraints) {
            return this.hasValidationConstraints;
        }
        if (this.superClazzType != null) {
            return ((AbstractManagedType)this.superClazzType).hasValidationConstraints();
        }
        return false;
    }

    private void onValidateAttributeConstraints(Field field) {
        if (!this.hasValidationConstraints && MetadataUtils.onCheckValidationConstraints(field)) {
            this.hasValidationConstraints = true;
        }
    }

    private void onEmbeddableAttribute(Field field) {
        if (!this.hasEmbeddableAttribute && MetadataUtils.onCheckEmbeddableAttribute(field)) {
            this.hasEmbeddableAttribute = true;
        }
    }

    public boolean hasEmbeddableAttribute() {
        if (this.hasEmbeddableAttribute) {
            return this.hasEmbeddableAttribute;
        }
        if (this.superClazzType != null) {
            return ((AbstractManagedType)this.superClazzType).hasEmbeddableAttribute();
        }
        return false;
    }

    private static class InheritanceModel {
        private InheritanceType inheritenceType;
        private String discriminatorColumn;
        private String discriminatorValue;
        private String tableName;
        private String schemaName;

        InheritanceModel(InheritanceType type, String discriminatorCol, String discriminatorValue, String tableName, String schemaName) {
            this.inheritenceType = type;
            this.discriminatorColumn = discriminatorCol;
            this.discriminatorValue = discriminatorValue;
            this.tableName = tableName;
            this.schemaName = schemaName;
        }

        InheritanceModel(InheritanceType type, String tableName, String schemaName) {
            this.inheritenceType = type;
            this.tableName = tableName;
            this.schemaName = schemaName;
        }
    }
}

