/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.processor;

import com.impetus.kundera.metadata.MetadataProcessor;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.validator.EntityValidator;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.PersistenceException;
import javax.persistence.Temporal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityFieldProcessor
implements MetadataProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityFieldProcessor.class);
    protected EntityValidator validator;
    protected EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata;

    public AbstractEntityFieldProcessor(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        this.kunderaMetadata = kunderaMetadata;
    }

    public final void validate(Class<?> clazz) throws PersistenceException {
        this.validator.validate(clazz);
    }

    protected final String getValidJPAColumnName(Class<?> entity, Field f) {
        String name = null;
        if (f.isAnnotationPresent(Column.class)) {
            Column c = f.getAnnotation(Column.class);
            name = !c.name().isEmpty() ? c.name() : f.getName();
        } else if (f.isAnnotationPresent(Basic.class)) {
            name = f.getName();
        }
        if (f.isAnnotationPresent(Temporal.class)) {
            if (!f.getType().equals(Date.class)) {
                log.error("@Temporal must map to java.util.Date for @Entity(" + entity.getName() + "." + f.getName() + ")");
                return name;
            }
            if (null == name) {
                name = f.getName();
            }
        }
        return name;
    }

    protected final void populateIdAccessorMethods(EntityMetadata metadata, Class<?> clazz, Field f) {
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                if (!descriptor.getName().equals(f.getName())) continue;
                metadata.setReadIdentifierMethod(descriptor.getReadMethod());
                metadata.setWriteIdentifierMethod(descriptor.getWriteMethod());
                return;
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }
}

