/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.processor;

import com.impetus.kundera.loader.MetamodelLoaderException;
import com.impetus.kundera.metadata.MetadataProcessor;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.persistence.event.CallbackMethod;
import com.impetus.kundera.persistence.event.ExternalCallbackMethod;
import com.impetus.kundera.persistence.event.InternalCallbackMethod;
import com.impetus.kundera.utils.ReflectUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityListeners;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityListenersProcessor
implements MetadataProcessor {
    private static Logger log = LoggerFactory.getLogger(EntityListenersProcessor.class);
    private static final List<Class<? extends Annotation>> JPAListenersAnnotations = Arrays.asList(PrePersist.class, PostPersist.class, PreUpdate.class, PostUpdate.class, PreRemove.class, PostRemove.class, PostLoad.class);

    @Override
    public final void process(Class<?> entityClass, EntityMetadata metadata) {
        Class[] entityListenerClasses;
        EntityListeners entityListeners = entityClass.getAnnotation(EntityListeners.class);
        if (entityListeners != null && (entityListenerClasses = entityListeners.value()) != null) {
            for (Class entityListener : entityListenerClasses) {
                try {
                    entityListener.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new MetamodelLoaderException("Skipped method(" + entityListener.getName() + ") must have a default no-argument constructor.");
                }
                for (Method method : entityListener.getDeclaredMethods()) {
                    List<Class<?>> jpaAnnotations = this.getValidJPAAnnotationsFromMethod(entityListener, method, 1, entityClass);
                    for (Class<?> jpaAnnotation : jpaAnnotations) {
                        ExternalCallbackMethod callBackMethod = new ExternalCallbackMethod(entityListener, method);
                        this.addCallBackMethod(metadata, jpaAnnotation, callBackMethod);
                    }
                }
            }
        }
        for (Method method : entityClass.getMethods()) {
            List<Class<?>> jpaAnnotations = this.getValidJPAAnnotationsFromMethod(entityClass, method, 0, entityClass);
            for (Class<?> jpaAnnotation : jpaAnnotations) {
                InternalCallbackMethod callbackMethod = new InternalCallbackMethod(metadata, method);
                this.addCallBackMethod(metadata, jpaAnnotation, callbackMethod);
            }
        }
    }

    private void addCallBackMethod(EntityMetadata metadata, Class<?> jpaAnnotation, CallbackMethod callbackMethod) {
        Map<Class<?>, List<CallbackMethod>> callBackMethodsMap = metadata.getCallbackMethodsMap();
        List<? extends CallbackMethod> list = callBackMethodsMap.get(jpaAnnotation);
        if (null == list) {
            list = new ArrayList<CallbackMethod>();
            callBackMethodsMap.put(jpaAnnotation, list);
        }
        list.add(callbackMethod);
    }

    private List<Class<?>> getValidJPAAnnotationsFromMethod(Class<?> clazz, Method method, int numberOfParams, Class<?> entityClazz) {
        ArrayList annotations = new ArrayList();
        for (Annotation methodAnnotation : method.getAnnotations()) {
            Class<?> parameter;
            Class<? extends Annotation> methodAnnotationType = methodAnnotation.annotationType();
            if (!this.isValidJPAEntityListenerAnnotation(methodAnnotationType)) continue;
            boolean hasUncheckedExceptions = false;
            for (Class<?> exception : method.getExceptionTypes()) {
                if (ReflectUtils.hasSuperClass(RuntimeException.class, exception)) continue;
                hasUncheckedExceptions = true;
                break;
            }
            if (hasUncheckedExceptions) {
                log.info("Skipped method(" + clazz.getName() + "." + method.getName() + ") Must not throw unchecked exceptions.");
                continue;
            }
            if (!method.getReturnType().getSimpleName().equals("void")) {
                log.info("Skipped method(" + clazz.getName() + "." + method.getName() + ") Must have \"void\" return type.");
                continue;
            }
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != numberOfParams) {
                log.info("Skipped method(" + clazz.getName() + "." + method.getName() + ") Must have " + numberOfParams + " parameter.");
                continue;
            }
            if (!(numberOfParams != 1 || (parameter = paramTypes[0]) != null && parameter.isAssignableFrom(entityClazz))) {
                log.info("Skipped method(" + clazz.getName() + "." + method.getName() + ") Must have only 1 \"Object\" type parameter.");
                continue;
            }
            annotations.add(methodAnnotationType);
        }
        return annotations;
    }

    private boolean isValidJPAEntityListenerAnnotation(Class<?> annotation) {
        return JPAListenersAnnotations.contains(annotation);
    }
}

