/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.processor;

import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.IdDiscriptor;
import com.impetus.kundera.metadata.model.SequenceGeneratorDiscriptor;
import com.impetus.kundera.metadata.model.TableGeneratorDiscriptor;
import java.lang.reflect.Field;
import java.util.Map;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;

public class GeneratedValueProcessor {
    public void process(Class<?> clazz, Field idField, EntityMetadata m, Map<String, IdDiscriptor> entityNameToKeyDiscriptorMap) {
        IdDiscriptor keyValue = new IdDiscriptor();
        GeneratedValue value = idField.getAnnotation(GeneratedValue.class);
        String generatorName = value.generator();
        GenerationType generationType = value.strategy();
        switch (generationType) {
            case TABLE: {
                TableGeneratorDiscriptor tgd = this.processTableGenerator(clazz, idField, m, generatorName);
                keyValue.setTableDiscriptor(tgd);
                keyValue.setStrategy(GenerationType.TABLE);
                break;
            }
            case SEQUENCE: {
                SequenceGeneratorDiscriptor sgd = this.processSequenceGenerator(clazz, idField, m, generatorName);
                keyValue.setSequenceDiscriptor(sgd);
                keyValue.setStrategy(GenerationType.SEQUENCE);
                break;
            }
            case IDENTITY: {
                keyValue.setStrategy(GenerationType.IDENTITY);
                break;
            }
            case AUTO: {
                keyValue.setStrategy(GenerationType.AUTO);
            }
        }
        entityNameToKeyDiscriptorMap.put(clazz.getName(), keyValue);
    }

    private SequenceGeneratorDiscriptor processSequenceGenerator(Class<?> clazz, Field idField, EntityMetadata m, String generatorName) {
        SequenceGeneratorDiscriptor sgd = null;
        if (!generatorName.isEmpty()) {
            SequenceGenerator sequenceGenerator = idField.getAnnotation(SequenceGenerator.class);
            if (sequenceGenerator == null || !sequenceGenerator.name().equals(generatorName)) {
                sequenceGenerator = clazz.getAnnotation(SequenceGenerator.class);
            }
            sgd = new SequenceGeneratorDiscriptor(sequenceGenerator, m.getSchema());
        } else {
            sgd = new SequenceGeneratorDiscriptor(m.getSchema());
        }
        return sgd;
    }

    private TableGeneratorDiscriptor processTableGenerator(Class<?> clazz, Field idField, EntityMetadata m, String generatorName) {
        TableGeneratorDiscriptor tgd = null;
        if (!generatorName.isEmpty()) {
            TableGenerator tableGenerator = idField.getAnnotation(TableGenerator.class);
            if (tableGenerator == null || !tableGenerator.name().equals(generatorName)) {
                tableGenerator = clazz.getAnnotation(TableGenerator.class);
            }
            tgd = new TableGeneratorDiscriptor(tableGenerator, m.getSchema(), m.getTableName());
        } else {
            tgd = new TableGeneratorDiscriptor(m.getSchema(), m.getTableName());
        }
        return tgd;
    }
}

