/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.processor;

import com.impetus.kundera.loader.MetamodelLoaderException;
import com.impetus.kundera.metadata.model.attributes.AbstractPluralAttribute;
import com.impetus.kundera.metadata.model.attributes.DefaultCollectionAttribute;
import com.impetus.kundera.metadata.model.attributes.DefaultListAttribute;
import com.impetus.kundera.metadata.model.attributes.DefaultMapAttribute;
import com.impetus.kundera.metadata.model.attributes.DefaultSetAttribute;
import com.impetus.kundera.metadata.model.attributes.DefaultSingularAttribute;
import com.impetus.kundera.metadata.model.type.AbstractIdentifiableType;
import com.impetus.kundera.metadata.model.type.AbstractManagedType;
import com.impetus.kundera.metadata.model.type.DefaultBasicType;
import com.impetus.kundera.metadata.model.type.DefaultEmbeddableType;
import com.impetus.kundera.metadata.model.type.DefaultEntityType;
import com.impetus.kundera.metadata.model.type.DefaultMappedSuperClass;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.Modifier;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MappedSuperclassType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaModelBuilder<X, T> {
    private static final Logger LOG = LoggerFactory.getLogger(MetaModelBuilder.class);
    private AbstractManagedType<X> managedType;
    private Map<Class<?>, EntityType<?>> managedTypes = new HashMap();
    private Map<Class<?>, ManagedType<?>> mappedSuperClassTypes = new HashMap();
    private Map<Class<?>, AbstractManagedType<?>> embeddables = new HashMap();

    public void process(Class<X> clazz) {
        this.managedType = this.processInternal(clazz, false);
    }

    void addEmbeddables(Class<?> clazz, AbstractManagedType<?> embeddable) {
        this.embeddables.put(clazz, embeddable);
    }

    void construct(Class<X> clazz, Field attribute) {
        TypeBuilder typeBuilder = new TypeBuilder(attribute);
        typeBuilder.build((AbstractManagedType)this.managedTypes.get(clazz), attribute.getType());
    }

    public Map<Class<?>, EntityType<?>> getManagedTypes() {
        return this.managedTypes;
    }

    public Map<Class<?>, AbstractManagedType<?>> getEmbeddables() {
        return this.embeddables;
    }

    public Map<Class<?>, ManagedType<?>> getMappedSuperClassTypes() {
        return this.mappedSuperClassTypes;
    }

    private boolean isPluralAttribute(Field attribute) {
        return attribute.getType().equals(Collection.class) || attribute.getType().equals(Set.class) || attribute.getType().equals(List.class) || attribute.getType().equals(Map.class);
    }

    private Class<?> getTypedClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type rawParamterizedType = ((ParameterizedType)type).getRawType();
            return this.getTypedClass(rawParamterizedType);
        }
        if (type instanceof TypeVariable) {
            Type upperBound = ((TypeVariable)type).getBounds()[0];
            return this.getTypedClass(upperBound);
        }
        throw new IllegalArgumentException("Error while finding generic class for :" + type);
    }

    static Attribute.PersistentAttributeType getPersistentAttributeType(Field member) {
        Attribute.PersistentAttributeType attributeType = Attribute.PersistentAttributeType.BASIC;
        if (member.isAnnotationPresent(ElementCollection.class)) {
            attributeType = Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
        } else if (member.isAnnotationPresent(OneToMany.class)) {
            attributeType = Attribute.PersistentAttributeType.ONE_TO_MANY;
        } else if (member.isAnnotationPresent(ManyToMany.class)) {
            attributeType = Attribute.PersistentAttributeType.MANY_TO_MANY;
        } else if (member.isAnnotationPresent(ManyToOne.class)) {
            attributeType = Attribute.PersistentAttributeType.MANY_TO_ONE;
        } else if (member.isAnnotationPresent(OneToOne.class)) {
            attributeType = Attribute.PersistentAttributeType.ONE_TO_ONE;
        } else if (member.isAnnotationPresent(Embedded.class)) {
            attributeType = Attribute.PersistentAttributeType.EMBEDDED;
        }
        return attributeType;
    }

    private <X> AbstractManagedType<X> buildManagedType(Class<X> clazz, boolean isIdClass) {
        AbstractManagedType managedType = null;
        if (clazz.isAnnotationPresent(Embeddable.class)) {
            this.validate(clazz, true);
            if (!this.embeddables.containsKey(clazz)) {
                managedType = new DefaultEmbeddableType<X>(clazz, Type.PersistenceType.EMBEDDABLE, this.getType(clazz.getSuperclass(), isIdClass));
                this.onDeclaredFields(clazz, managedType);
                this.embeddables.put(clazz, managedType);
            } else {
                managedType = this.embeddables.get(clazz);
            }
        } else if (clazz.isAnnotationPresent(MappedSuperclass.class)) {
            this.validate(clazz, false);
            managedType = new DefaultMappedSuperClass<X>(clazz, Type.PersistenceType.MAPPED_SUPERCLASS, (AbstractIdentifiableType)this.getType(clazz.getSuperclass(), isIdClass));
            this.onDeclaredFields(clazz, managedType);
            this.mappedSuperClassTypes.put(clazz, (ManagedType<?>)((MappedSuperclassType)managedType));
        } else if (clazz.isAnnotationPresent(Entity.class) || isIdClass) {
            if (!this.managedTypes.containsKey(clazz)) {
                managedType = new DefaultEntityType<X>(clazz, Type.PersistenceType.ENTITY, (AbstractIdentifiableType)this.getType(clazz.getSuperclass(), isIdClass));
                if (!isIdClass) {
                    this.managedTypes.put(clazz, (EntityType)managedType);
                }
            } else {
                managedType = (DefaultEmbeddableType<X>)this.managedTypes.get(clazz);
            }
        }
        return managedType;
    }

    private AbstractManagedType getType(Class clazz, boolean isIdClass) {
        if (clazz != null && !clazz.equals(Object.class)) {
            return this.processInternal(clazz, isIdClass);
        }
        return null;
    }

    private <X> void validate(Class<X> clazz, boolean isEmbeddable) {
        String mappedSuperClazzErrMsg = "Class:" + clazz + "is annotated with @MappedSuperClass and @Entity not allowed";
        String embeddableClazzErrMsg = "Class:" + clazz + "is annotated with @Embeddable and @Entity not allowed";
        if (clazz.isAnnotationPresent(Entity.class)) {
            throw new MetamodelLoaderException(isEmbeddable ? embeddableClazzErrMsg : mappedSuperClazzErrMsg);
        }
    }

    private <X> void onDeclaredFields(Class<X> clazz, AbstractManagedType<X> managedType) {
        Field[] embeddedFields;
        for (Field f : embeddedFields = clazz.getDeclaredFields()) {
            if (!this.isNonTransient(f)) continue;
            new TypeBuilder(f).build(managedType, f.getType());
        }
    }

    private AbstractManagedType<X> processInternal(Class<X> clazz, boolean isIdClass) {
        if (this.managedTypes.get(clazz) == null) {
            return this.buildManagedType(clazz, isIdClass);
        }
        return (AbstractManagedType)this.managedTypes.get(clazz);
    }

    private boolean isNonTransient(Field attribute) {
        return attribute != null && !Modifier.isStatic((int)attribute.getModifiers()) && !Modifier.isTransient((int)attribute.getModifiers()) && !attribute.isAnnotationPresent(Transient.class);
    }

    private class TypeBuilder<X> {
        private Field attribute;
        private Attribute.PersistentAttributeType persistentAttribType;

        TypeBuilder(Field attribute) {
            this.attribute = attribute;
        }

        TypeBuilder(Field attribute, Attribute.PersistentAttributeType persistentAttribType) {
            this.attribute = attribute;
            this.persistentAttribType = persistentAttribType;
        }

        <T> javax.persistence.metamodel.Type<T> buildType(Class<T> attribType) {
            Attribute.PersistentAttributeType attributeType = this.attribute != null ? MetaModelBuilder.getPersistentAttributeType(this.attribute) : this.persistentAttribType;
            switch (attributeType) {
                case BASIC: {
                    return new DefaultBasicType<T>(attribType);
                }
                case EMBEDDED: {
                    return this.processOnEmbeddables(attribType);
                }
                case ELEMENT_COLLECTION: {
                    if (this.attribute != null && Collection.class.isAssignableFrom(attribType)) {
                        Type[] argument = ((ParameterizedType)this.attribute.getGenericType()).getActualTypeArguments();
                        return this.processOnEmbeddables(MetaModelBuilder.this.getTypedClass(argument[0]));
                    }
                    if (this.attribute != null && Map.class.isAssignableFrom(attribType)) {
                        Type[] argument = ((ParameterizedType)this.attribute.getGenericType()).getActualTypeArguments();
                        this.processOnEmbeddables(MetaModelBuilder.this.getTypedClass(argument[0]));
                        return this.processOnEmbeddables(MetaModelBuilder.this.getTypedClass(argument[1]));
                    }
                    LOG.warn("Cannot process for : " + this.attribute + " as it is not a collection but annotated with @ElementCollection");
                }
            }
            if (MetaModelBuilder.this.managedTypes.get(attribType) == null) {
                if (this.attribute != null && MetaModelBuilder.this.isPluralAttribute(this.attribute)) {
                    Type[] arguments = ((ParameterizedType)this.attribute.getGenericType()).getActualTypeArguments();
                    if (arguments != null && arguments.length == 1) {
                        attribType = MetaModelBuilder.this.getTypedClass(arguments[0]);
                    } else if (arguments != null && arguments.length > 1) {
                        attribType = MetaModelBuilder.this.getTypedClass(arguments[1]);
                    }
                }
                if (MetaModelBuilder.this.managedTypes.get(attribType) == null) {
                    if (attribType.isAnnotationPresent(Entity.class)) {
                        DefaultEntityType<T> entityType = new DefaultEntityType<T>(attribType, Type.PersistenceType.ENTITY, (AbstractIdentifiableType)MetaModelBuilder.this.getType(attribType.getSuperclass(), false));
                        MetaModelBuilder.this.managedTypes.put(attribType, entityType);
                    } else {
                        return new DefaultBasicType<T>(attribType);
                    }
                }
            }
            return (javax.persistence.metamodel.Type)MetaModelBuilder.this.managedTypes.get(attribType);
        }

        private AbstractManagedType processOnEmbeddables(Class attribType) {
            AbstractManagedType embeddableType = null;
            Type.PersistenceType persistenceType = Type.PersistenceType.BASIC;
            Embeddable embeddableAnnotation = attribType.getAnnotation(Embeddable.class);
            if (embeddableAnnotation != null) {
                persistenceType = Type.PersistenceType.EMBEDDABLE;
            }
            if (!MetaModelBuilder.this.embeddables.containsKey(attribType)) {
                embeddableType = new DefaultEmbeddableType(attribType, persistenceType, null);
                if (this.attribute != null) {
                    Field[] embeddedFields;
                    for (Field f : embeddedFields = attribType.getDeclaredFields()) {
                        if (!MetaModelBuilder.this.isNonTransient(f)) continue;
                        new TypeBuilder<X>(f).build(embeddableType, f.getType());
                    }
                }
                MetaModelBuilder.this.addEmbeddables(attribType, embeddableType);
            } else {
                embeddableType = (AbstractManagedType)MetaModelBuilder.this.embeddables.get(attribType);
            }
            this.onPostProcess(embeddableType);
            return embeddableType;
        }

        private void onPostProcess(AbstractManagedType<T> embeddableType) {
            try {
                if (MetaModelBuilder.this.managedType != null) {
                    Field managedTypeField = MetaModelBuilder.this.managedType.getClass().getSuperclass().getSuperclass().getDeclaredField("hasValidationConstraints");
                    if (!managedTypeField.isAccessible()) {
                        managedTypeField.setAccessible(true);
                    }
                    if (embeddableType.hasValidationConstraints()) {
                        managedTypeField.set(MetaModelBuilder.this.managedType, true);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error setting Contstraint for managed type, Caused by: {}", (Throwable)e);
                throw new MetamodelLoaderException("Error setting Contstraint for managed type" + e.getMessage());
            }
        }

        void build(AbstractManagedType managedType, Class attributeType) {
            new AttributeBuilder(this.attribute, managedType, this.buildType(attributeType)).build();
        }

        private void isValidId(AbstractManagedType superType) {
            if (superType == null) {
                throw new MetamodelLoaderException("field : " + this.attribute.getName() + " is either annotated with @EmbeddedId or class:" + MetaModelBuilder.this.managedType.getJavaType() + " is annotated with @Idclass, but enclosed class is not having any member");
            }
        }

        private class AttributeBuilder<X, T> {
            private Field attribute;
            private javax.persistence.metamodel.Type<T> attributeType;
            private AbstractManagedType<X> managedType;

            public AttributeBuilder(Field attribute, AbstractManagedType<X> managedType, javax.persistence.metamodel.Type<T> attributeType) {
                this.attribute = attribute;
                this.managedType = managedType;
                this.attributeType = attributeType;
            }

            public <K, V> void build() {
                if (MetaModelBuilder.this.isNonTransient(this.attribute)) {
                    if (!this.managedType.hasLobAttribute() && this.attribute.getAnnotation(Lob.class) != null) {
                        this.managedType.setHasLobAttribute(true);
                    }
                    if (MetaModelBuilder.this.isPluralAttribute(this.attribute)) {
                        AbstractPluralAttribute pluralAttribute = null;
                        if (this.attribute.getType().equals(Collection.class)) {
                            pluralAttribute = new DefaultCollectionAttribute<X, T>(this.attributeType, this.attribute.getName(), this.getAttributeType(), this.managedType, this.attribute, this.attribute.getType());
                        } else if (this.attribute.getType().equals(List.class)) {
                            pluralAttribute = new DefaultListAttribute<X, T>(this.attributeType, this.attribute.getName(), this.getAttributeType(), this.managedType, this.attribute, this.attribute.getType());
                        } else if (this.attribute.getType().equals(Set.class)) {
                            pluralAttribute = new DefaultSetAttribute<X, T>(this.attributeType, this.attribute.getName(), this.getAttributeType(), this.managedType, this.attribute, this.attribute.getType());
                        } else if (this.attribute.getType().equals(Map.class)) {
                            Type[] arguments = ((ParameterizedType)this.attribute.getGenericType()).getActualTypeArguments();
                            javax.persistence.metamodel.Type keyType = new TypeBuilder(null, MetaModelBuilder.getPersistentAttributeType(this.attribute)).buildType(MetaModelBuilder.this.getTypedClass(arguments[0]));
                            pluralAttribute = new DefaultMapAttribute(this.attributeType, this.attribute.getName(), this.getAttributeType(), this.managedType, this.attribute, this.attribute.getType(), keyType);
                        }
                        this.managedType.addPluralAttribute(this.attribute.getName(), (PluralAttribute<X, ?, ?>)pluralAttribute);
                    } else {
                        DefaultSingularAttribute<X, T> singularAttribute = new DefaultSingularAttribute<X, T>(this.attribute.getName(), this.getAttributeType(), this.attribute, this.attributeType, this.managedType, this.checkId(this.attribute));
                        this.managedType.addSingularAttribute(this.attribute.getName(), singularAttribute);
                        if (this.checkSimpleId(this.attribute) && this.checkIdClass(this.managedType.getJavaType())) {
                            IdClass anno = this.managedType.getJavaType().getAnnotation(IdClass.class);
                            AbstractManagedType superType = this.onSuperType(anno.value(), true);
                            MetaModelBuilder.this.onDeclaredFields(anno.value(), superType);
                            ((AbstractIdentifiableType)this.managedType).addIdAttribute(singularAttribute, true, superType.getDeclaredSingularAttributes());
                        } else if (this.checkEmbeddedId(this.attribute)) {
                            AbstractManagedType superType = this.onSuperType(this.attribute.getType(), false);
                            this.checkEmbeddable(superType.getJavaType(), this.attribute.getName());
                            ((AbstractIdentifiableType)this.managedType).addIdAttribute(singularAttribute, true, superType.getDeclaredSingularAttributes());
                        } else if (this.checkSimpleId(this.attribute)) {
                            ((AbstractIdentifiableType)this.managedType).addIdAttribute(singularAttribute, false, null);
                        }
                    }
                }
            }

            private void checkEmbeddable(Class superType, String fieldname) {
                if (superType != null && !superType.isAnnotationPresent(Embeddable.class)) {
                    throw new MetamodelLoaderException("Field: " + fieldname + " is annotated with @EmbeddedId but corresponding class:" + superType + " is not an @Embeddable entity");
                }
            }

            private AbstractManagedType onSuperType(Class clazz, boolean isIdClass) {
                AbstractManagedType superType = MetaModelBuilder.this.getType(clazz, isIdClass);
                TypeBuilder.this.isValidId(superType);
                return superType;
            }

            boolean checkId(Field member) {
                return this.checkSimpleId(member) || this.checkEmbeddedId(member);
            }

            boolean checkSimpleId(Field member) {
                return member.isAnnotationPresent(Id.class);
            }

            boolean checkIdClass(Class member) {
                return member.isAnnotationPresent(IdClass.class);
            }

            boolean checkEmbeddedId(Field member) {
                return member.isAnnotationPresent(EmbeddedId.class);
            }

            Attribute.PersistentAttributeType getAttributeType() {
                return MetaModelBuilder.getPersistentAttributeType(this.attribute);
            }
        }
    }
}

