/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.processor.relation;

import com.impetus.kundera.loader.MetamodelLoaderException;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.metadata.processor.AbstractEntityFieldProcessor;
import com.impetus.kundera.metadata.processor.relation.RelationMetadataProcessor;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.persistence.AssociationOverride;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;

public class OneToOneRelationMetadataProcessor
extends AbstractEntityFieldProcessor
implements RelationMetadataProcessor {
    public OneToOneRelationMetadataProcessor(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        super(kunderaMetadata);
    }

    @Override
    public void addRelationIntoMetadata(Field relationField, EntityMetadata metadata) {
        Class<?> targetEntity = relationField.getType();
        OneToOne oneToOneAnn = relationField.getAnnotation(OneToOne.class);
        boolean isJoinedByPK = relationField.isAnnotationPresent(PrimaryKeyJoinColumn.class);
        boolean isJoinedByFK = relationField.isAnnotationPresent(JoinColumn.class);
        Relation relation = new Relation(relationField, targetEntity, null, oneToOneAnn.fetch(), Arrays.asList(oneToOneAnn.cascade()), oneToOneAnn.optional(), oneToOneAnn.mappedBy(), Relation.ForeignKey.ONE_TO_ONE);
        if (relationField.isAnnotationPresent(AssociationOverride.class)) {
            AssociationOverride annotation = relationField.getAnnotation(AssociationOverride.class);
            JoinColumn[] joinColumns = annotation.joinColumns();
            relation.setJoinColumnName(joinColumns[0].name());
            JoinTable joinTable = annotation.joinTable();
            this.onJoinTable(joinTable);
        } else if (isJoinedByPK) {
            relation.setJoinedByPrimaryKey(true);
            EntityMetadata joinClassMetadata = KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, targetEntity.getClass());
            relation.setJoinColumnName(joinClassMetadata != null ? ((AbstractAttribute)joinClassMetadata.getIdAttribute()).getJPAColumnName() : null);
        } else if (isJoinedByFK) {
            JoinColumn joinColumnAnn = relationField.getAnnotation(JoinColumn.class);
            relation.setJoinColumnName(joinColumnAnn.name());
        }
        relation.setBiDirectionalField(metadata.getEntityClazz());
        metadata.addRelation(relationField.getName(), relation);
    }

    private void onJoinTable(JoinTable joinTable) {
        if (joinTable != null) {
            throw new UnsupportedOperationException("@JoinTable not supported for many to one association");
        }
    }

    @Override
    public void process(Class<?> clazz, EntityMetadata metadata) {
        throw new MetamodelLoaderException("Method call not applicable for Relation processors");
    }
}

