/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.client.Client;
import com.impetus.kundera.client.ClientBase;
import com.impetus.kundera.client.EnhanceEntity;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.persistence.AssociationBuilder;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.EntityReaderException;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.persistence.context.PersistenceCacheManager;
import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.proxy.ProxyHelper;
import com.impetus.kundera.query.KunderaQuery;
import com.impetus.kundera.utils.KunderaCoreUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FetchType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractEntityReader {
    private static Logger log = LoggerFactory.getLogger(AbstractEntityReader.class);
    private AssociationBuilder associationBuilder;
    protected KunderaQuery kunderaQuery;
    protected EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata;

    public AbstractEntityReader(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        this.kunderaMetadata = kunderaMetadata;
    }

    protected EnhanceEntity findById(Object primaryKey, EntityMetadata m, Client client) {
        try {
            Object o = client.find(m.getEntityClazz(), primaryKey);
            if (o == null) {
                return null;
            }
            return o instanceof EnhanceEntity ? (EnhanceEntity)o : new EnhanceEntity(o, this.getId(o, m), null);
        }
        catch (Exception e) {
            throw new EntityReaderException(e);
        }
    }

    private Object handleAssociation(Object entity, Map<String, Object> relationsMap, EntityMetadata m, PersistenceDelegator pd, boolean lazilyloaded, Map<Object, Object> relationStack) {
        for (Relation relation : m.getRelations()) {
            if (relation == null) continue;
            Relation.ForeignKey relationType = relation.getType();
            Object relationalObject = PropertyAccessorHelper.getObject(entity, relation.getProperty());
            if (KunderaCoreUtils.isEmptyOrNull(relationalObject) || ProxyHelper.isProxyOrCollection(relationalObject)) {
                this.onRelation(entity, relationsMap, m, pd, relation, relationType, lazilyloaded, relationStack);
                continue;
            }
            if (ProxyHelper.isProxyOrCollection(relationalObject) || !Map.class.isAssignableFrom(relationalObject.getClass())) continue;
            Map relationalMap = (Map)relationalObject;
            for (Map.Entry entry : relationalMap.entrySet()) {
                Object entityObject = entry.getValue();
                if (entityObject == null) continue;
                EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, entityObject.getClass());
                PersistenceCacheManager.addEntityToPersistenceCache(entityObject, pd, PropertyAccessorHelper.getId(entityObject, metadata));
            }
        }
        return entity;
    }

    private void onRelation(Object entity, Map<String, Object> relationsMap, EntityMetadata m, PersistenceDelegator pd, Relation relation, Relation.ForeignKey relationType, boolean lazilyloaded, Map<Object, Object> relationStack) {
        FetchType fetchType = relation.getFetchType();
        if (!lazilyloaded && fetchType.equals((Object)FetchType.LAZY)) {
            Object entityId = PropertyAccessorHelper.getId(entity, m);
            this.getAssociationBuilder().setProxyRelationObject(entity, relationsMap, m, pd, entityId, relation);
        } else if (relation.getType().equals((Object)Relation.ForeignKey.MANY_TO_MANY)) {
            Field f = relation.getProperty();
            Object object = PropertyAccessorHelper.getObject(entity, f);
            Object entityId = PropertyAccessorHelper.getId(entity, m);
            PersistenceCacheManager.addEntityToPersistenceCache(entity, pd, entityId);
            this.getAssociationBuilder().populateRelationForM2M(entity, m, pd, relation, object, relationsMap);
        } else {
            this.onRelation(entity, relationsMap, relation, m, pd, lazilyloaded, relationStack);
        }
    }

    private void onRelation(Object entity, Map<String, Object> relationsMap, Relation relation, EntityMetadata metadata, PersistenceDelegator pd, boolean lazilyloaded, Map<Object, Object> relationStack) {
        EntityMetadata targetEntityMetadata;
        Object relationValue;
        Object entityId = PropertyAccessorHelper.getId(entity, metadata);
        List relationalEntities = this.fetchRelations(relation, metadata, pd, entityId, relationValue = relationsMap != null ? relationsMap.get(relation.getJoinColumnName(this.kunderaMetadata)) : null, targetEntityMetadata = KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, relation.getTargetEntity()));
        if (relationalEntities != null) {
            for (Object relationEntity : relationalEntities) {
                if (relationEntity == null) continue;
                this.addToRelationStack(relationStack, relationEntity, targetEntityMetadata);
            }
            for (Object relationEntity : relationalEntities) {
                if (relationEntity == null) continue;
                this.onParseRelation(entity, pd, targetEntityMetadata, relationEntity, relation, lazilyloaded, relationStack);
                PersistenceCacheManager.addEntityToPersistenceCache(this.getEntity(relationEntity), pd, PropertyAccessorHelper.getId(relationEntity, targetEntityMetadata));
            }
        }
    }

    private void onParseRelation(Object entity, PersistenceDelegator pd, EntityMetadata targetEntityMetadata, Object relationEntity, Relation relation, boolean lazilyloaded, Map<Object, Object> relationStack) {
        this.parseRelations(entity, this.getEntity(relationEntity), this.getPersistedRelations(relationEntity), pd, targetEntityMetadata, lazilyloaded, relationStack);
        this.setRelationToEntity(entity, relationEntity, relation);
    }

    private void setRelationToEntity(Object entity, Object relationEntity, Relation relation) {
        if (relation.getTargetEntity().isAssignableFrom(this.getEntity(relationEntity).getClass())) {
            if (relation.isUnary()) {
                PropertyAccessorHelper.set(entity, relation.getProperty(), this.getEntity(relationEntity));
            } else {
                Object associationObject = PropertyAccessorHelper.getObject(entity, relation.getProperty());
                if (associationObject == null || ProxyHelper.isProxyOrCollection(associationObject)) {
                    associationObject = PropertyAccessorHelper.getCollectionInstance(relation.getProperty());
                    PropertyAccessorHelper.set(entity, relation.getProperty(), associationObject);
                }
                ((Collection)associationObject).add(this.getEntity(relationEntity));
            }
        }
    }

    private void parseRelations(Object originalEntity, Object relationEntity, Map<String, Object> relationsMap, PersistenceDelegator pd, EntityMetadata metadata, boolean lazilyloaded, Map<Object, Object> relationStack) {
        for (Relation relation : metadata.getRelations()) {
            EntityMetadata targetEntityMetadata;
            Object relationValue;
            Object entityId;
            if (relation == null) continue;
            FetchType fetchType = relation.getFetchType();
            if (!lazilyloaded && fetchType.equals((Object)FetchType.LAZY)) {
                entityId = PropertyAccessorHelper.getId(relationEntity, metadata);
                this.getAssociationBuilder().setProxyRelationObject(relationEntity, relationsMap, metadata, pd, entityId, relation);
                continue;
            }
            if (relation.isUnary() && relation.getTargetEntity().isAssignableFrom(originalEntity.getClass())) {
                Object associationObject = PropertyAccessorHelper.getObject(relationEntity, relation.getProperty());
                if (relation.getType().equals((Object)Relation.ForeignKey.ONE_TO_ONE)) {
                    if (associationObject != null && !ProxyHelper.isProxyOrCollection(associationObject)) continue;
                    PropertyAccessorHelper.set(relationEntity, relation.getProperty(), originalEntity);
                    continue;
                }
                if (relationsMap == null || !relationsMap.containsKey(relation.getJoinColumnName(this.kunderaMetadata))) continue;
                PropertyAccessorHelper.set(relationEntity, relation.getProperty(), originalEntity);
                continue;
            }
            entityId = PropertyAccessorHelper.getId(relationEntity, metadata);
            List immediateRelations = this.fetchRelations(relation, metadata, pd, entityId, relationValue = relationsMap != null ? relationsMap.get(relation.getJoinColumnName(this.kunderaMetadata)) : null, targetEntityMetadata = KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, relation.getTargetEntity()));
            if (immediateRelations == null || immediateRelations.isEmpty()) continue;
            for (Object immediateRelation : immediateRelations) {
                if (immediateRelation == null) continue;
                if (this.existsInRelationStack(relationStack, immediateRelation, targetEntityMetadata).booleanValue()) {
                    this.setRelationToEntity(relationEntity, this.fetchFromRelationStack(relationStack, immediateRelation, targetEntityMetadata), relation);
                } else {
                    this.addToRelationStack(relationStack, immediateRelation, targetEntityMetadata);
                    this.onParseRelation(relationEntity, pd, targetEntityMetadata, immediateRelation, relation, lazilyloaded, relationStack);
                }
                PersistenceCacheManager.addEntityToPersistenceCache(this.getEntity(relationEntity), pd, PropertyAccessorHelper.getId(relationEntity, metadata));
            }
        }
    }

    private void addToRelationStack(Map<Object, Object> relationStack, Object entity, EntityMetadata m) {
        Object obj = entity;
        if (entity instanceof EnhanceEntity) {
            obj = ((EnhanceEntity)entity).getEntity();
        }
        relationStack.put(obj.getClass().getCanonicalName() + "#" + PropertyAccessorHelper.getId(obj, m), obj);
    }

    private Boolean existsInRelationStack(Map<Object, Object> relationStack, Object entity, EntityMetadata m) {
        Object obj = entity;
        if (entity instanceof EnhanceEntity) {
            obj = ((EnhanceEntity)entity).getEntity();
        }
        return relationStack.containsKey(obj.getClass().getCanonicalName() + "#" + PropertyAccessorHelper.getId(obj, m));
    }

    private Object fetchFromRelationStack(Map<Object, Object> relationStack, Object entity, EntityMetadata m) {
        Object obj = entity;
        if (entity instanceof EnhanceEntity) {
            obj = ((EnhanceEntity)entity).getEntity();
        }
        return relationStack.get(obj.getClass().getCanonicalName() + "#" + PropertyAccessorHelper.getId(obj, m));
    }

    private List fetchRelations(Relation relation, EntityMetadata metadata, PersistenceDelegator pd, Object entityId, Object relationValue, EntityMetadata targetEntityMetadata) {
        List<Object> relationalEntities = new ArrayList<Object>();
        if (relationValue != null && relation.isUnary() || relation.isJoinedByPrimaryKey()) {
            Object relationEntity = pd.getClient(targetEntityMetadata).find(relation.getTargetEntity(), relationValue != null ? relationValue : entityId);
            if (relationEntity != null) {
                relationalEntities.add(relationEntity);
            }
        } else if (!relation.isUnary()) {
            Client associatedClient = pd.getClient(targetEntityMetadata);
            relationalEntities = !MetadataUtils.useSecondryIndex(((ClientBase)((Object)associatedClient)).getClientMetadata()) && MetadataUtils.indexSearchEnabled(targetEntityMetadata.getPersistenceUnit(), this.kunderaMetadata) ? this.getAssociationBuilder().getAssociatedEntitiesFromIndex(relation.getProperty().getDeclaringClass(), entityId, targetEntityMetadata.getEntityClazz(), associatedClient) : associatedClient.findByRelation(relation.getJoinColumnName(this.kunderaMetadata), entityId, relation.getTargetEntity());
        }
        return relationalEntities;
    }

    public Object recursivelyFindEntities(Object entity, Map<String, Object> relationsMap, EntityMetadata m, PersistenceDelegator pd, boolean lazilyLoaded, Map<Object, Object> relationStack) {
        return this.handleAssociation(entity, relationsMap, m, pd, lazilyLoaded, relationStack);
    }

    private Map<String, Object> getPersistedRelations(Object relationEntity) {
        return relationEntity != null && relationEntity.getClass().isAssignableFrom(EnhanceEntity.class) ? ((EnhanceEntity)relationEntity).getRelations() : null;
    }

    private Object getEntity(Object relationEntity) {
        return relationEntity != null && relationEntity.getClass().isAssignableFrom(EnhanceEntity.class) ? ((EnhanceEntity)relationEntity).getEntity() : relationEntity;
    }

    protected List<EnhanceEntity> onAssociationUsingLucene(EntityMetadata m, Client client, List<EnhanceEntity> ls) {
        Set<String> rSet = this.fetchDataFromLucene(m.getEntityClazz(), client);
        List<?> resultList = client.findAll(m.getEntityClazz(), null, rSet.toArray(new String[0]));
        return m.getRelationNames() != null && !m.getRelationNames().isEmpty() ? resultList : this.transform(m, ls, resultList);
    }

    protected List<EnhanceEntity> transform(EntityMetadata m, List<EnhanceEntity> ls, List resultList) {
        if ((ls == null || ls.isEmpty()) && resultList != null && !resultList.isEmpty()) {
            ls = new ArrayList<EnhanceEntity>(resultList.size());
        }
        for (Object r : resultList) {
            if (r == null || r.getClass().isAssignableFrom(EnhanceEntity.class)) continue;
            EnhanceEntity e = new EnhanceEntity(r, this.getId(r, m), null);
            ls.add(e);
        }
        return ls;
    }

    protected Set<String> fetchDataFromLucene(Class<?> clazz, Client client) {
        String luceneQueryFromJPAQuery = KunderaCoreUtils.getLuceneQueryFromJPAQuery(this.kunderaQuery, this.kunderaMetadata);
        Map<String, Object> results = client.getIndexManager().search(clazz, luceneQueryFromJPAQuery);
        HashSet<Object> rSet = new HashSet<Object>(results.values());
        return rSet;
    }

    protected Object getId(Object entity, EntityMetadata metadata) {
        try {
            return PropertyAccessorHelper.getId(entity, metadata);
        }
        catch (PropertyAccessException e) {
            log.error("Error while Getting ID for entity {}, Caused by: {}.", entity, (Object)e);
            throw new EntityReaderException("Error while Getting ID for entity " + entity, e);
        }
    }

    private boolean compareTo(Object relationalEntity, Object originalEntity) {
        if (relationalEntity != null && originalEntity != null && relationalEntity.getClass().isAssignableFrom(originalEntity.getClass())) {
            EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, originalEntity.getClass());
            Object relationalEntityId = PropertyAccessorHelper.getId(relationalEntity, metadata);
            Object originalEntityId = PropertyAccessorHelper.getId(originalEntity, metadata);
            return relationalEntityId.equals(originalEntityId);
        }
        return false;
    }

    private AssociationBuilder getAssociationBuilder() {
        if (this.associationBuilder == null) {
            this.associationBuilder = new AssociationBuilder();
        }
        return this.associationBuilder;
    }
}

