/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.persistence.KunderaEntityTransaction;
import com.impetus.kundera.persistence.TransactionResource;
import java.util.HashMap;
import java.util.Map;

class Coordinator {
    private Map<String, TransactionResource> txResources = new HashMap<String, TransactionResource>();

    void addResource(TransactionResource resource, String pu) {
        this.txResources.put(pu, resource);
    }

    TransactionResource getResource(String pu) {
        return this.txResources.get(pu);
    }

    TransactionResource.Response coordinate(KunderaEntityTransaction.TxAction action) {
        TransactionResource.Response response = TransactionResource.Response.YES;
        switch (action) {
            case BEGIN: {
                for (TransactionResource res : this.txResources.values()) {
                    res.onBegin();
                }
                break;
            }
            case PREPARE: {
                for (TransactionResource res : this.txResources.values()) {
                    res.prepare();
                }
                break;
            }
            case COMMIT: {
                for (TransactionResource res : this.txResources.values()) {
                    res.onCommit();
                }
                break;
            }
            case ROLLBACK: {
                for (TransactionResource res : this.txResources.values()) {
                    res.onRollback();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid transaction action : " + (Object)((Object)action));
            }
        }
        return response;
    }

    boolean isTransactionActive() {
        for (TransactionResource res : this.txResources.values()) {
            if (!res.isActive()) continue;
            return true;
        }
        return false;
    }
}

