/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.persistence.AbstractPredicate;
import com.impetus.kundera.persistence.AggregateExpression;
import com.impetus.kundera.persistence.BetweenPredicate;
import com.impetus.kundera.persistence.ComparisonPredicate;
import com.impetus.kundera.persistence.ConjuctionPredicate;
import com.impetus.kundera.persistence.DefaultCompoundSelection;
import com.impetus.kundera.persistence.DefaultPath;
import com.impetus.kundera.persistence.DisjunctionPredicate;
import com.impetus.kundera.persistence.QueryOrder;
import com.impetus.kundera.query.KunderaQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import org.apache.commons.lang.StringUtils;

public final class CriteriaQueryTranslator {
    static Map<AbstractPredicate.ConditionalOperator, String> conditions = new HashMap<AbstractPredicate.ConditionalOperator, String>();

    public static <S> String translate(CriteriaQuery criteriaQuery) {
        List orderings;
        QueryBuilder builder = new QueryBuilder();
        Selection select = criteriaQuery.getSelection();
        if (select != null) {
            builder.appendSelectClause();
        }
        if (select.getClass().isAssignableFrom(DefaultCompoundSelection.class) && ((CompoundSelection)select).isCompoundSelection()) {
            List selections = ((CompoundSelection)select).getCompoundSelectionItems();
            builder.appendMultiSelect(selections);
        } else if (select instanceof AggregateExpression) {
            builder.appendAggregate(((AggregateExpression)select).getAggregation());
        } else {
            Attribute attribute;
            String alias = select.getAlias();
            if (!StringUtils.isEmpty((String)alias)) {
                builder.appendAlias(alias);
            }
            if ((attribute = ((DefaultPath)select).getAttribute()) != null) {
                builder.appendAttribute(attribute);
            }
        }
        Class clazzType = select.getJavaType();
        Set roots = criteriaQuery.getRoots();
        Root from = (Root)roots.iterator().next();
        Class entityClazz = from.getJavaType();
        builder.appendFromClause();
        builder.appendFrom(entityClazz);
        builder.appendAlias(from.getAlias() != null ? from.getAlias() : select.getAlias());
        Predicate where = criteriaQuery.getRestriction();
        if (where != null) {
            builder.appendWhereClause();
            List expressions = where.getExpressions();
            for (Expression expr : expressions) {
                builder.appendWhere((Expression<Boolean>)expr, from.getAlias());
            }
        }
        if ((orderings = criteriaQuery.getOrderList()) != null) {
            if (!orderings.isEmpty()) {
                builder.appendOrderClause(where == null);
            }
            for (Order order : orderings) {
                builder.appendAlias(from.getAlias() != null ? from.getAlias() : select.getAlias());
                builder.appendOrdering(order);
            }
        }
        return builder.getQuery();
    }

    static {
        conditions.put(AbstractPredicate.ConditionalOperator.EQ, "=");
        conditions.put(AbstractPredicate.ConditionalOperator.LT, "<");
        conditions.put(AbstractPredicate.ConditionalOperator.LTE, "<=");
        conditions.put(AbstractPredicate.ConditionalOperator.GT, ">");
        conditions.put(AbstractPredicate.ConditionalOperator.GTE, ">=");
        conditions.put(AbstractPredicate.ConditionalOperator.BTW, "BETWEEN");
    }

    static class QueryBuilder {
        private StringBuilder builder = new StringBuilder();

        QueryBuilder() {
        }

        QueryBuilder appendAggregate(String aggregation) {
            this.builder.append(aggregation);
            return this;
        }

        public String getQuery() {
            return this.builder.toString();
        }

        QueryBuilder appendSelectClause() {
            this.builder.append("Select");
            this.builder.append(" ");
            return this;
        }

        QueryBuilder appendAlias(String alias) {
            this.builder.append(alias);
            return this;
        }

        QueryBuilder appendOrderClause(boolean prefixSpace) {
            if (prefixSpace) {
                this.builder.append(" ");
            }
            this.builder.append("ORDER BY");
            this.builder.append(" ");
            return this;
        }

        QueryBuilder appendOrdering(Order orderAttribute) {
            DefaultPath expression = (DefaultPath)orderAttribute.getExpression();
            Attribute attrib = expression.getAttribute();
            Attribute embedAttribute = expression.getEmbeddedAttribute();
            String fieldName = null;
            this.builder.append(".");
            if (embedAttribute != null) {
                fieldName = embedAttribute.getName();
                this.builder.append(fieldName);
                this.builder.append(".");
            }
            this.builder.append(attrib.getName());
            KunderaQuery.SortOrder order = ((QueryOrder)orderAttribute).getOrder();
            this.builder.append(" ");
            this.builder.append(order.name());
            return this;
        }

        private QueryBuilder appendMultiSelectSuffix() {
            this.builder.append(",");
            return this;
        }

        QueryBuilder appendMultiSelect(List<Selection<?>> selections) {
            for (Selection<?> s : selections) {
                Attribute attribute = ((DefaultPath)s).getAttribute();
                if (attribute == null) continue;
                this.builder.append(s.getAlias());
                this.appendAttribute(attribute);
                this.appendMultiSelectSuffix();
            }
            this.builder.delete(this.builder.toString().lastIndexOf(","), this.builder.length());
            return this;
        }

        QueryBuilder appendFromClause() {
            this.builder.append(" ");
            this.builder.append("from");
            this.builder.append(" ");
            return this;
        }

        QueryBuilder appendFrom(Class entityClazz) {
            this.builder.append(entityClazz.getSimpleName());
            this.builder.append(" ");
            return this;
        }

        QueryBuilder appendWhereClause() {
            this.builder.append(" ");
            this.builder.append("where");
            this.builder.append(" ");
            return this;
        }

        QueryBuilder appendAttribute(Attribute attrib) {
            this.builder.append(".");
            this.builder.append(attrib.getName());
            return this;
        }

        QueryBuilder appendWhere(Expression<Boolean> expr, String alias) {
            if (expr.getClass().isAssignableFrom(ComparisonPredicate.class)) {
                this.appendValueClause(alias, expr);
            } else {
                List<Object> exprs = new ArrayList();
                if (expr.getClass().isAssignableFrom(ConjuctionPredicate.class)) {
                    exprs = ((ConjuctionPredicate)expr).getExpressions();
                    for (Expression expression : exprs) {
                        this.appendWhere((Expression<Boolean>)expression, alias);
                        this.builder.append("AND");
                        this.builder.append(" ");
                    }
                    this.builder.delete(this.builder.toString().lastIndexOf("AND"), this.builder.length());
                } else if (expr.getClass().isAssignableFrom(DisjunctionPredicate.class)) {
                    exprs = ((DisjunctionPredicate)expr).getExpressions();
                    for (Expression expression : exprs) {
                        this.appendWhere((Expression<Boolean>)expression, alias);
                        this.builder.append("OR");
                        this.builder.append(" ");
                    }
                    this.builder.delete(this.builder.toString().lastIndexOf("OR"), this.builder.length());
                } else if (expr.getClass().isAssignableFrom(BetweenPredicate.class)) {
                    Expression btExpression = ((BetweenPredicate)expr).getExpression();
                    this.appendBTValueClause(alias, btExpression, (BetweenPredicate)expr);
                }
            }
            return this;
        }

        private void appendValueClause(String alias, Expression expr) {
            AbstractPredicate.ConditionalOperator condition2 = ((ComparisonPredicate)expr).getCondition();
            DefaultPath path = (DefaultPath)((ComparisonPredicate)expr).getLhs();
            Object value = ((ComparisonPredicate)expr).getRhs();
            this.builder.append(alias);
            this.builder.append(".");
            if (path.getEmbeddedAttribute() != null) {
                this.builder.append(path.getEmbeddedAttribute().getName());
                this.builder.append(".");
            }
            this.builder.append(path.getAttribute().getName());
            this.builder.append(" ");
            this.builder.append(conditions.get((Object)condition2));
            this.builder.append(" ");
            this.builder.append(value);
            this.builder.append(" ");
        }

        private void appendBTValueClause(String alias, Expression expr, BetweenPredicate btw) {
            DefaultPath path = (DefaultPath)expr;
            this.builder.append(alias);
            this.builder.append(".");
            this.builder.append(path.getAttribute().getName());
            this.builder.append(" ");
            this.builder.append(conditions.get((Object)btw.getCondition()));
            this.builder.append(" ");
            this.builder.append(btw.getLower());
            this.builder.append(" ");
            this.builder.append("AND");
            this.builder.append(" ");
            this.builder.append(btw.getUpper());
        }
    }
}

