/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.client.Client;
import com.impetus.kundera.graph.Node;
import com.impetus.kundera.persistence.TransactionResource;
import com.impetus.kundera.persistence.api.Batcher;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransactionResource
implements TransactionResource {
    private boolean isActive;
    private Client client;
    private static final Logger log = LoggerFactory.getLogger(DefaultTransactionResource.class);
    private List<Node> nodes = new ArrayList<Node>();

    public DefaultTransactionResource(Client client) {
        this.client = client;
    }

    @Override
    public void onBegin() {
        this.isActive = true;
    }

    @Override
    public void onCommit() {
        this.onFlush();
        this.nodes.clear();
        this.nodes = null;
        this.nodes = new ArrayList<Node>();
        this.isActive = false;
    }

    @Override
    public void onFlush() {
        for (Node node : this.nodes) {
            node.flush();
        }
    }

    @Override
    public void onRollback() {
        this.onBatchRollBack();
        this.nodes.clear();
        this.nodes = null;
        this.nodes = new ArrayList<Node>();
        this.isActive = false;
    }

    @Override
    public TransactionResource.Response prepare() {
        return TransactionResource.Response.YES;
    }

    void syncNode(Node node) {
        this.nodes.add(node);
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    private void onBatchRollBack() {
        if (this.client instanceof Batcher) {
            ((Batcher)((Object)this.client)).clear();
        }
    }
}

