/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.KunderaException;
import com.impetus.kundera.PersistenceUtilHelper;
import com.impetus.kundera.cache.CacheException;
import com.impetus.kundera.cache.CacheProvider;
import com.impetus.kundera.cache.NonOperationalCacheProvider;
import com.impetus.kundera.client.ClientResolverException;
import com.impetus.kundera.configure.ClientMetadataBuilder;
import com.impetus.kundera.configure.MetamodelConfiguration;
import com.impetus.kundera.configure.PersistenceUnitConfiguration;
import com.impetus.kundera.loader.ClientFactory;
import com.impetus.kundera.loader.ClientLifeCycleManager;
import com.impetus.kundera.loader.CoreLoader;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.ApplicationMetadata;
import com.impetus.kundera.metadata.model.CoreMetadata;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.persistence.EntityManagerImpl;
import com.impetus.kundera.persistence.KunderaCriteriaBuilder;
import com.impetus.kundera.property.PropertyAccessorHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Cache;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.SynchronizationType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerFactoryImpl
implements EntityManagerFactory {
    private static Logger logger = LoggerFactory.getLogger(EntityManagerFactoryImpl.class);
    private boolean closed;
    private Map<String, Object> properties;
    private CacheProvider cacheProvider;
    private String[] persistenceUnits;
    private PersistenceUnitTransactionType transactionType;
    private final KunderaPersistenceUnitUtil util;
    private final PersistenceUtilHelper.MetadataCache cache = new PersistenceUtilHelper.MetadataCache();
    private Map<String, ClientFactory> clientFactories = new ConcurrentHashMap<String, ClientFactory>();
    private final KunderaMetadata kunderaMetadata = new KunderaMetadata();

    public EntityManagerFactoryImpl(PersistenceUnitInfo puInfo, Map<String, Object> properties) {
        logger.info("Loading Core");
        new CoreLoader().load(this.kunderaMetadata);
        this.configurePersistenceUnit(puInfo, properties);
        this.util = new KunderaPersistenceUnitUtil(this.cache);
        this.configure(puInfo.getPersistenceUnitName(), properties);
    }

    public EntityManagerFactoryImpl(String persistenceUnit, Map<String, Object> properties) {
        logger.info("Loading Core");
        new CoreLoader().load(this.kunderaMetadata);
        this.configurePersistenceUnit(persistenceUnit, properties);
        this.util = new KunderaPersistenceUnitUtil(this.cache);
        this.configure(persistenceUnit, properties);
    }

    private void configure(String persistenceUnit, Map<String, Object> properties) {
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        if (properties != null) {
            propsMap.putAll(properties);
        }
        propsMap.put("persistenceUnitName", persistenceUnit);
        this.properties = propsMap;
        this.persistenceUnits = persistenceUnit.split(",");
        new MetamodelConfiguration(properties, this.kunderaMetadata, this.persistenceUnits).configure();
        this.configureClientFactories();
        HashSet<PersistenceUnitTransactionType> txTypes = new HashSet<PersistenceUnitTransactionType>();
        for (String pu : this.persistenceUnits) {
            PersistenceUnitMetadata puMetadata = KunderaMetadataManager.getPersistenceUnitMetadata(this.kunderaMetadata, pu);
            PersistenceUnitTransactionType txType = KunderaMetadataManager.getPersistenceUnitMetadata(this.kunderaMetadata, pu).getTransactionType();
            txTypes.add(txType);
            if (this.cacheProvider != null) continue;
            this.cacheProvider = this.initSecondLevelCache(puMetadata);
            this.cacheProvider.createCache("Kundera");
        }
        if (txTypes.size() != 1) {
            throw new IllegalArgumentException("For polyglot persistence, it is mandatory for all persistence units to have same Transction type.");
        }
        this.transactionType = (PersistenceUnitTransactionType)txTypes.iterator().next();
        if (logger.isInfoEnabled()) {
            logger.info("EntityManagerFactory created for persistence unit : " + persistenceUnit);
        }
    }

    public final void close() {
        if (this.isOpen()) {
            this.closed = true;
            if (this.cacheProvider != null) {
                this.cacheProvider.shutdown();
            }
            for (String pu : this.persistenceUnits) {
                ((ClientLifeCycleManager)((Object)this.clientFactories.get(pu))).destroy();
            }
        } else {
            throw new IllegalStateException("Entity manager factory has been closed");
        }
        this.persistenceUnits = null;
        this.properties = null;
        this.clientFactories.clear();
        this.clientFactories = new ConcurrentHashMap<String, ClientFactory>();
    }

    public final EntityManager createEntityManager() {
        if (this.isOpen()) {
            return new EntityManagerImpl(this, this.transactionType, PersistenceContextType.EXTENDED);
        }
        throw new IllegalStateException("Entity manager factory has been closed.");
    }

    public final EntityManager createEntityManager(Map map) {
        if (this.isOpen()) {
            return new EntityManagerImpl(this, map, this.transactionType, PersistenceContextType.EXTENDED);
        }
        throw new IllegalStateException("Entity manager factory has been closed.");
    }

    public final boolean isOpen() {
        return !this.closed;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        if (this.isOpen()) {
            return new KunderaCriteriaBuilder(this);
        }
        throw new IllegalStateException("Entity manager factory has been closed.");
    }

    public Metamodel getMetamodel() {
        if (this.isOpen()) {
            MetamodelImpl metamodel = null;
            for (String pu : this.persistenceUnits) {
                metamodel = (MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(pu);
                if (metamodel == null) continue;
                return metamodel;
            }
        }
        throw new IllegalStateException("Entity manager factory has been closed.");
    }

    public Map<String, Object> getProperties() {
        if (this.isOpen()) {
            return this.properties;
        }
        throw new IllegalStateException("Entity manager factory has been closed.");
    }

    public Cache getCache() {
        if (this.isOpen()) {
            return this.cacheProvider.getCache("Kundera");
        }
        throw new IllegalStateException("Entity manager factory has been closed.");
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Entity manager factory has been closed.");
        }
        return this.util;
    }

    private void configureClientFactories() {
        ClientMetadataBuilder builder = new ClientMetadataBuilder(this.getProperties(), this.kunderaMetadata, this.getPersistenceUnits());
        builder.buildClientFactoryMetadata(this.clientFactories, this.kunderaMetadata);
    }

    private CacheProvider initSecondLevelCache(PersistenceUnitMetadata puMetadata) {
        String classResourceName = (String)this.getProperties().get("kundera.cache.config.resource");
        classResourceName = classResourceName != null ? classResourceName : puMetadata.getProperty("kundera.cache.config.resource");
        String cacheProviderClassName = (String)this.getProperties().get("kundera.cache.provider.class");
        cacheProviderClassName = cacheProviderClassName != null ? cacheProviderClassName : puMetadata.getProperty("kundera.cache.provider.class");
        CacheProvider cacheProvider = null;
        if (cacheProviderClassName != null) {
            try {
                Class<?> cacheProviderClass = Class.forName(cacheProviderClassName);
                cacheProvider = (CacheProvider)cacheProviderClass.newInstance();
                cacheProvider.init(classResourceName);
            }
            catch (ClassNotFoundException e) {
                throw new CacheException("Could not find class " + cacheProviderClassName + ". Check whether you spelled it correctly in persistence.xml", e);
            }
            catch (InstantiationException e) {
                throw new CacheException("Could not instantiate " + cacheProviderClassName, e);
            }
            catch (IllegalAccessException e) {
                throw new CacheException(e);
            }
        }
        if (cacheProvider == null) {
            cacheProvider = new NonOperationalCacheProvider();
        }
        return cacheProvider;
    }

    String[] getPersistenceUnits() {
        return this.persistenceUnits;
    }

    ClientFactory getClientFactory(String pu) {
        ClientFactory clientFactory = this.clientFactories.get(pu);
        if (clientFactory != null) {
            return clientFactory;
        }
        logger.error("Client Factory Not Configured For Specified Client Type : ");
        throw new ClientResolverException("Client Factory Not Configured For Specified Client Type.");
    }

    public KunderaMetadata getKunderaMetadataInstance() {
        return this.kunderaMetadata;
    }

    public void addNamedQuery(String paramString, Query paramQuery) {
    }

    public <T> T unwrap(Class<T> paramClass) {
        return null;
    }

    public <T> void addNamedEntityGraph(String paramString, EntityGraph<T> paramEntityGraph) {
    }

    private void configurePersistenceUnit(String persistenceUnit, Map props) {
        if (persistenceUnit == null) {
            throw new KunderaException("Persistence unit name should not be null");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Loading Persistence Unit MetaData For Persistence Unit(s) {}.", (Object)persistenceUnit);
        }
        String[] persistenceUnits = persistenceUnit.split(",");
        new PersistenceUnitConfiguration(props, this.kunderaMetadata, persistenceUnits).configure();
    }

    private void configurePersistenceUnit(PersistenceUnitInfo puInfo, Map props) {
        if (puInfo.getPersistenceUnitName() == null) {
            throw new KunderaException("Persistence unit name should not be null");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Loading Persistence Unit MetaData For Persistence Unit(s) {}.", (Object)puInfo.getPersistenceUnitName());
        }
        String[] persistenceUnits = puInfo.getPersistenceUnitName().split(",");
        new PersistenceUnitConfiguration(props, this.kunderaMetadata, persistenceUnits).configure(puInfo);
    }

    public EntityManager createEntityManager(SynchronizationType paramSynchronizationType) {
        return this.createEntityManager();
    }

    public EntityManager createEntityManager(SynchronizationType paramSynchronizationType, Map paramMap) {
        return this.createEntityManager(paramMap);
    }

    private class KunderaPersistenceUnitUtil
    implements PersistenceUnitUtil {
        private transient PersistenceUtilHelper.MetadataCache cache;

        public KunderaPersistenceUnitUtil(PersistenceUtilHelper.MetadataCache cache) {
            this.cache = cache;
        }

        public boolean isLoaded(Object entity, String attributeName) {
            LoadState state = PersistenceUtilHelper.isLoadedWithoutReference(entity, attributeName, this.cache);
            if (state == LoadState.LOADED) {
                return true;
            }
            if (state == LoadState.NOT_LOADED) {
                return false;
            }
            return PersistenceUtilHelper.isLoadedWithReference(entity, attributeName, this.cache) != LoadState.NOT_LOADED;
        }

        public boolean isLoaded(Object entity) {
            return PersistenceUtilHelper.isLoaded(entity) != LoadState.NOT_LOADED;
        }

        public Object getIdentifier(Object entity) {
            Class<?> entityClass = entity.getClass();
            EntityMetadata entityMetadata = KunderaMetadataManager.getEntityMetadata(EntityManagerFactoryImpl.this.kunderaMetadata, entityClass);
            if (entityMetadata == null) {
                throw new IllegalArgumentException(entityClass + " is not an entity");
            }
            return PropertyAccessorHelper.getId(entity, entityMetadata);
        }
    }

    public static class KunderaMetadata {
        private CoreMetadata coreMetadata;
        private ApplicationMetadata applicationMetadata;

        private KunderaMetadata() {
        }

        public ApplicationMetadata getApplicationMetadata() {
            if (this.applicationMetadata == null) {
                this.applicationMetadata = new ApplicationMetadata();
            }
            return this.applicationMetadata;
        }

        public CoreMetadata getCoreMetadata() {
            return this.coreMetadata;
        }

        public void setApplicationMetadata(ApplicationMetadata applicationMetadata) {
            this.applicationMetadata = applicationMetadata;
        }

        public void setCoreMetadata(CoreMetadata coreMetadata) {
            this.coreMetadata = coreMetadata;
        }
    }
}

