/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.persistence.Coordinator;
import com.impetus.kundera.persistence.EntityManagerImpl;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

public class KunderaEntityTransaction
implements EntityTransaction {
    private EntityManager entityManager;
    private Coordinator coordinator;
    private Boolean rollbackOnly;

    KunderaEntityTransaction(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void begin() {
        if (this.isActive()) {
            throw new IllegalStateException("Transaction is already active");
        }
        this.coordinator = ((EntityManagerImpl)this.entityManager).getPersistenceDelegator().getCoordinator();
        ((EntityManagerImpl)this.entityManager).getPersistenceDelegator().begin();
        this.coordinator.coordinate(TxAction.BEGIN);
    }

    public void commit() {
        if (!this.getRollbackOnly()) {
            this.onTransaction(TxAction.COMMIT);
            ((EntityManagerImpl)this.entityManager).getPersistenceDelegator().commit();
        }
    }

    public boolean getRollbackOnly() {
        if (this.isActive()) {
            return this.rollbackOnly != null ? this.rollbackOnly : false;
        }
        throw new IllegalStateException("No transaction in progress");
    }

    public boolean isActive() {
        return this.coordinator != null && this.coordinator.isTransactionActive();
    }

    public void rollback() {
        this.onTransaction(TxAction.ROLLBACK);
        ((EntityManagerImpl)this.entityManager).getPersistenceDelegator().rollback();
    }

    private void onTransaction(TxAction action) {
        if (!this.isActive()) {
            throw new IllegalStateException("No transaction in progress");
        }
        this.coordinator.coordinate(action);
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    static enum TxAction {
        BEGIN,
        COMMIT,
        ROLLBACK,
        PREPARE;

    }
}

