/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.KunderaException;
import com.impetus.kundera.client.Client;
import com.impetus.kundera.client.ClientPropertiesSetter;
import com.impetus.kundera.client.ClientResolverException;
import com.impetus.kundera.graph.GraphGenerator;
import com.impetus.kundera.graph.Node;
import com.impetus.kundera.graph.ObjectGraph;
import com.impetus.kundera.graph.ObjectGraphUtils;
import com.impetus.kundera.lifecycle.states.ManagedState;
import com.impetus.kundera.lifecycle.states.NodeState;
import com.impetus.kundera.lifecycle.states.RemovedState;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.persistence.Coordinator;
import com.impetus.kundera.persistence.DefaultTransactionResource;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.KunderaTransactionException;
import com.impetus.kundera.persistence.TransactionBinder;
import com.impetus.kundera.persistence.TransactionResource;
import com.impetus.kundera.persistence.api.Batcher;
import com.impetus.kundera.persistence.context.EventLog;
import com.impetus.kundera.persistence.context.FlushManager;
import com.impetus.kundera.persistence.context.MainCache;
import com.impetus.kundera.persistence.context.PersistenceCache;
import com.impetus.kundera.persistence.context.jointable.JoinTableData;
import com.impetus.kundera.persistence.event.EntityEventDispatcher;
import com.impetus.kundera.proxy.LazyInitializerFactory;
import com.impetus.kundera.query.QueryResolver;
import com.impetus.kundera.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistenceDelegator {
    private static final Logger log = LoggerFactory.getLogger(PersistenceDelegator.class);
    private boolean closed;
    private final Map<String, Client> clientMap = new HashMap<String, Client>();
    private final EntityEventDispatcher eventDispatcher = new EntityEventDispatcher();
    private FlushModeType flushMode = FlushModeType.AUTO;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean isTransactionInProgress;
    private final PersistenceCache persistenceCache;
    private final FlushManager flushManager = new FlushManager();
    private boolean enableFlush;
    private Coordinator coordinator;
    private final EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata;

    PersistenceDelegator(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, PersistenceCache pc) {
        this.persistenceCache = pc;
        this.kunderaMetadata = kunderaMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object e) {
        if (e == null) {
            throw new IllegalArgumentException("Entity object is invalid, operation failed. Please check previous log message for details");
        }
        ObjectGraph graph = new GraphGenerator().generateGraph(e, this);
        Node node = graph.getHeadNode();
        try {
            this.lock.writeLock().lock();
            node.setPersistenceDelegator(this);
            node.persist();
            this.flushManager.buildFlushStack(node, EventLog.EventType.INSERT);
            this.flush();
            this.getPersistenceCache().getMainCache().addHeadNode(node);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        graph.clear();
        graph = null;
        if (log.isDebugEnabled()) {
            log.debug("Data persisted successfully for entity {}.", e.getClass());
        }
    }

    public <E> E findById(Class<E> entityClass, Object primaryKey) {
        E e = this.find(entityClass, primaryKey);
        if (e == null) {
            return null;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E> E find(Class<E> entityClass, Object primaryKey) {
        if (primaryKey == null) {
            throw new IllegalArgumentException("PrimaryKey value must not be null for object you want to find.");
        }
        EntityMetadata entityMetadata = this.getMetadata(entityClass);
        String nodeId = ObjectGraphUtils.getNodeId(primaryKey, entityClass);
        MainCache mainCache = (MainCache)this.getPersistenceCache().getMainCache();
        Node node = mainCache.getNodeFromCache(nodeId, this);
        if (node == null || node.isDirty()) {
            node = new Node(nodeId, entityClass, (NodeState)new ManagedState(), this.getPersistenceCache(), primaryKey, this);
            node.setClient(this.getClient(entityMetadata));
            node.setPersistenceDelegator(this);
            try {
                this.lock.readLock().lock();
                node.find();
            }
            finally {
                this.lock.readLock().unlock();
            }
        } else {
            node.setPersistenceDelegator(this);
        }
        Object nodeData = node.getData();
        if (nodeData == null) {
            return null;
        }
        Object e = ObjectUtils.deepCopy(nodeData, this.getKunderaMetadata());
        this.onSetProxyOwners(entityMetadata, e);
        return (E)e;
    }

    public <E> List<E> find(Class<E> entityClass, Object ... primaryKeys) {
        ArrayList<E> entities = new ArrayList<E>();
        if (primaryKeys == null) {
            return entities;
        }
        HashSet<Object> pKeys = new HashSet<Object>(Arrays.asList(primaryKeys));
        for (Object e : pKeys) {
            E e2 = this.find(entityClass, e);
            if (e2 == null) continue;
            entities.add(e2);
        }
        return entities;
    }

    public <E> List<E> find(Class<E> entityClass, Map<String, String> embeddedColumnMap) {
        EntityMetadata entityMetadata = this.getMetadata(entityClass);
        List entities = new ArrayList();
        entities = this.getClient(entityMetadata).find(entityClass, embeddedColumnMap);
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object e) {
        if (e == null) {
            throw new IllegalArgumentException("Entity to be removed must not be null.");
        }
        EntityMetadata metadata = this.getMetadata(e.getClass());
        ObjectGraph graph = new GraphGenerator().generateGraph(e, this, new ManagedState());
        Node node = graph.getHeadNode();
        try {
            this.lock.writeLock().lock();
            node.setPersistenceDelegator(this);
            node.remove();
            this.flushManager.buildFlushStack(node, EventLog.EventType.DELETE);
            this.flush();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        graph.clear();
        graph = null;
        if (log.isDebugEnabled()) {
            log.debug("Data removed successfully for entity : " + e.getClass());
        }
    }

    private void flush() {
        Deque<Node> fs = this.flushManager.getFlushStack();
        if (log.isDebugEnabled()) {
            log.debug("Flushing following flush stack to database(s) (showing stack objects from top to bottom):\n" + fs);
        }
        if (fs != null) {
            boolean isBatch = false;
            while (!fs.isEmpty()) {
                Node node = fs.pop();
                if (!node.isInState(ManagedState.class) && !node.isInState(RemovedState.class)) continue;
                EntityMetadata metadata = this.getMetadata(node.getDataClass());
                node.setClient(this.getClient(metadata));
                if (node.getClient() instanceof Batcher && ((Batcher)((Object)node.getClient())).getBatchSize() > 0) {
                    isBatch = true;
                    ((Batcher)((Object)node.getClient())).addBatch(node);
                    continue;
                }
                if (this.isTransactionInProgress && MetadataUtils.defaultTransactionSupported(metadata.getPersistenceUnit(), this.kunderaMetadata)) {
                    this.onSynchronization(node, metadata);
                    continue;
                }
                node.flush();
            }
            if (!isBatch) {
                this.flushJoinTableData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E merge(E e) {
        if (log.isDebugEnabled()) {
            log.debug("Merging Entity : " + e);
        }
        if (e == null) {
            throw new IllegalArgumentException("Entity to be merged must not be null.");
        }
        EntityMetadata m = this.getMetadata(e.getClass());
        ObjectGraph graph = new GraphGenerator().generateGraph(e, this);
        Node node = graph.getHeadNode();
        try {
            this.lock.writeLock().lock();
            node.setPersistenceDelegator(this);
            node.merge();
            this.flushManager.buildFlushStack(node, EventLog.EventType.UPDATE);
            this.flush();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        graph.clear();
        graph = null;
        return (E)node.getData();
    }

    public void detach(Object entity) {
        Node node = this.getPersistenceCache().getMainCache().getNodeFromCache(entity, this.getMetadata(entity.getClass()), this);
        if (node != null) {
            node.detach();
        }
    }

    public Client getClient(EntityMetadata m) {
        if (m == null) {
            throw new KunderaException("Entitymatadata should not be null");
        }
        String persistenceUnit = m.getPersistenceUnit();
        return this.getClient(persistenceUnit);
    }

    public Client getClient(String persistenceUnit) {
        Client client = this.clientMap.get(persistenceUnit);
        if (client == null) {
            throw new ClientResolverException("No client configured for persistenceUnit " + persistenceUnit);
        }
        return client;
    }

    public EntityEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    Query createQuery(String jpaQuery) {
        return this.getQueryInstance(jpaQuery, false, null);
    }

    Query createQuery(String jpaQuery, String persistenceUnit) {
        Client client = this.getClient(persistenceUnit);
        EntityMetadata metadata = null;
        try {
            metadata = KunderaMetadataManager.getMetamodel(this.kunderaMetadata, client.getPersistenceUnit()).getEntityMetadataMap().values().iterator().next();
        }
        catch (Exception e) {
            log.info("Entity metadata is null. Proceeding as Scalar Query.");
        }
        Query query = new QueryResolver().getQueryImplementation(jpaQuery, this.getClient(persistenceUnit).getQueryImplementor(), this, metadata, persistenceUnit);
        return query;
    }

    Query createNativeQuery(String jpaQuery, Class resultClass) {
        return this.getQueryInstance(jpaQuery, true, resultClass);
    }

    private Query getQueryInstance(String jpaQuery, boolean isNative, Class mappedClass) {
        Query query = new QueryResolver().getQueryImplementation(jpaQuery, this, mappedClass, isNative, this.kunderaMetadata);
        return query;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    void close() {
        this.doFlush();
        if (!this.clientMap.isEmpty()) {
            for (Client client : this.clientMap.values()) {
                client.close();
            }
            this.clientMap.clear();
        }
        this.onClearProxy();
        this.closed = true;
    }

    private void onClearProxy() {
        LazyInitializerFactory lazyInitializerrFactory;
        if (this.kunderaMetadata.getCoreMetadata() != null && (lazyInitializerrFactory = this.kunderaMetadata.getCoreMetadata().getLazyInitializerFactory()) != null) {
            lazyInitializerrFactory.clearProxies();
        }
    }

    private void onSetProxyOwners(EntityMetadata m, Object e) {
        LazyInitializerFactory lazyInitializerrFactory;
        if (this.kunderaMetadata.getCoreMetadata() != null && (lazyInitializerrFactory = this.kunderaMetadata.getCoreMetadata().getLazyInitializerFactory()) != null) {
            lazyInitializerrFactory.setProxyOwners(m, e);
        }
    }

    void clear() {
        this.flushManager.clearFlushStack();
        this.getPersistenceCache().clean();
        this.onClearProxy();
    }

    boolean contains(Object entity) {
        Node node = this.getPersistenceCache().getMainCache().getNodeFromCache(entity, this.getMetadata(entity.getClass()), this);
        return node != null && node.isInState(ManagedState.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity) {
        if (this.contains(entity)) {
            MainCache mainCache = (MainCache)this.getPersistenceCache().getMainCache();
            Node node = mainCache.getNodeFromCache(entity, this.getMetadata(entity.getClass()), this);
            try {
                this.lock.readLock().lock();
                node.setPersistenceDelegator(this);
                node.refresh();
            }
            finally {
                this.lock.readLock().unlock();
            }
        } else {
            throw new IllegalArgumentException("This is not a valid or managed entity, can't be refreshed");
        }
    }

    private EntityMetadata getMetadata(Class<?> clazz) {
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, clazz);
        if (metadata == null) {
            log.error("Entity metadata not found for {}, possible reasons may be: 1) not annotated with @Entity. 2) is annotated with @MappedSuperclass.3) does not properly with mapped persistence unit for persistence unit and keyspace. Please verify with @Table annotation or persistence.xml " + clazz);
            throw new KunderaException("Entity metadata not found for " + clazz.getName());
        }
        return metadata;
    }

    void setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
    }

    public boolean isTransactionInProgress() {
        return this.isTransactionInProgress;
    }

    public PersistenceCache getPersistenceCache() {
        return this.persistenceCache;
    }

    void begin() {
        this.isTransactionInProgress = true;
    }

    void commit() {
        this.enableFlush = true;
        this.execute();
        this.flushManager.commit();
        this.flushManager.clearFlushStack();
        this.isTransactionInProgress = false;
        this.enableFlush = false;
    }

    void doFlush() {
        this.enableFlush = true;
        this.flush();
        this.execute();
        this.enableFlush = false;
        this.flushManager.commit();
        this.flushManager.clearFlushStack();
    }

    void rollback() {
        this.flushManager.rollback(this);
        this.flushManager.clearFlushStack();
        this.getPersistenceCache().clean();
        this.isTransactionInProgress = false;
    }

    void populateClientProperties(Map properties) {
        if (properties != null && !properties.isEmpty()) {
            Map<String, Client> clientMap = this.getDelegate();
            if (!clientMap.isEmpty()) {
                for (Client client : clientMap.values()) {
                    if (!(client instanceof ClientPropertiesSetter)) continue;
                    ClientPropertiesSetter cps = (ClientPropertiesSetter)((Object)client);
                    cps.populateClientProperties(client, properties);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Can't set Client properties as None/ Null was supplied");
        }
    }

    void loadClient(String persistenceUnit, Client client) {
        if (!this.clientMap.containsKey(persistenceUnit) && client != null) {
            this.clientMap.put(persistenceUnit, client);
        }
    }

    Map<String, Client> getDelegate() {
        return this.clientMap;
    }

    private void execute() {
        for (Client client : this.clientMap.values()) {
            if (client == null || !(client instanceof Batcher) || ((Batcher)((Object)client)).getBatchSize() != 0 && ((Batcher)((Object)client)).executeBatch() <= 0) continue;
            this.flushJoinTableData();
        }
    }

    private void flushJoinTableData() {
        if (this.applyFlush()) {
            for (JoinTableData jtData : this.flushManager.getJoinTableData()) {
                if (jtData.isProcessed()) continue;
                EntityMetadata m = KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, jtData.getEntityClass());
                Client client = this.getClient(m);
                if (JoinTableData.OPERATION.INSERT.equals((Object)jtData.getOperation())) {
                    client.persistJoinTable(jtData);
                    jtData.setProcessed(true);
                    continue;
                }
                if (!JoinTableData.OPERATION.DELETE.equals((Object)jtData.getOperation())) continue;
                for (Object pk : jtData.getJoinTableRecords().keySet()) {
                    client.deleteByColumn(m.getSchema(), jtData.getJoinTableName(), ((AbstractAttribute)m.getIdAttribute()).getJPAColumnName(), pk);
                }
                jtData.setProcessed(true);
            }
        }
    }

    private boolean applyFlush() {
        return !this.isTransactionInProgress && this.flushMode.equals((Object)FlushModeType.AUTO) || this.enableFlush;
    }

    Coordinator getCoordinator() {
        this.coordinator = new Coordinator();
        try {
            for (String pu : this.clientMap.keySet()) {
                PersistenceUnitMetadata puMetadata = KunderaMetadataManager.getPersistenceUnitMetadata(this.kunderaMetadata, pu);
                String txResource = puMetadata.getProperty("kundera.transaction.resource.class");
                if (txResource != null) {
                    TransactionResource resource = (TransactionResource)Class.forName(txResource).newInstance();
                    this.coordinator.addResource(resource, pu);
                    Client client = this.clientMap.get(pu);
                    if (!(client instanceof TransactionBinder)) {
                        throw new KunderaTransactionException("Client : " + client.getClass() + " must implement TransactionBinder interface, if {kundera.transaction.resource.class} property provided!");
                    }
                    ((TransactionBinder)((Object)client)).bind(resource);
                    continue;
                }
                this.coordinator.addResource(new DefaultTransactionResource(this.clientMap.get(pu)), pu);
            }
        }
        catch (Exception e) {
            log.error("Error while initializing Transaction Resource:", (Throwable)e);
            throw new KunderaTransactionException(e);
        }
        return this.coordinator;
    }

    private void onSynchronization(Node node, EntityMetadata metadata) {
        DefaultTransactionResource resource = (DefaultTransactionResource)this.coordinator.getResource(metadata.getPersistenceUnit());
        if (this.enableFlush) {
            resource.onFlush();
        } else {
            resource.syncNode(node);
        }
    }

    public EntityManagerFactoryImpl.KunderaMetadata getKunderaMetadata() {
        return this.kunderaMetadata;
    }
}

