/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence.context;

import com.impetus.kundera.cache.Cache;
import com.impetus.kundera.graph.Node;
import com.impetus.kundera.graph.NodeLink;
import com.impetus.kundera.graph.ObjectGraph;
import com.impetus.kundera.graph.ObjectGraphUtils;
import com.impetus.kundera.lifecycle.states.ManagedState;
import com.impetus.kundera.lifecycle.states.NodeState;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.persistence.context.PersistenceCache;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.utils.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheBase {
    private static Logger log = LoggerFactory.getLogger(CacheBase.class);
    private Map<String, Node> nodeMappings;
    private Set<Node> headNodes = new HashSet<Node>();
    private Cache l2Cache;
    private PersistenceCache persistenceCache;

    public CacheBase(Cache l2Cache, PersistenceCache pc) {
        this.nodeMappings = new ConcurrentHashMap<String, Node>();
        this.l2Cache = l2Cache;
        this.persistenceCache = pc;
    }

    public Node getNodeFromCache(String nodeId, PersistenceDelegator pd) {
        Node node = this.nodeMappings.get(nodeId);
        return node != null ? node : this.lookupL2Cache(nodeId, pd);
    }

    public Node getNodeFromCache(Object entity, EntityMetadata entityMetadata, PersistenceDelegator pd) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity is null, can't check whether it's in persistence context");
        }
        Object primaryKey = PropertyAccessorHelper.getId(entity, entityMetadata);
        if (primaryKey == null) {
            throw new IllegalArgumentException("Primary key not set into entity");
        }
        String nodeId = ObjectGraphUtils.getNodeId(primaryKey, entity.getClass());
        return this.getNodeFromCache(nodeId, pd);
    }

    public synchronized void addNodeToCache(Node node) {
        Object nodeDataCopy = ObjectUtils.deepCopy(node.getData(), node.getPersistenceDelegator().getKunderaMetadata());
        node.setData(nodeDataCopy);
        this.processNodeMapping(node);
        if (this.l2Cache != null) {
            this.l2Cache.put(node.getNodeId(), node.getData());
        }
    }

    public void processNodeMapping(Node node) {
        if (this.nodeMappings.containsKey(node.getNodeId())) {
            Node existingNode = this.nodeMappings.get(node.getNodeId());
            if (existingNode.getParents() != null) {
                if (node.getParents() == null) {
                    node.setParents(new HashMap<NodeLink, Node>());
                }
                node.getParents().putAll(existingNode.getParents());
            }
            if (existingNode.getChildren() != null) {
                if (node.getChildren() == null) {
                    node.setChildren(new HashMap<NodeLink, Node>());
                }
                node.getChildren().putAll(existingNode.getChildren());
            }
            this.nodeMappings.put(node.getNodeId(), node);
            this.logCacheEvent("ADDED TO ", node.getNodeId());
        } else {
            this.logCacheEvent("ADDED TO ", node.getNodeId());
            this.nodeMappings.put(node.getNodeId(), node);
        }
        if (node.isHeadNode()) {
            node.getPersistenceCache().getMainCache().addHeadNode(node);
        }
    }

    public synchronized void removeNodeFromCache(Node node) {
        if (this.getHeadNodes().contains(node)) {
            this.getHeadNodes().remove(node);
        }
        if (this.nodeMappings.get(node.getNodeId()) != null) {
            this.nodeMappings.remove(node.getNodeId());
        }
        this.evictFroml2Cache(node);
        this.logCacheEvent("REMOVED FROM ", node.getNodeId());
        node = null;
    }

    public void addGraphToCache(ObjectGraph graph, PersistenceCache persistenceCache) {
        for (String key : graph.getNodeMapping().keySet()) {
            Node thisNode = graph.getNodeMapping().get(key);
            this.addNodeToCache(thisNode);
            if (thisNode.isHeadNode() || !persistenceCache.getMainCache().getHeadNodes().contains(thisNode)) continue;
            persistenceCache.getMainCache().getHeadNodes().remove(thisNode);
        }
        this.addHeadNode(graph.getHeadNode());
    }

    private void logCacheEvent(String eventType, String nodeId) {
        if (log.isDebugEnabled()) {
            log.debug("Node: " + nodeId + ":: " + eventType + " Persistence Context");
        }
    }

    public void setNodeMappings(Map<String, Node> nodeMappings) {
        this.nodeMappings = nodeMappings;
    }

    public synchronized void addHeadNode(Node headNode) {
        this.headNodes.add(headNode);
    }

    public int size() {
        return this.nodeMappings.size();
    }

    public Collection<Node> getAllNodes() {
        return this.nodeMappings.values();
    }

    public void clear() {
        if (this.nodeMappings != null) {
            this.nodeMappings.clear();
        }
        if (this.headNodes != null) {
            this.headNodes.clear();
        }
        if (this.l2Cache != null) {
            this.l2Cache.evictAll();
        }
    }

    public Set<Node> getHeadNodes() {
        return Collections.synchronizedSet(this.headNodes);
    }

    private Node lookupL2Cache(String nodeId, PersistenceDelegator pd) {
        Object entity;
        Node node = null;
        if (this.l2Cache != null && (entity = this.l2Cache.get(nodeId)) != null) {
            node = new Node(nodeId, entity.getClass(), (NodeState)new ManagedState(), this.persistenceCache, (Object)nodeId.substring(nodeId.indexOf("$") + 1), pd);
            node.setData(entity);
        }
        return node;
    }

    private void evictFroml2Cache(Node node) {
        if (this.l2Cache != null) {
            this.l2Cache.evict(node.getDataClass(), node.getNodeId());
        }
    }
}

