/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence.context;

import com.impetus.kundera.KunderaException;
import com.impetus.kundera.persistence.context.EventLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class EventLogQueue {
    private Map<Object, EventLog> insertEvents;
    private Map<Object, EventLog> updateEvents;
    private Map<Object, EventLog> deleteEvents;

    EventLogQueue() {
    }

    void onEvent(EventLog log, EventLog.EventType eventType) {
        switch (eventType) {
            case INSERT: {
                this.onInsert(log);
                break;
            }
            case UPDATE: {
                this.onUpdate(log);
                break;
            }
            case DELETE: {
                this.onDelete(log);
                break;
            }
            default: {
                throw new KunderaException("Invalid event type:" + (Object)((Object)eventType));
            }
        }
    }

    private void onDelete(EventLog log) {
        if (this.deleteEvents == null) {
            this.deleteEvents = new ConcurrentHashMap<Object, EventLog>();
        }
        this.deleteEvents.put(log.getEntityId(), log);
    }

    private void onUpdate(EventLog log) {
        if (this.updateEvents == null) {
            this.updateEvents = new ConcurrentHashMap<Object, EventLog>();
        }
        this.updateEvents.put(log.getEntityId(), log);
    }

    private void onInsert(EventLog log) {
        if (this.insertEvents == null) {
            this.insertEvents = new ConcurrentHashMap<Object, EventLog>();
        }
        this.insertEvents.put(log.getEntityId(), log);
    }

    void clear() {
        if (this.insertEvents != null) {
            this.insertEvents.clear();
            this.insertEvents = null;
        }
        if (this.updateEvents != null) {
            this.updateEvents.clear();
            this.updateEvents = null;
        }
        if (this.deleteEvents != null) {
            this.deleteEvents.clear();
            this.deleteEvents = null;
        }
    }

    Map<Object, EventLog> getInsertEvents() {
        return this.insertEvents;
    }

    Map<Object, EventLog> getUpdateEvents() {
        return this.updateEvents;
    }

    Map<Object, EventLog> getDeleteEvents() {
        return this.deleteEvents;
    }
}

