/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence.context;

import com.impetus.kundera.graph.Node;
import com.impetus.kundera.graph.ObjectGraphUtils;
import com.impetus.kundera.lifecycle.states.ManagedState;
import com.impetus.kundera.lifecycle.states.NodeState;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.persistence.context.CacheBase;
import com.impetus.kundera.persistence.context.MainCache;
import com.impetus.kundera.persistence.context.PersistenceCache;

public class PersistenceCacheManager {
    private PersistenceCache persistenceCache;

    public PersistenceCacheManager(PersistenceCache pc) {
        this.persistenceCache = pc;
    }

    public void clearPersistenceCache() {
        this.persistenceCache.clean();
    }

    private void cleanIndividualCache(CacheBase cache) {
        for (Node node : cache.getAllNodes()) {
            node.clear();
        }
    }

    public void markAllNodesNotTraversed() {
        for (Node node : this.persistenceCache.getMainCache().getAllNodes()) {
            node.setTraversed(false);
        }
    }

    public static void addEntityToPersistenceCache(Object entity, PersistenceDelegator pd, Object entityId) {
        MainCache mainCache = (MainCache)pd.getPersistenceCache().getMainCache();
        String nodeId = ObjectGraphUtils.getNodeId(entityId, entity.getClass());
        Node node = new Node(nodeId, entity.getClass(), (NodeState)new ManagedState(), pd.getPersistenceCache(), entityId, pd);
        node.setData(entity);
        node.setPersistenceDelegator(pd);
        mainCache.addNodeToCache(node);
    }
}

