/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence.event;

import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.persistence.event.CallbackMethod;
import com.impetus.kundera.persistence.event.EventListenerException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class InternalCallbackMethod
implements CallbackMethod {
    private final EntityMetadata entityMetadata;
    private Method method;

    public InternalCallbackMethod(EntityMetadata entityMetadata, Method method) {
        this.entityMetadata = entityMetadata;
        this.method = method;
    }

    @Override
    public void invoke(Object entity) throws EventListenerException {
        if (!this.method.isAccessible()) {
            this.method.setAccessible(true);
        }
        try {
            this.method.invoke(entity, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new EventListenerException(e);
        }
        catch (IllegalAccessException e) {
            throw new EventListenerException(e);
        }
        catch (InvocationTargetException e) {
            throw new EventListenerException(e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.entityMetadata.getEntityClazz().getName() + "." + this.method.getName());
        return builder.toString();
    }
}

