/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property;

import com.impetus.kundera.gis.geometry.Point;
import com.impetus.kundera.property.PropertyAccessor;
import com.impetus.kundera.property.accessor.BigDecimalAccessor;
import com.impetus.kundera.property.accessor.BigIntegerAccessor;
import com.impetus.kundera.property.accessor.BooleanAccessor;
import com.impetus.kundera.property.accessor.ByteAccessor;
import com.impetus.kundera.property.accessor.CalendarAccessor;
import com.impetus.kundera.property.accessor.CharAccessor;
import com.impetus.kundera.property.accessor.DateAccessor;
import com.impetus.kundera.property.accessor.DoubleAccessor;
import com.impetus.kundera.property.accessor.EnumAccessor;
import com.impetus.kundera.property.accessor.FloatAccessor;
import com.impetus.kundera.property.accessor.IntegerAccessor;
import com.impetus.kundera.property.accessor.LongAccessor;
import com.impetus.kundera.property.accessor.ObjectAccessor;
import com.impetus.kundera.property.accessor.PointAccessor;
import com.impetus.kundera.property.accessor.SQLDateAccessor;
import com.impetus.kundera.property.accessor.SQLTimeAccessor;
import com.impetus.kundera.property.accessor.SQLTimestampAccessor;
import com.impetus.kundera.property.accessor.ShortAccessor;
import com.impetus.kundera.property.accessor.StringAccessor;
import com.impetus.kundera.property.accessor.UUIDAccessor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PropertyAccessorFactory {
    public static Map<Class<?>, PropertyAccessor<?>> map = new HashMap();
    public static final PropertyAccessor<String> STRING;

    private PropertyAccessorFactory() {
    }

    public static PropertyAccessor getPropertyAccessor(Class<?> clazz) {
        PropertyAccessor<Enum> accessor = clazz.isEnum() ? new EnumAccessor() : map.get(clazz);
        if (null == accessor) {
            accessor = clazz.getName().indexOf("$") > 0 ? map.get(Enum.class) : map.get(Object.class);
        }
        return accessor;
    }

    public static PropertyAccessor<?> getPropertyAccessor(Field property) {
        return PropertyAccessorFactory.getPropertyAccessor(property.getType());
    }

    public static void add(Class<?> key, PropertyAccessor<?> value) {
        map.put(key, value);
    }

    static {
        map.put(Boolean.TYPE, new BooleanAccessor());
        map.put(Byte.TYPE, new ByteAccessor());
        map.put(Short.TYPE, new ShortAccessor());
        map.put(Character.TYPE, new CharAccessor());
        map.put(Integer.TYPE, new IntegerAccessor());
        map.put(Long.TYPE, new LongAccessor());
        map.put(Float.TYPE, new FloatAccessor());
        map.put(Double.TYPE, new DoubleAccessor());
        map.put(Boolean.class, new BooleanAccessor());
        map.put(Byte.class, new ByteAccessor());
        map.put(Short.class, new ShortAccessor());
        map.put(Character.class, new CharAccessor());
        map.put(Integer.class, new IntegerAccessor());
        map.put(Long.class, new LongAccessor());
        map.put(Float.class, new FloatAccessor());
        map.put(Double.class, new DoubleAccessor());
        map.put(java.util.Date.class, new DateAccessor());
        map.put(Date.class, new SQLDateAccessor());
        map.put(Time.class, new SQLTimeAccessor());
        map.put(Timestamp.class, new SQLTimestampAccessor());
        map.put(Calendar.class, new CalendarAccessor());
        map.put(GregorianCalendar.class, new CalendarAccessor());
        map.put(BigInteger.class, new BigIntegerAccessor());
        map.put(BigDecimal.class, new BigDecimalAccessor());
        map.put(String.class, new StringAccessor());
        map.put(Object.class, new ObjectAccessor());
        map.put(Enum.class, new EnumAccessor());
        map.put(UUID.class, new UUIDAccessor());
        map.put(Point.class, new PointAccessor());
        STRING = new StringAccessor();
    }
}

