/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property;

import com.impetus.kundera.client.EnhanceEntity;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import com.impetus.kundera.property.PropertyAccessorFactory;
import com.impetus.kundera.utils.ReflectUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyAccessorHelper {
    public static void set(Object target, Field field, byte[] bytes) {
        PropertyAccessor<?> accessor = PropertyAccessorFactory.getPropertyAccessor(field);
        Object value = accessor.fromBytes(field.getType(), bytes);
        PropertyAccessorHelper.set(target, field, value);
    }

    public static void set(Object target, Field field, String fieldVal) {
        PropertyAccessor<?> accessor = PropertyAccessorFactory.getPropertyAccessor(field);
        Object value = accessor.fromString(target.getClass(), fieldVal);
        PropertyAccessorHelper.set(target, field, value);
    }

    public static void set(Object target, Field field, Object value) {
        if (target != null) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                field.set(target, value);
            }
            catch (IllegalArgumentException iarg) {
                throw new PropertyAccessException(iarg);
            }
            catch (IllegalAccessException iacc) {
                throw new PropertyAccessException(iacc);
            }
        }
    }

    public static Object getObject(Object from, Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return field.get(from);
        }
        catch (IllegalArgumentException iarg) {
            throw new PropertyAccessException(iarg);
        }
        catch (IllegalAccessException iacc) {
            throw new PropertyAccessException(iacc);
        }
    }

    public static Object getObjectCopy(Object from, Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            PropertyAccessor<?> accessor = PropertyAccessorFactory.getPropertyAccessor(field);
            return accessor.getCopy(field.get(from));
        }
        catch (IllegalArgumentException iarg) {
            throw new PropertyAccessException(iarg);
        }
        catch (IllegalAccessException iacc) {
            throw new PropertyAccessException(iacc);
        }
    }

    public static String getString(Object from, Field field) {
        PropertyAccessor<?> accessor = PropertyAccessorFactory.getPropertyAccessor(field);
        Object object = PropertyAccessorHelper.getObject(from, field);
        return object != null ? accessor.toString(object) : null;
    }

    public static byte[] get(Object from, Field field) {
        PropertyAccessor<?> accessor = PropertyAccessorFactory.getPropertyAccessor(field);
        return accessor.toBytes(PropertyAccessorHelper.getObject(from, field));
    }

    public static Object getId(Object entity, EntityMetadata metadata) {
        if (entity instanceof EnhanceEntity) {
            return ((EnhanceEntity)entity).getEntityId();
        }
        return PropertyAccessorHelper.getObject(entity, (Field)metadata.getIdAttribute().getJavaMember());
    }

    public static void setId(Object entity, EntityMetadata metadata, Object rowKey) {
        try {
            Field idField = (Field)metadata.getIdAttribute().getJavaMember();
            PropertyAccessorHelper.set(entity, idField, rowKey);
        }
        catch (IllegalArgumentException iarg) {
            throw new PropertyAccessException(iarg);
        }
    }

    public static void setId(Object entity, EntityMetadata metadata, byte[] rowKey) {
        try {
            Field idField = (Field)metadata.getIdAttribute().getJavaMember();
            PropertyAccessorHelper.set(entity, idField, rowKey);
        }
        catch (IllegalArgumentException iarg) {
            throw new PropertyAccessException(iarg);
        }
    }

    public static final Object getObject(Object obj, String fieldName) {
        try {
            Field embeddedField = obj.getClass().getDeclaredField(fieldName);
            if (embeddedField != null) {
                Object embededObject;
                if (!embeddedField.isAccessible()) {
                    embeddedField.setAccessible(true);
                }
                if ((embededObject = embeddedField.get(obj)) == null) {
                    Class<?> embeddedObjectClass = embeddedField.getType();
                    if (Collection.class.isAssignableFrom(embeddedObjectClass)) {
                        if (embeddedObjectClass.equals(List.class)) {
                            return new ArrayList();
                        }
                        if (embeddedObjectClass.equals(Set.class)) {
                            return new HashSet();
                        }
                    } else {
                        embededObject = embeddedField.getType().newInstance();
                        embeddedField.set(obj, embededObject);
                    }
                }
                return embededObject;
            }
            throw new PropertyAccessException("Embedded object not found: " + fieldName);
        }
        catch (Exception e) {
            throw new PropertyAccessException(e);
        }
    }

    public static Class<?> getGenericClass(Field collectionField) {
        Type[] arguments;
        Type[] parameters;
        Class<?> genericClass = null;
        if (collectionField == null) {
            return genericClass;
        }
        if (PropertyAccessorHelper.isCollection(collectionField.getType()) && (parameters = ReflectUtils.getTypeArguments(collectionField)) != null) {
            if (parameters.length == 1) {
                genericClass = PropertyAccessorHelper.toClass(parameters[0]);
            } else {
                throw new PropertyAccessException("Can't determine generic class from a field that has more than one parameters.");
            }
        }
        if (collectionField.getType().isAssignableFrom(Map.class) && (arguments = ((ParameterizedType)collectionField.getGenericType()).getActualTypeArguments()) != null && arguments.length > 1) {
            genericClass = PropertyAccessorHelper.getTypedClass(arguments[1]);
        }
        return genericClass != null ? genericClass : collectionField.getType();
    }

    public static List<Class<?>> getGenericClasses(Field collectionField) {
        ArrayList genericClasses = new ArrayList();
        if (collectionField == null) {
            return genericClasses;
        }
        Type[] parameters = ReflectUtils.getTypeArguments(collectionField);
        if (parameters != null) {
            for (Type parameter : parameters) {
                genericClasses.add(PropertyAccessorHelper.toClass(parameter));
            }
        }
        return genericClasses;
    }

    public static Field[] getDeclaredFields(Field relationalField) {
        Field[] fields = PropertyAccessorHelper.isCollection(relationalField.getType()) ? PropertyAccessorHelper.getGenericClass(relationalField).getDeclaredFields() : relationalField.getType().getDeclaredFields();
        return fields;
    }

    public static final boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public static final Object getObject(Class<?> clazz) {
        PropertyAccessor accessor = PropertyAccessorFactory.getPropertyAccessor(clazz);
        return accessor.getInstance(clazz);
    }

    public static final byte[] toBytes(Object o, Field f) {
        PropertyAccessor<?> accessor = PropertyAccessorFactory.getPropertyAccessor(f);
        return accessor.toBytes(o);
    }

    public static final byte[] toBytes(Object o, Class c) {
        PropertyAccessor accessor = PropertyAccessorFactory.getPropertyAccessor(c);
        return accessor.toBytes(o);
    }

    public static Object fromSourceToTargetClass(Class<?> targetClass, Class<?> sourceClass, Object o) {
        if (!targetClass.equals(sourceClass)) {
            PropertyAccessor accessor = PropertyAccessorFactory.getPropertyAccessor(sourceClass);
            String s = accessor.toString(o);
            accessor = PropertyAccessorFactory.getPropertyAccessor(targetClass);
            return accessor.fromString(targetClass, s);
        }
        return o;
    }

    public static Object fromDate(Class<?> targetClass, Class<?> sourceClass, Object o) {
        if (!targetClass.equals(sourceClass)) {
            PropertyAccessor accessor = PropertyAccessorFactory.getPropertyAccessor(sourceClass);
            byte[] b = accessor.toBytes(o);
            accessor = PropertyAccessorFactory.getPropertyAccessor(targetClass);
            return accessor.fromBytes(targetClass, b);
        }
        return o;
    }

    public static byte[] getBytes(Object o) {
        return PropertyAccessorFactory.getPropertyAccessor(o.getClass()).toBytes(o);
    }

    public static String getString(Object o) {
        return o != null ? PropertyAccessorFactory.getPropertyAccessor(o.getClass()).toString(o) : null;
    }

    public static Object getObject(Class clazz, byte[] b) {
        return PropertyAccessorFactory.getPropertyAccessor(clazz).fromBytes(clazz, b);
    }

    public static final Collection getCollectionInstance(Field collectionField) {
        if (collectionField != null) {
            if (collectionField.getType().isAssignableFrom(List.class)) {
                return new ArrayList();
            }
            if (collectionField.getType().isAssignableFrom(Set.class)) {
                return new HashSet();
            }
        }
        return null;
    }

    private static Class<?> toClass(Type o) {
        if (o instanceof GenericArrayType) {
            Class<?> clazz = Array.newInstance(PropertyAccessorHelper.toClass(((GenericArrayType)o).getGenericComponentType()), 0).getClass();
            return clazz;
        }
        return (Class)o;
    }

    private static Class<?> getTypedClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type rawParamterizedType = ((ParameterizedType)type).getRawType();
            return PropertyAccessorHelper.getTypedClass(rawParamterizedType);
        }
        if (type instanceof TypeVariable) {
            Type upperBound = ((TypeVariable)type).getBounds()[0];
            return PropertyAccessorHelper.getTypedClass(upperBound);
        }
        throw new IllegalArgumentException("Error while finding generic class for :" + type);
    }
}

