/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanAccessor
implements PropertyAccessor<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(BooleanAccessor.class);

    @Override
    public Boolean fromBytes(Class targetClass, byte[] data) {
        return data == null || data.length == 0 ? false : data[0] != 0;
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object != null) {
            Boolean b = (Boolean)object;
            return new byte[]{(byte)(b != false ? 1 : 0)};
        }
        return null;
    }

    @Override
    public String toString(Object object) {
        return object != null ? object.toString() : null;
    }

    @Override
    public Boolean fromString(Class targetClass, String s) {
        try {
            if (s == null) {
                return null;
            }
            Boolean b = new Boolean(s);
            return b;
        }
        catch (NumberFormatException e) {
            log.error("Number format exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public Boolean getCopy(Object object) {
        return object != null ? new Boolean((Boolean)object) : null;
    }

    @Override
    public Boolean getInstance(Class<?> clazz) {
        return Boolean.TRUE;
    }
}

