/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import com.impetus.kundera.property.accessor.LongAccessor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateAccessor
implements PropertyAccessor<Date> {
    private static Logger log = LoggerFactory.getLogger(DateAccessor.class);
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("dd MMM yyyy HH:mm:ss:S Z", Locale.ENGLISH);
    private static List<String> patterns = new ArrayList<String>(15);

    @Override
    public Date fromBytes(Class targetClass, byte[] bytes) {
        try {
            if (bytes == null) {
                return null;
            }
            try {
                LongAccessor longAccessor = new LongAccessor();
                return new Date(longAccessor.fromBytes(targetClass, bytes));
            }
            catch (NumberFormatException nfex) {
                return DateAccessor.getDateByPattern(new String(bytes, "utf-8"));
            }
        }
        catch (Exception e) {
            log.error("Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public byte[] toBytes(Object date) {
        try {
            if (date == null) {
                return null;
            }
            LongAccessor longAccessor = new LongAccessor();
            return longAccessor.toBytes(((Date)date).getTime());
        }
        catch (Exception e) {
            log.error("Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public String toString(Object object) {
        Date date = (Date)object;
        if (date == null) {
            return null;
        }
        return String.valueOf(date.getTime());
    }

    @Override
    public Date fromString(Class targetClass, String s) {
        try {
            if (s == null) {
                return null;
            }
            Date d = DateAccessor.getDateByPattern(s);
            return d;
        }
        catch (NumberFormatException e) {
            log.error("Number format exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    public static Date getDateByPattern(String date) {
        if (StringUtils.isNumeric((String)date)) {
            return new Date(Long.parseLong(date));
        }
        for (String p : patterns) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(p);
                Date dt = formatter.parse(date);
                return dt;
            }
            catch (IllegalArgumentException iae) {
            }
            catch (ParseException parseException) {
            }
        }
        log.error("Required Date format is not supported!" + date);
        throw new PropertyAccessException("Required Date format is not supported!" + date);
    }

    @Override
    public Date getCopy(Object object) {
        Date d = (Date)object;
        return d != null ? new Date(d.getTime()) : null;
    }

    public static String getFormattedObect(String date) {
        return date != null ? DateAccessor.getDateByPattern(date).toString() : null;
    }

    @Override
    public Date getInstance(Class<?> clazz) {
        return new Date();
    }

    static {
        patterns.add("E MMM dd HH:mm:ss z yyyy");
        patterns.add("dd MMM yyyy HH:mm:ss:SSS");
        patterns.add("dd MMM yyyy H:mm:ss:SSS");
        patterns.add("MM-dd-yyyy HH:mm:ss:SSS");
        patterns.add("MM/dd/yyyy HH:mm:ss:SSS");
        patterns.add("dd/MM/yyyy HH:mm:ss:SSS");
        patterns.add("dd-MM-yyyy HH:mm:ss:SSS");
        patterns.add("MMM/dd/yyyy HH:mm:ss:SSS");
        patterns.add("MMM-dd-yyyy HH:mm:ss:SSS");
        patterns.add("dd-MMM-yyyy HH:mm:ss:SSS");
        patterns.add("MM-dd-yyyy H:mm:ss:SSS");
        patterns.add("MM/dd/yyyy H:mm:ss:SSS");
        patterns.add("dd/MM/yyyy H:mm:ss:SSS");
        patterns.add("dd-MM-yyyy H:mm:ss:SSS");
        patterns.add("MMM/dd/yyyy H:mm:ss:SSS");
        patterns.add("MMM-dd-yyyy H:mm:ss:SSS");
        patterns.add("dd-MMM-yyyy H:mm:ss:SSS");
        patterns.add("MM-dd-yyyy HH:mm:ss");
        patterns.add("MM/dd/yyyy HH:mm:ss");
        patterns.add("dd/MM/yyyy HH:mm:ss");
        patterns.add("dd-MM-yyyy HH:mm:ss");
        patterns.add("MMM/dd/yyyy HH:mm:ss");
        patterns.add("MMM-dd-yyyy HH:mm:ss");
        patterns.add("dd-MMM-yyyy HH:mm:ss");
        patterns.add("MM-dd-yyyy H:mm:ss");
        patterns.add("MM/dd/yyyy H:mm:ss");
        patterns.add("dd/MM/yyyy H:mm:ss");
        patterns.add("dd-MM-yyyy H:mm:ss");
        patterns.add("MMM/dd/yyyy H:mm:ss");
        patterns.add("MMM-dd-yyyy H:mm:ss");
        patterns.add("dd-MMM-yyyy H:mm:ss");
        patterns.add("MM-dd-yyyy");
        patterns.add("MM/dd/yyyy");
        patterns.add("dd/MM/yyyy");
        patterns.add("dd-MM-yyyy");
        patterns.add("MMM/dd/yyyy");
        patterns.add("MMM-dd-yyyy");
        patterns.add("dd-MMM-yyyy");
    }
}

