/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongAccessor
implements PropertyAccessor<Long> {
    private static final Logger log = LoggerFactory.getLogger(LongAccessor.class);

    @Override
    public final Long fromBytes(Class targetClass, byte[] bytes) {
        if (bytes == null || bytes.length != 8) {
            if (log.isWarnEnabled()) {
                log.warn("Bytes length not equal to 8");
            }
            return null;
        }
        return ByteBuffer.wrap(bytes).getLong();
    }

    @Override
    public final byte[] toBytes(Object object) {
        if (object != null) {
            Long l = (Long)object;
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(l);
            return buffer.array();
        }
        if (log.isWarnEnabled()) {
            log.warn("Object is null.");
        }
        return null;
    }

    @Override
    public final String toString(Object object) {
        return object != null ? object.toString() : null;
    }

    @Override
    public Long fromString(Class targetClass, String s) {
        try {
            if (s == null) {
                if (log.isWarnEnabled()) {
                    log.warn("String s is null.");
                }
                return null;
            }
            Long l = new Long(s);
            return l;
        }
        catch (NumberFormatException e) {
            log.error("Number format exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public Long getCopy(Object object) {
        return object != null ? (Long)object : null;
    }

    @Override
    public Long getInstance(Class<?> clazz) {
        return Long.MAX_VALUE;
    }
}

