/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectAccessor
implements PropertyAccessor<Object> {
    public static Logger log = LoggerFactory.getLogger(ObjectAccessor.class);

    @Override
    public final Object fromBytes(Class targetClass, byte[] bytes) {
        try {
            if (bytes == null) {
                return null;
            }
            if (targetClass != null && targetClass.equals(byte[].class)) {
                return bytes;
            }
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object o = ois.readObject();
            ois.close();
            return o;
        }
        catch (IOException e) {
            log.error("IO exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
        catch (ClassNotFoundException e) {
            log.error("Class not found exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public final byte[] toBytes(Object o) {
        try {
            if (o != null) {
                if (o instanceof byte[]) {
                    return (byte[])o;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(o);
                oos.close();
                return baos.toByteArray();
            }
        }
        catch (IOException e) {
            log.error("IO exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
        return null;
    }

    @Override
    public final String toString(Object object) {
        return object != null ? object.toString() : null;
    }

    @Override
    public Object fromString(Class targetClass, String s) {
        try {
            if (s == null) {
                return null;
            }
            String o = s;
            return o;
        }
        catch (NumberFormatException e) {
            log.error("Number format exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public Object getCopy(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byteArr = (byte[])object;
            return byteArr.clone();
        }
        if (object instanceof Cloneable) {
            Class<?> clazz = object.getClass();
            Object o = null;
            try {
                Method m = clazz.getMethod("clone", new Class[0]);
                o = m.invoke(object, new Object[0]);
            }
            catch (SecurityException e) {
                log.warn("Object of class " + object.getClass() + " can't be cloned, due to exception:" + e.getMessage());
                return object;
            }
            catch (IllegalArgumentException e) {
                log.warn("Object of class " + object.getClass() + " can't be cloned, due to exception:" + e.getMessage());
                return object;
            }
            catch (NoSuchMethodException e) {
                log.warn("Object of class " + object.getClass() + " can't be cloned, due to exception:" + e.getMessage());
                return object;
            }
            catch (IllegalAccessException e) {
                log.warn("Object of class " + object.getClass() + " can't be cloned, due to exception:" + e.getMessage());
                return object;
            }
            catch (InvocationTargetException e) {
                log.warn("Object of class " + object.getClass() + " can't be cloned, due to exception:" + e.getMessage());
                return object;
            }
            return o;
        }
        return object;
    }

    @Override
    public Object getInstance(Class<?> clazz) {
        Object o = null;
        try {
            o = clazz.newInstance();
            return o;
        }
        catch (InstantiationException ie) {
            log.warn("Instantiation exception,caused by :" + ie.getMessage());
            return null;
        }
        catch (IllegalAccessException iae) {
            log.warn("Illegal access exception,caused by :" + iae.getMessage());
            return null;
        }
    }
}

