/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import com.impetus.kundera.property.accessor.LongAccessor;
import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLTimestampAccessor
implements PropertyAccessor<Timestamp> {
    public static Logger log = LoggerFactory.getLogger(SQLTimestampAccessor.class);

    @Override
    public Timestamp fromBytes(Class targetClass, byte[] b) {
        try {
            if (b == null) {
                return null;
            }
            LongAccessor longAccessor = new LongAccessor();
            return new Timestamp(longAccessor.fromBytes(targetClass, b));
        }
        catch (Exception e) {
            log.error("Error occured, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public byte[] toBytes(Object object) {
        try {
            if (object == null) {
                return null;
            }
            LongAccessor longAccessor = new LongAccessor();
            return longAccessor.toBytes(((Timestamp)object).getTime());
        }
        catch (Exception e) {
            log.error("Error occured, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public String toString(Object object) {
        Timestamp timeStamp = (Timestamp)object;
        if (timeStamp == null) {
            return null;
        }
        return String.valueOf(timeStamp.getTime());
    }

    @Override
    public Timestamp fromString(Class targetClass, String s) {
        if (s == null) {
            return null;
        }
        if (StringUtils.isNumeric((String)s)) {
            return new Timestamp(Long.parseLong(s));
        }
        Timestamp t = Timestamp.valueOf(s);
        return t;
    }

    @Override
    public Timestamp getCopy(Object object) {
        Timestamp ts = (Timestamp)object;
        return ts != null ? new Timestamp(ts.getTime()) : null;
    }

    @Override
    public Timestamp getInstance(Class<?> clazz) {
        return new Timestamp(Integer.MAX_VALUE);
    }
}

