/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringAccessor
implements PropertyAccessor<String> {
    public static Logger log = LoggerFactory.getLogger(StringAccessor.class);

    @Override
    public final String fromBytes(Class targetClass, byte[] bytes) {
        try {
            return bytes != null ? new String(bytes, "UTF-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unsupported encoding exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public final byte[] toBytes(Object s) throws PropertyAccessException {
        try {
            return s != null ? ((String)s).getBytes("UTF-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unsupported encoding exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public final String toString(Object object) {
        if (object != null && object.getClass().isAssignableFrom(String.class)) {
            return (String)object;
        }
        return null;
    }

    @Override
    public String fromString(Class targetClass, String s) {
        return s;
    }

    @Override
    public String getCopy(Object object) {
        return object != null ? new String((String)object) : null;
    }

    @Override
    public String getInstance(Class<?> clazz) {
        return new String();
    }
}

