/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDAccessor
implements PropertyAccessor<UUID> {
    public static Logger log = LoggerFactory.getLogger(UUIDAccessor.class);

    @Override
    public UUID fromBytes(Class targetClass, byte[] bytes) throws PropertyAccessException {
        try {
            int i;
            if (bytes == null) {
                return null;
            }
            long msb = 0L;
            long lsb = 0L;
            for (i = 0; i < 8; ++i) {
                msb = msb << 8 | (long)(bytes[i] & 0xFF);
            }
            for (i = 8; i < 16; ++i) {
                lsb = lsb << 8 | (long)(bytes[i] & 0xFF);
            }
            return new UUID(msb, lsb);
        }
        catch (Exception e) {
            log.error("Error occured, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public byte[] toBytes(Object object) throws PropertyAccessException {
        try {
            if (object == null) {
                return null;
            }
            UUID uuid = (UUID)object;
            return UUIDAccessor.asByteArray(uuid);
        }
        catch (Exception e) {
            log.error("Error occured, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public String toString(Object object) {
        if (object == null) {
            return null;
        }
        return ((UUID)object).toString();
    }

    @Override
    public UUID fromString(Class targetClass, String s) throws PropertyAccessException {
        try {
            if (s == null) {
                return null;
            }
            return UUID.fromString(s);
        }
        catch (Exception e) {
            log.error("Error occured, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    private static byte[] asByteArray(UUID uuid) {
        int i;
        if (uuid == null) {
            return null;
        }
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            buffer[i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return buffer;
    }

    @Override
    public UUID getCopy(Object object) {
        UUID uuid = (UUID)object;
        return uuid != null ? UUID.fromString(uuid.toString()) : null;
    }

    @Override
    public UUID getInstance(Class<?> clazz) {
        return UUID.randomUUID();
    }
}

