/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.proxy.cglib;

import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.proxy.KunderaProxy;
import com.impetus.kundera.proxy.LazyInitializationException;
import com.impetus.kundera.proxy.LazyInitializer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.persistence.PersistenceException;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.NoOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CglibLazyInitializer
implements LazyInitializer,
InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(CglibLazyInitializer.class);
    private String entityName;
    private Object id;
    private Object owner;
    private Object target;
    private boolean initialized;
    private boolean unwrap;
    protected Class<?> persistentClass;
    protected Method getIdentifierMethod;
    protected Method setIdentifierMethod;
    private Class<?>[] interfaces;
    private boolean constructed = false;
    private transient PersistenceDelegator persistenceDelegator;
    private static final CallbackFilter FINALIZE_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            if (method.getParameterTypes().length == 0 && method.getName().equals("finalize")) {
                return 1;
            }
            return 0;
        }
    };

    public static KunderaProxy getProxy(String entityName, Class<?> persistentClass, Class<?>[] interfaces, Method getIdentifierMethod, Method setIdentifierMethod, Object id, PersistenceDelegator pd) throws PersistenceException {
        CglibLazyInitializer instance = new CglibLazyInitializer(entityName, persistentClass, interfaces, id, getIdentifierMethod, setIdentifierMethod, pd);
        Class factory = CglibLazyInitializer.getProxyFactory(persistentClass, interfaces);
        KunderaProxy proxy = CglibLazyInitializer.getProxyInstance(factory, instance);
        instance.constructed = true;
        return proxy;
    }

    private static KunderaProxy getProxyInstance(Class factory, CglibLazyInitializer instance) {
        KunderaProxy proxy;
        try {
            Enhancer.registerCallbacks((Class)factory, (Callback[])new Callback[]{instance, null});
            proxy = (KunderaProxy)factory.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new LazyInitializationException(e);
        }
        catch (InstantiationException e) {
            throw new LazyInitializationException(e);
        }
        finally {
            Enhancer.registerCallbacks((Class)factory, null);
        }
        return proxy;
    }

    public static Class getProxyFactory(Class persistentClass, Class[] interfaces) throws PersistenceException {
        Enhancer e = new Enhancer();
        e.setSuperclass(interfaces.length == 1 ? persistentClass : null);
        e.setInterfaces(interfaces);
        e.setCallbackTypes(new Class[]{InvocationHandler.class, NoOp.class});
        e.setCallbackFilter(FINALIZE_FILTER);
        e.setUseFactory(false);
        e.setInterceptDuringConstruction(false);
        return e.createClass();
    }

    private CglibLazyInitializer(String entityName, Class<?> persistentClass, Class<?>[] interfaces, Object id, Method getIdentifierMethod, Method setIdentifierMethod, PersistenceDelegator pd) {
        this.entityName = entityName;
        this.id = id;
        this.persistenceDelegator = pd;
        this.persistentClass = persistentClass;
        this.getIdentifierMethod = getIdentifierMethod;
        this.setIdentifierMethod = setIdentifierMethod;
        this.interfaces = interfaces;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.constructed) {
            String methodName = method.getName();
            int params = args.length;
            if (params == 0) {
                if (this.isUninitialized() && method.equals(this.getIdentifierMethod)) {
                    return this.getIdentifier();
                }
                if ("getKunderaLazyInitializer".equals(methodName)) {
                    return this;
                }
            }
            Object target = this.getImplementation();
            String[] strArr = this.entityName.split("#");
            String fieldName = strArr[1];
            if (this.owner != null) {
                EntityMetadata m = KunderaMetadataManager.getEntityMetadata(this.persistenceDelegator.getKunderaMetadata(), this.owner.getClass());
                Relation r = m.getRelation(fieldName);
                if (r != null) {
                    PropertyAccessorHelper.set(this.owner, r.getProperty(), target);
                }
                if (r.getBiDirectionalField() != null && method.getReturnType().equals(m.getEntityClazz())) {
                    PropertyAccessorHelper.set(target, r.getBiDirectionalField(), this.owner);
                }
            }
            try {
                Object returnValue;
                if (method.isAccessible()) {
                    if (!method.getDeclaringClass().isInstance(target)) {
                        throw new ClassCastException(target.getClass().getName());
                    }
                    returnValue = method.invoke(target, args);
                } else {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    returnValue = method.invoke(target, args);
                }
                return returnValue == target ? proxy : returnValue;
            }
            catch (InvocationTargetException ite) {
                throw new LazyInitializationException(ite);
            }
        }
        throw new LazyInitializationException("unexpected case hit, method=" + method.getName());
    }

    @Override
    public final Class<?> getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public final String getEntityName() {
        return this.entityName;
    }

    @Override
    public Object getIdentifier() {
        return this.id;
    }

    @Override
    public void setIdentifier(Object id) {
        this.id = id;
    }

    @Override
    public final boolean isUninitialized() {
        return !this.initialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public final void initialize() throws PersistenceException {
        if (!this.initialized) {
            if (this.persistenceDelegator == null) {
                throw new LazyInitializationException("could not initialize proxy " + this.persistentClass.getName() + "_" + this.id + " - no EntityManager");
            }
            if (!this.persistenceDelegator.isOpen()) {
                throw new LazyInitializationException("could not initialize proxy " + this.persistentClass.getName() + "_" + this.id + " - the owning Session was closed");
            }
            if (log.isDebugEnabled()) {
                log.debug("Proxy >> Initialization >> " + this.persistentClass.getName() + "_" + this.id);
            }
            this.target = this.persistenceDelegator.findById(this.persistentClass, this.id);
            this.initialized = true;
        }
    }

    @Override
    public final Object getImplementation() {
        this.initialize();
        return this.target;
    }

    protected final Object getTarget() {
        return this.target;
    }

    @Override
    public boolean isUnwrap() {
        return this.unwrap;
    }

    @Override
    public void setUnwrap(boolean unwrap) {
        this.unwrap = unwrap;
    }

    @Override
    public void setImplementation(Object paramObject) {
        this.target = paramObject;
        this.initialized = true;
    }

    @Override
    public PersistenceDelegator getPersistenceDelegator() {
        return this.persistenceDelegator;
    }

    public void setPersistenceDelegator(PersistenceDelegator persistenceDelegator) {
        this.persistenceDelegator = persistenceDelegator;
    }

    @Override
    public void unsetPersistenceDelegator() {
        this.persistenceDelegator = null;
    }

    @Override
    public void setOwner(Object owner) throws PersistenceException {
        if (owner != null && !owner.getClass().equals(this.persistentClass)) {
            this.owner = owner;
        }
    }

    @Override
    public Object getOwner() throws PersistenceException {
        return this.owner;
    }
}

