/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.proxy.cglib;

import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.proxy.KunderaProxy;
import com.impetus.kundera.proxy.LazyInitializerFactory;
import com.impetus.kundera.proxy.cglib.CglibLazyInitializer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Entity;

public class CglibLazyInitializerFactory
implements LazyInitializerFactory {
    Map<String, KunderaProxy> proxies = new HashMap<String, KunderaProxy>();

    @Override
    public KunderaProxy getProxy(String entityName, Class<?> persistentClass, Method getIdentifierMethod, Method setIdentifierMethod, Object id, PersistenceDelegator pd) {
        KunderaProxy kunderaProxy = CglibLazyInitializer.getProxy(entityName, persistentClass, new Class[]{KunderaProxy.class}, getIdentifierMethod, setIdentifierMethod, id, pd);
        this.proxies.put(entityName, kunderaProxy);
        return kunderaProxy;
    }

    @Override
    public KunderaProxy getProxy(String entityName) {
        return this.proxies.get(entityName);
    }

    @Override
    public void clearProxies() {
        for (KunderaProxy proxy : this.proxies.values()) {
            proxy.getKunderaLazyInitializer().setOwner(null);
            proxy.getKunderaLazyInitializer().setInitialized(false);
        }
        this.proxies.clear();
    }

    @Override
    public <E> void setProxyOwners(EntityMetadata entityMetadata, E e) {
        if (e != null && e.getClass().getAnnotation(Entity.class) != null && entityMetadata != null) {
            for (Relation r : entityMetadata.getRelations()) {
                String entityName;
                KunderaProxy kunderaProxy;
                if (r == null) continue;
                Object entityId = PropertyAccessorHelper.getId(e, entityMetadata);
                if (!r.isUnary() || (kunderaProxy = this.getProxy(entityName = entityMetadata.getEntityClazz().getName() + "_" + entityId + "#" + r.getProperty().getName())) == null) continue;
                kunderaProxy.getKunderaLazyInitializer().setOwner(e);
            }
        }
    }
}

