/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.query;

import com.impetus.kundera.query.JPQLParseException;
import com.impetus.kundera.query.KunderaQuery;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KunderaQueryParser {
    private KunderaQuery query;
    private String queryString;
    private static Logger logger = LoggerFactory.getLogger(KunderaQueryParser.class);

    public KunderaQueryParser(KunderaQuery query) {
        this.query = query;
        this.queryString = query.getJPAQuery();
    }

    public final void parse() {
        new Compiler().compile();
    }

    private boolean isKeyword(String token) {
        for (int i = 0; i < KunderaQuery.SINGLE_STRING_KEYWORDS.length; ++i) {
            if (!token.equalsIgnoreCase(KunderaQuery.SINGLE_STRING_KEYWORDS[i])) continue;
            return true;
        }
        return false;
    }

    private void buildResultColumns() {
        String[] result = null;
        String[] aggResult = null;
        if (this.query.isSelectStatement()) {
            SelectClause selectClause = (SelectClause)this.query.getSelectStatement().getSelectClause();
            ListIterator selectColumnIter = null;
            int size = 0;
            if (selectClause.getSelectExpression() instanceof CollectionExpression) {
                CollectionExpression selectColumnExpression = (CollectionExpression)selectClause.getSelectExpression();
                selectColumnIter = selectColumnExpression.children().iterator();
                size = selectColumnExpression.childrenSize();
            } else if (selectClause.getSelectExpression().toActualText().indexOf(".") > 0) {
                size = 1;
            }
            int aggregationCount = this.countAggregation(selectClause.getSelectExpression());
            this.query.setAggregated(aggregationCount > 0 || this.query.getSelectStatement().hasGroupByClause() || this.query.getSelectStatement().hasOrderByClause());
            int count = 0;
            int aggCounter = 0;
            int resultSize = size + 1 - aggregationCount;
            if (resultSize == 0) {
                resultSize = 1;
            }
            result = new String[resultSize];
            aggResult = new String[aggregationCount + 1];
            if (selectColumnIter != null) {
                while (selectColumnIter.hasNext()) {
                    Expression nextExpression = (Expression)selectColumnIter.next();
                    String property = nextExpression.toActualText();
                    if (this.validateExpression(nextExpression)) {
                        aggCounter = this.buildResult(aggResult, aggCounter, property.substring(property.indexOf(40) + 1, property.indexOf(41)));
                        continue;
                    }
                    count = this.buildResult(result, count, property);
                }
            } else {
                String property = selectClause.getSelectExpression().toActualText();
                if (this.validateExpression(selectClause.getSelectExpression())) {
                    aggCounter = this.buildResult(aggResult, aggCounter, property.substring(property.indexOf(40) + 1, property.indexOf(41)));
                } else {
                    count = this.buildResult(result, count, property);
                }
            }
            result[0] = result[0] == null ? aggResult[0] : result[0];
            aggResult[0] = aggResult[0] == null ? result[0] : aggResult[0];
            this.query.setResult(result);
            this.query.setAggregationResult(aggResult);
        }
    }

    private int countAggregation(Expression selectExpression) {
        int count = 0;
        if (selectExpression instanceof CollectionExpression) {
            CollectionExpression selectColumnExpression = (CollectionExpression)selectExpression;
            ListIterator selectColumnIter = selectColumnExpression.children().iterator();
            while (selectColumnIter.hasNext()) {
                count = this.validateExpression((Expression)selectColumnIter.next()) ? ++count : count;
            }
        } else if (this.validateExpression(selectExpression)) {
            count = 1;
        }
        return count;
    }

    private boolean validateExpression(Expression expression) {
        return !(expression instanceof StateFieldPathExpression) && !(expression instanceof IdentificationVariable) && !(expression instanceof ResultVariable);
    }

    private int buildResult(String[] result, int count, String property) {
        if (property != null && property.length() > 0) {
            if (property.indexOf(".") > 0) {
                result[0] = property.substring(0, property.indexOf("."));
                String fieldName = property.substring(property.indexOf(".") + 1, property.length());
                if (fieldName == null || fieldName.isEmpty()) {
                    throw new JPQLParseException("You have not given any column name after . ,Column name should not be empty");
                }
                if (result[count] == null) {
                    throw new JPQLParseException("Bad query format");
                }
                result[++count] = fieldName;
            } else {
                if (count > 0) {
                    throw new JPQLParseException("Bad query format");
                }
                result[count] = property;
                ++count;
            }
        }
        return count;
    }

    private void buildFrom() {
        ListIterator fromIter = null;
        if (this.query.isSelectStatement() && this.query.getSelectStatement().hasFromClause()) {
            FromClause fromClause = (FromClause)this.query.getSelectStatement().getFromClause();
            fromIter = fromClause.children().iterator();
        } else if (this.query.isUpdateStatement()) {
            fromIter = this.query.getUpdateStatement().getUpdateClause().children().iterator();
        }
        if (this.query.isDeleteStatement()) {
            fromIter = this.query.getDeleteStatement().getDeleteClause().children().iterator();
        }
        if (fromIter != null) {
            while (fromIter.hasNext()) {
                String textObj = ((Expression)fromIter.next()).toActualText().trim();
                if (StringUtils.isEmpty((String)textObj)) continue;
                this.query.setFrom(textObj);
                break;
            }
        }
    }

    private class Compiler {
        private String groupingClause;

        private Compiler() {
        }

        private void compile() {
            if (!this.compileUpdate()) {
                this.compileSelectOrDelete();
            }
        }

        private boolean compileUpdate() {
            if (KunderaQueryParser.this.query.isUpdateStatement()) {
                KunderaQueryParser.this.query.setIsDeleteUpdate(true);
                this.compileFrom();
                this.compileUpdateClause();
                this.compilewhereClause();
                return true;
            }
            return false;
        }

        private void compileSelectOrDelete() {
            if (!KunderaQueryParser.this.query.isSelectStatement() && KunderaQueryParser.this.query.isDeleteStatement()) {
                KunderaQueryParser.this.query.setIsDeleteUpdate(true);
            }
            this.compileFrom();
            this.compileResult();
            this.compilewhereClause();
        }

        private boolean isWhereClause() {
            if (KunderaQueryParser.this.query.isSelectStatement()) {
                return KunderaQueryParser.this.query.getSelectStatement().hasWhereClause();
            }
            if (KunderaQueryParser.this.query.isUpdateStatement()) {
                return KunderaQueryParser.this.query.getUpdateStatement().hasWhereClause();
            }
            if (KunderaQueryParser.this.query.isDeleteStatement()) {
                return KunderaQueryParser.this.query.getDeleteStatement().hasWhereClause();
            }
            return false;
        }

        private boolean isGroupBy() {
            if (KunderaQueryParser.this.query.isSelectStatement()) {
                return KunderaQueryParser.this.query.getSelectStatement().hasGroupByClause();
            }
            return false;
        }

        private boolean isHaving() {
            if (KunderaQueryParser.this.query.isSelectStatement()) {
                return KunderaQueryParser.this.query.getSelectStatement().hasHavingClause();
            }
            return false;
        }

        private boolean isOrderBy() {
            if (KunderaQueryParser.this.query.isSelectStatement()) {
                return KunderaQueryParser.this.query.getSelectStatement().hasOrderByClause();
            }
            return false;
        }

        private void compilewhereClause() {
            if (this.isWhereClause()) {
                this.compileWhere();
            }
            if (this.isGroupBy()) {
                this.compileGroup();
            }
            if (this.isHaving()) {
                this.compileHaving();
            }
            if (this.groupingClause != null) {
                KunderaQueryParser.this.query.setGrouping(this.groupingClause);
            }
            if (this.isOrderBy()) {
                this.compileOrder();
            }
        }

        private void compileResult() {
            KunderaQueryParser.this.buildResultColumns();
        }

        private void compileFrom() {
            KunderaQueryParser.this.buildFrom();
        }

        private void compileUpdateClause() {
            ListIterator updateColumnIter = null;
            if (KunderaQueryParser.this.query.isUpdateStatement() && KunderaQueryParser.this.query.getUpdateStatement().getUpdateClause().hasUpdateItems()) {
                if (KunderaQueryParser.this.query.getUpdateStatement().getUpdateClause().getUpdateItems() instanceof CollectionExpression) {
                    updateColumnIter = ((CollectionExpression)KunderaQueryParser.this.query.getUpdateStatement().getUpdateClause().getUpdateItems()).children().iterator();
                    while (updateColumnIter.hasNext()) {
                        ListIterator childUpdateClauseIter = ((Expression)updateColumnIter.next()).children().iterator();
                        while (childUpdateClauseIter.hasNext()) {
                            this.addUpdateClause(childUpdateClauseIter);
                        }
                    }
                } else {
                    updateColumnIter = KunderaQueryParser.this.query.getUpdateStatement().getUpdateClause().getUpdateItems().children().iterator();
                    this.addUpdateClause(updateColumnIter);
                }
            }
        }

        private void addUpdateClause(ListIterator<Expression> childUpdateClauseIter) {
            String columnTuple = childUpdateClauseIter.next().toActualText().trim();
            String value = childUpdateClauseIter.next().toActualText().trim();
            StringTokenizer tokenizer = new StringTokenizer(columnTuple, ".");
            columnTuple = this.getTokenizedValue(tokenizer);
            KunderaQueryParser.this.query.addUpdateClause(columnTuple, value);
        }

        private String getTokenizedValue(StringTokenizer tokenizer) {
            String value = null;
            while (tokenizer.hasMoreTokens()) {
                value = tokenizer.nextToken();
            }
            return value;
        }

        private void compileWhere() {
            WhereClause whereClause = null;
            if (KunderaQueryParser.this.query.isSelectStatement()) {
                whereClause = (WhereClause)KunderaQueryParser.this.query.getSelectStatement().getWhereClause();
            } else if (KunderaQueryParser.this.query.isUpdateStatement()) {
                whereClause = (WhereClause)KunderaQueryParser.this.query.getUpdateStatement().getWhereClause();
            }
            if (KunderaQueryParser.this.query.isDeleteStatement()) {
                whereClause = (WhereClause)KunderaQueryParser.this.query.getDeleteStatement().getWhereClause();
            }
            String content = whereClause.getConditionalExpression().toActualText();
            if (whereClause != null && content.length() == 0) {
                throw new JPQLParseException("keyword without value[WHERE]");
            }
            KunderaQueryParser.this.query.setFilter(content);
        }

        private void compileGroup() {
            GroupByClause groupByClause = null;
            if (KunderaQueryParser.this.query.isSelectStatement()) {
                groupByClause = (GroupByClause)KunderaQueryParser.this.query.getSelectStatement().getGroupByClause();
            }
            if (groupByClause == null && groupByClause.toActualText().length() == 0) {
                throw new JPQLParseException("keyword without value: GROUP BY");
            }
            this.groupingClause = groupByClause.toActualText();
        }

        private void compileHaving() {
            HavingClause havingClause = null;
            if (KunderaQueryParser.this.query.isSelectStatement()) {
                havingClause = (HavingClause)KunderaQueryParser.this.query.getSelectStatement().getHavingClause();
            }
            if (havingClause == null && havingClause.toActualText().length() == 0) {
                throw new JPQLParseException("keyword without value: HAVING");
            }
            this.groupingClause = this.groupingClause != null ? this.groupingClause.trim() + havingClause.toActualText() : havingClause.toActualText();
        }

        private void compileOrder() {
            OrderByClause orderByClause = null;
            if (KunderaQueryParser.this.query.isSelectStatement()) {
                orderByClause = (OrderByClause)KunderaQueryParser.this.query.getSelectStatement().getOrderByClause();
            }
            if (orderByClause == null || !orderByClause.hasOrderByItems()) {
                throw new JPQLParseException("keyword without value: ORDER BY");
            }
            KunderaQueryParser.this.query.setOrdering(orderByClause.getOrderByItems().toActualText());
        }
    }
}

