/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.query;

import com.impetus.kundera.client.Client;
import com.impetus.kundera.metadata.MetadataBuilder;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.EntityReader;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.query.KunderaQuery;
import com.impetus.kundera.query.QueryImpl;
import com.impetus.kundera.utils.KunderaCoreUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneQuery
extends QueryImpl {
    private static Logger log = LoggerFactory.getLogger(MetadataBuilder.class);
    int maxResult = -1;
    String luceneQuery;

    public LuceneQuery(KunderaQuery kunderaQuery, PersistenceDelegator pd, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        super(kunderaQuery, pd, kunderaMetadata);
    }

    @Override
    public List<?> getResultList() {
        String q;
        if (log.isDebugEnabled()) {
            log.debug("JPA Query: " + this.getJPAQuery());
        }
        if (null == (q = this.luceneQuery)) {
            q = KunderaCoreUtils.getLuceneQueryFromJPAQuery(this.kunderaQuery, this.kunderaMetadata);
        }
        if (log.isDebugEnabled()) {
            log.debug("Lucene Query: " + q);
        }
        EntityMetadata m = this.kunderaQuery.getEntityMetadata();
        Client client = this.persistenceDelegeator.getClient(m);
        this.handlePostEvent();
        Map<String, Object> searchFilter = client.getIndexManager().search(m.getEntityClazz(), q, -1, this.maxResult);
        if (this.kunderaQuery.isAliasOnly()) {
            Object[] primaryKeys = searchFilter.values().toArray(new String[0]);
            return this.persistenceDelegeator.find(m.getEntityClazz(), primaryKeys);
        }
        return this.persistenceDelegeator.find(m.getEntityClazz(), new Object[]{searchFilter});
    }

    @Override
    public Query setMaxResults(int maxResult) {
        this.maxResult = maxResult;
        return this;
    }

    @Override
    protected List<Object> populateEntities(EntityMetadata m, Client client) {
        throw new UnsupportedOperationException("Method not supported for Lucene indexing");
    }

    @Override
    protected EntityReader getReader() {
        throw new UnsupportedOperationException("Method not supported for Lucene indexing");
    }

    @Override
    protected List<Object> recursivelyPopulateEntities(EntityMetadata m, Client client) {
        throw new UnsupportedOperationException("Method not supported for Lucene indexing");
    }

    @Override
    protected int onExecuteUpdate() {
        if (this.kunderaQuery.isDeleteUpdate()) {
            List<?> result = this.getResultList();
            return result != null ? result.size() : 0;
        }
        return 0;
    }

    @Override
    public void close() {
    }

    public Iterator iterate() {
        return null;
    }

    @Override
    protected List findUsingLucene(EntityMetadata m, Client client) {
        throw new UnsupportedOperationException("Method supported in native clients");
    }
}

