/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.query;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class LuceneQueryBuilder {
    private static final Map<String, condition> conditions = new HashMap<String, condition>();
    private StringBuilder builder = new StringBuilder();
    private static final String LUCENE_ESCAPE_CHARS = "[\\\\+\\-\\!\\(\\)\\:\\^\\]\\{\\}\\~\\*\\?]";
    private static final Pattern LUCENE_PATTERN = Pattern.compile("[\\\\+\\-\\!\\(\\)\\:\\^\\]\\{\\}\\~\\*\\?]");
    private static final String REPLACEMENT_STRING = "\\\\$0";

    public final LuceneQueryBuilder buildQuery(String condition2, String value, Class valueClazz) {
        condition c = conditions.get(condition2.toLowerCase().trim());
        String lucenevalue = LUCENE_PATTERN.matcher(value).replaceAll(REPLACEMENT_STRING);
        if (c != null) {
            switch (c) {
                case EQ: {
                    this.builder.append(":");
                    this.builder.append("\"");
                    this.builder.append(lucenevalue);
                    this.builder.append("\"");
                    break;
                }
                case NOT_EQ: {
                    this.builder.append(":(* NOT ");
                    this.builder.append("\"");
                    this.builder.append(lucenevalue);
                    this.builder.append("\")");
                    break;
                }
                case LIKE: {
                    this.builder.append(":");
                    this.builder.append("(");
                    this.matchMode(lucenevalue.trim());
                    this.builder.append(")");
                    break;
                }
                case GT: {
                    this.builder.append(this.appendRange(lucenevalue, false, true, valueClazz));
                    break;
                }
                case LT: {
                    this.builder.append(this.appendRange(lucenevalue, false, false, valueClazz));
                    break;
                }
                case GTE: {
                    this.builder.append(this.appendRange(lucenevalue, true, true, valueClazz));
                    break;
                }
                case LTE: {
                    this.builder.append(this.appendRange(lucenevalue, true, false, valueClazz));
                    break;
                }
                case IN: {
                    this.builder.append(":");
                    this.builder.append("(");
                    this.builder.append(value);
                    this.builder.append(")");
                    break;
                }
                default: {
                    this.builder.append(" " + lucenevalue + " ");
                }
            }
        }
        return this;
    }

    public LuceneQueryBuilder appendEntityName(String entityName) {
        if (this.builder.length() > 0) {
            this.builder.insert(0, "(");
            this.builder.append(")");
            this.builder.append(" AND ");
        }
        this.builder.append("entity.class");
        this.builder.append(":");
        this.builder.append(entityName);
        return this;
    }

    public LuceneQueryBuilder appendIndexName(String indexName) {
        this.builder.append(indexName);
        this.builder.append(".");
        return this;
    }

    public LuceneQueryBuilder appendPropertyName(String propertyName) {
        this.builder.append(propertyName);
        return this;
    }

    public final String getQuery() {
        return this.builder.toString();
    }

    private String appendRange(String value, boolean inclusive, boolean isGreaterThan, Class clazz) {
        String appender = " ";
        StringBuilder sb = new StringBuilder();
        sb.append(":");
        sb.append(inclusive ? "[" : "{");
        sb.append(isGreaterThan ? value : "*");
        sb.append(appender);
        sb.append("TO");
        sb.append(appender);
        if (clazz != null && (clazz.isAssignableFrom(Integer.TYPE) || clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Short.TYPE) || clazz.isAssignableFrom(Long.TYPE) || clazz.isAssignableFrom(Timestamp.class) || clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Float.TYPE) || clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(BigDecimal.class) || clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE))) {
            sb.append(isGreaterThan ? "*" : value);
        } else {
            sb.append(isGreaterThan ? "null" : value);
        }
        sb.append(inclusive ? "]" : "}");
        return sb.toString();
    }

    private void matchMode(String value) {
        boolean left = false;
        boolean right = false;
        if (value.charAt(0) == '%') {
            value = value.substring(1);
            left = true;
        }
        if (value.charAt(value.length() - 1) == '%') {
            value = value.substring(0, value.length() - 1);
            right = true;
        }
        if (left && right || !left && !right) {
            this.builder.append("*");
            this.builder.append(value);
            this.builder.append("*");
        } else if (left) {
            this.builder.append("*");
            this.builder.append(value);
        } else if (right) {
            this.builder.append(value);
            this.builder.append("*");
        }
    }

    static {
        conditions.put("=", condition.EQ);
        conditions.put("like", condition.LIKE);
        conditions.put(">", condition.GT);
        conditions.put("<", condition.LT);
        conditions.put(">=", condition.GTE);
        conditions.put("<=", condition.LTE);
        conditions.put("and", condition.AND);
        conditions.put("or", condition.OR);
        conditions.put("<>", condition.NOT_EQ);
        conditions.put("in", condition.IN);
    }

    public static enum condition {
        EQ,
        LIKE,
        GT,
        LT,
        LTE,
        GTE,
        AND,
        OR,
        NOT_EQ,
        IN;

    }
}

