/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.service;

import com.impetus.kundera.configure.ClientProperties;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.service.Host;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HostConfiguration {
    private static Logger logger = LoggerFactory.getLogger(HostConfiguration.class);
    protected int retryDelay = 100;
    protected PersistenceUnitMetadata persistenceUnitMetadata;
    protected Properties connectionProperties = new Properties();
    protected Map externalProperties;
    protected List<Host> hostsList = new CopyOnWriteArrayList<Host>();

    public HostConfiguration(Map externalProperties, List<ClientProperties.DataStore.Connection.Server> servers, String persistenceUnit, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        this.buildHosts(externalProperties, servers, persistenceUnit, kunderaMetadata);
    }

    private void buildHosts(Map externalProperties, List<ClientProperties.DataStore.Connection.Server> servers, String persistenceUnit, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        this.persistenceUnitMetadata = kunderaMetadata.getApplicationMetadata().getPersistenceUnitMetadata(persistenceUnit);
        Properties props = this.persistenceUnitMetadata.getProperties();
        this.externalProperties = externalProperties;
        String hosts = null;
        String portAsString = null;
        if (externalProperties != null) {
            hosts = (String)externalProperties.get("kundera.nodes");
            portAsString = (String)externalProperties.get("kundera.port");
        }
        if (hosts == null) {
            hosts = (String)props.get("kundera.nodes");
        }
        if (portAsString == null) {
            portAsString = (String)props.get("kundera.port");
        }
        if (hosts != null && portAsString != null) {
            this.buildHosts(hosts, portAsString, this.hostsList);
        } else if (servers != null && servers.size() >= 1) {
            this.buildHosts(servers, this.hostsList);
        }
    }

    protected void onValidation(String host, String port) {
        if (host == null || !StringUtils.isNumeric((String)port) || port.isEmpty()) {
            logger.error("Host or port should not be null / port should be numeric.");
            throw new IllegalArgumentException("Host or port should not be null / port should be numeric.");
        }
    }

    public List<Host> getHosts() {
        return this.hostsList;
    }

    protected abstract void buildHosts(List<ClientProperties.DataStore.Connection.Server> var1, List<Host> var2);

    protected abstract void buildHosts(String var1, String var2, List<Host> var3);

    protected abstract void setConfig(Host var1, Properties var2, Map var3);
}

