/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.service.policy;

import com.google.common.collect.Iterables;
import com.impetus.kundera.service.policy.LoadBalancingPolicy;
import java.util.Collection;

public final class RoundRobinBalancingPolicy
implements LoadBalancingPolicy {
    private int counter = 0;

    @Override
    public Object getPool(Collection<Object> pools) {
        try {
            return Iterables.get(pools, (int)this.getAndIncrement(pools.size()));
        }
        catch (IndexOutOfBoundsException e) {
            return pools.iterator().next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAndIncrement(int size) {
        int counterToReturn;
        RoundRobinBalancingPolicy roundRobinBalancingPolicy = this;
        synchronized (roundRobinBalancingPolicy) {
            if (this.counter >= 16384) {
                this.counter = 0;
            }
            counterToReturn = this.counter++;
        }
        return counterToReturn % size;
    }
}

