/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.utils;

import com.impetus.kundera.proxy.ProxyHelper;
import com.impetus.kundera.proxy.collection.ProxyCollection;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

public class DeepEquals {
    private static final Map<Class, Boolean> _customEquals = new ConcurrentHashMap<Class, Boolean>();
    private static final Map<Class, Boolean> _customHash = new ConcurrentHashMap<Class, Boolean>();
    private static final Map<Class, Collection<Field>> _reflectedFields = new ConcurrentHashMap<Class, Collection<Field>>();

    public static boolean deepEquals(Object a, Object b) {
        HashSet<DualKey> visited = new HashSet<DualKey>();
        return DeepEquals.deepEquals(a, b, visited);
    }

    private static boolean deepEquals(Object a, Object b, Set<DualKey> visited) {
        LinkedList<DualKey> stack = new LinkedList<DualKey>();
        stack.addFirst(new DualKey(a, b));
        while (!stack.isEmpty()) {
            DualKey dualKey = (DualKey)stack.removeFirst();
            visited.add(dualKey);
            if (dualKey._key1 == null || dualKey._key2 == null) {
                if (dualKey._key1 == dualKey._key2) continue;
                return false;
            }
            if (!dualKey._key1.getClass().equals(dualKey._key2.getClass())) {
                return false;
            }
            if (dualKey._key1.getClass().isArray()) {
                if (dualKey._key1.getClass().isAssignableFrom(byte[].class)) {
                    if (Arrays.equals((byte[])dualKey._key1, (byte[])dualKey._key2)) continue;
                    return false;
                }
                int len = Array.getLength(dualKey._key1);
                if (len != Array.getLength(dualKey._key2)) {
                    return false;
                }
                for (int i = 0; i < len; ++i) {
                    DualKey dk = new DualKey(Array.get(dualKey._key1, i), Array.get(dualKey._key2, i));
                    if (visited.contains(dk)) continue;
                    stack.addFirst(dk);
                }
                continue;
            }
            if (dualKey._key1 instanceof SortedSet) {
                if (DeepEquals.compareOrdered(dualKey, stack, visited)) continue;
                return false;
            }
            if (dualKey._key1 instanceof Set) {
                if (DeepEquals.compareUnordered((Set)dualKey._key1, (Set)dualKey._key2, visited)) continue;
                return false;
            }
            if (dualKey._key1 instanceof Collection) {
                if (DeepEquals.compareOrdered(dualKey, stack, visited)) continue;
                return false;
            }
            if (dualKey._key1 instanceof SortedMap) {
                Map map1 = (Map)dualKey._key1;
                Map map2 = (Map)dualKey._key2;
                if (map1.size() != map2.size()) {
                    return false;
                }
                Iterator i1 = map1.entrySet().iterator();
                Iterator i2 = map2.entrySet().iterator();
                while (i1.hasNext()) {
                    Map.Entry entry1 = i1.next();
                    Map.Entry entry2 = i2.next();
                    DualKey dk = new DualKey(entry1.getKey(), entry2.getKey());
                    if (!visited.contains(dk)) {
                        stack.addFirst(dk);
                    }
                    if (visited.contains(dk = new DualKey(entry1.getValue(), entry2.getValue()))) continue;
                    stack.addFirst(dk);
                }
                continue;
            }
            if (dualKey._key1 instanceof Map) {
                Map map1 = (Map)dualKey._key1;
                Map map2 = (Map)dualKey._key2;
                if (map1.size() != map2.size()) {
                    return false;
                }
                for (Map.Entry entry1 : map1.entrySet()) {
                    Map.Entry saveEntry2 = null;
                    for (Map.Entry entry2 : map2.entrySet()) {
                        if (!DeepEquals.deepEquals(entry1.getKey(), entry2.getKey(), visited)) continue;
                        saveEntry2 = entry2;
                        break;
                    }
                    if (saveEntry2 == null) {
                        return false;
                    }
                    DualKey dk = new DualKey(entry1.getValue(), saveEntry2.getValue());
                    if (visited instanceof ProxyCollection || visited.contains(dk)) continue;
                    stack.addFirst(dk);
                }
                continue;
            }
            if (DeepEquals.hasCustomEquals(dualKey._key1.getClass())) {
                if (dualKey._key1.equals(dualKey._key2)) continue;
                return false;
            }
            Collection<Field> fields = DeepEquals.getDeepDeclaredFields(dualKey._key1.getClass());
            for (Field field : fields) {
                try {
                    DualKey dk = new DualKey(field.get(dualKey._key1), field.get(dualKey._key2));
                    if (dk == null) continue;
                    boolean isPersistentCollection = false;
                    if (dk._key1 != null) {
                        isPersistentCollection = ProxyHelper.isProxyCollection(dk._key1);
                    }
                    if (isPersistentCollection) {
                        dk._key1 = null;
                    }
                    if (isPersistentCollection || visited.contains(dk) || field.isAnnotationPresent(OneToOne.class) || field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ManyToOne.class) || field.isAnnotationPresent(ManyToMany.class)) continue;
                    stack.addFirst(dk);
                }
                catch (Exception e) {}
            }
        }
        return true;
    }

    private static boolean compareOrdered(DualKey dualKey, LinkedList<DualKey> stack, Collection visited) {
        Collection col1 = (Collection)dualKey._key1;
        Collection col2 = (Collection)dualKey._key2;
        if (ProxyHelper.isProxyCollection(col1) || ProxyHelper.isProxyCollection(col2)) {
            return false;
        }
        if (col1.size() != col2.size()) {
            return false;
        }
        Iterator i1 = col1.iterator();
        Iterator i2 = col2.iterator();
        while (i1.hasNext()) {
            DualKey dk = new DualKey(i1.next(), i2.next());
            if (visited.contains(dk)) continue;
            stack.addFirst(dk);
        }
        return true;
    }

    private static boolean compareUnordered(Collection col1, Collection col2, Set visited) {
        int h2;
        if (ProxyHelper.isProxyCollection(col1) || ProxyHelper.isProxyCollection(col2)) {
            return false;
        }
        if (col1.size() != col2.size()) {
            return false;
        }
        int h1 = DeepEquals.deepHashCode(col1);
        if (h1 != (h2 = DeepEquals.deepHashCode(col2))) {
            return false;
        }
        ArrayList copy = new ArrayList(col2);
        for (Object element1 : col1) {
            int len = copy.size();
            for (int i = 0; i < len; ++i) {
                if (!DeepEquals.deepEquals(element1, copy.get(i), visited)) continue;
                copy.remove(i);
                break;
            }
            if (len != copy.size()) continue;
            return false;
        }
        return true;
    }

    public static boolean hasCustomEquals(Class c) {
        Class origClass = c;
        if (_customEquals.containsKey(c)) {
            return _customEquals.get(c);
        }
        while (!Object.class.equals((Object)c)) {
            try {
                c.getDeclaredMethod("equals", Object.class);
                _customEquals.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        _customEquals.put(origClass, false);
        return false;
    }

    public static int deepHashCode(Object obj) {
        HashSet<Object> visited = new HashSet<Object>();
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addFirst(obj);
        int hash = 0;
        while (!stack.isEmpty()) {
            obj = stack.removeFirst();
            if (obj == null || visited.contains(obj)) continue;
            visited.add(obj);
            if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    stack.addFirst(Array.get(obj, i));
                }
                continue;
            }
            if (obj instanceof Collection && !ProxyHelper.isProxyCollection(obj)) {
                stack.addAll(0, (Collection)obj);
                continue;
            }
            if (obj instanceof Map) {
                stack.addAll(0, ((Map)obj).keySet());
                stack.addAll(0, ((Map)obj).values());
                continue;
            }
            if (DeepEquals.hasCustomHashCode(obj.getClass())) {
                hash += obj.hashCode();
                continue;
            }
            Collection<Field> fields = DeepEquals.getDeepDeclaredFields(obj.getClass());
            for (Field field : fields) {
                try {
                    stack.addFirst(field.get(obj));
                }
                catch (Exception ignored) {}
            }
        }
        return hash;
    }

    public static boolean hasCustomHashCode(Class c) {
        Class origClass = c;
        if (_customHash.containsKey(c)) {
            return _customHash.get(c);
        }
        while (!Object.class.equals((Object)c)) {
            try {
                c.getDeclaredMethod("hashCode", new Class[0]);
                _customHash.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        _customHash.put(origClass, false);
        return false;
    }

    public static Collection<Field> getDeepDeclaredFields(Class c) {
        if (_reflectedFields.containsKey(c)) {
            return _reflectedFields.get(c);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class curr = c; curr != null; curr = curr.getSuperclass()) {
            try {
                Field[] local;
                for (Field field : local = curr.getDeclaredFields()) {
                    int modifiers;
                    if (!field.isAccessible()) {
                        try {
                            field.setAccessible(true);
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                    }
                    if (Modifier.isStatic(modifiers = field.getModifiers()) || field.getName().startsWith("this$") || Modifier.isTransient(modifiers)) continue;
                    fields.add(field);
                }
                continue;
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        _reflectedFields.put(c, fields);
        return fields;
    }

    private static class DualKey {
        private Object _key1;
        private Object _key2;

        private DualKey() {
        }

        private DualKey(Object k1, Object k2) {
            this._key1 = k1;
            this._key2 = k2;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof DualKey)) {
                return false;
            }
            DualKey that = (DualKey)other;
            return this._key1 == that._key1 && this._key2 == that._key2;
        }

        public int hashCode() {
            int h1 = this._key1 != null ? this._key1.hashCode() : 0;
            int h2 = this._key2 != null ? this._key2.hashCode() : 0;
            return h1 + h2;
        }
    }
}

