/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.utils;

import com.impetus.kundera.client.EnhanceEntity;
import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.proxy.ProxyHelper;
import com.impetus.kundera.query.KunderaQuery;
import com.impetus.kundera.query.LuceneQueryBuilder;
import com.impetus.kundera.query.QueryHandlerException;
import com.impetus.kundera.utils.InvalidConfigurationException;
import com.impetus.kundera.utils.ReflectUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KunderaCoreUtils {
    private static final String COMPOSITE_KEY_SEPERATOR = "\u0001";
    private static final String LUCENE_COMPOSITE_KEY_SEPERATOR = "_";
    private static Logger logger = LoggerFactory.getLogger(KunderaCoreUtils.class);

    public static Map<String, Object> getExternalProperties(String pu, Map<String, Object> externalProperties, String ... persistenceUnits) {
        if (persistenceUnits != null && persistenceUnits.length > 1 && externalProperties != null) {
            Map puProperty = (Map)externalProperties.get(pu);
            if (puProperty != null) {
                return KunderaCoreUtils.fetchPropertyMap(puProperty);
            }
            return null;
        }
        return externalProperties;
    }

    private static Map<String, Object> fetchPropertyMap(Map<String, Object> puProperty) {
        if (puProperty.getClass().isAssignableFrom(Map.class) || puProperty instanceof Map) {
            return puProperty;
        }
        throw new InvalidConfigurationException("For cross data store persistence, please specify as: Map {pu,Map of properties}");
    }

    public static boolean isEmptyOrNull(Object o) {
        Map m;
        Collection c;
        if (o == null) {
            return true;
        }
        return !ProxyHelper.isProxyOrCollection(o) && (PropertyAccessorHelper.isCollection(o.getClass()) ? (c = (Collection)o).isEmpty() : Map.class.isAssignableFrom(o.getClass()) && (m = (Map)o).isEmpty());
    }

    public static String prepareCompositeKey(EntityMetadata m, Object compositeKey) {
        Field[] fields = m.getIdAttribute().getBindableJavaType().getDeclaredFields();
        StringBuilder stringBuilder = new StringBuilder();
        for (Field f : fields) {
            if (ReflectUtils.isTransientOrStatic(f)) continue;
            try {
                String fieldValue = PropertyAccessorHelper.getString(compositeKey, f);
                stringBuilder.append(fieldValue);
                stringBuilder.append(COMPOSITE_KEY_SEPERATOR);
            }
            catch (IllegalArgumentException e) {
                logger.error("Error during prepare composite key, Caused by {}.", (Throwable)e);
                throw new PersistenceException((Throwable)e);
            }
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(COMPOSITE_KEY_SEPERATOR));
        }
        return stringBuilder.toString();
    }

    public static String prepareCompositeKey(SingularAttribute attribute, MetamodelImpl metaModel, Object compositeKey) {
        Field[] fields = attribute.getBindableJavaType().getDeclaredFields();
        EmbeddableType embeddable = metaModel.embeddable(attribute.getBindableJavaType());
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Field f : fields) {
                if (ReflectUtils.isTransientOrStatic(f)) continue;
                if (metaModel.isEmbeddable(((AbstractAttribute)embeddable.getAttribute(f.getName())).getBindableJavaType())) {
                    f.setAccessible(true);
                    stringBuilder.append(KunderaCoreUtils.prepareCompositeKey((SingularAttribute)embeddable.getAttribute(f.getName()), metaModel, f.get(compositeKey))).append(LUCENE_COMPOSITE_KEY_SEPERATOR);
                    continue;
                }
                String fieldValue = PropertyAccessorHelper.getString(compositeKey, f);
                fieldValue = fieldValue.replaceAll("[^a-zA-Z0-9]", LUCENE_COMPOSITE_KEY_SEPERATOR);
                stringBuilder.append(fieldValue);
                stringBuilder.append(LUCENE_COMPOSITE_KEY_SEPERATOR);
            }
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.error("Error during prepare composite key, Caused by {}.", (Throwable)e);
            throw new PersistenceException((Throwable)e);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(LUCENE_COMPOSITE_KEY_SEPERATOR));
        }
        return stringBuilder.toString();
    }

    public static String resolvePath(String input) {
        if (null == input) {
            return input;
        }
        Pattern pathPattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher matcherPattern = pathPattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        EnvironmentConfiguration config = new EnvironmentConfiguration();
        SystemConfiguration sysConfig = new SystemConfiguration();
        while (matcherPattern.find()) {
            String confVarName = matcherPattern.group(1) != null ? matcherPattern.group(1) : matcherPattern.group(2);
            String envConfVarValue = config.getString(confVarName);
            String sysVarValue = sysConfig.getString(confVarName);
            if (envConfVarValue != null) {
                matcherPattern.appendReplacement(sb, envConfVarValue);
                continue;
            }
            if (sysVarValue != null) {
                matcherPattern.appendReplacement(sb, sysVarValue);
                continue;
            }
            matcherPattern.appendReplacement(sb, "");
        }
        matcherPattern.appendTail(sb);
        return sb.toString();
    }

    public static int countNonSyntheticFields(Class<?> clazz) {
        int count = 0;
        for (Field f : clazz.getDeclaredFields()) {
            if (f.isSynthetic() && ReflectUtils.isTransientOrStatic(f)) continue;
            ++count;
        }
        return count;
    }

    public static String getLuceneQueryFromJPAQuery(KunderaQuery kunderaQuery, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        LuceneQueryBuilder queryBuilder = new LuceneQueryBuilder();
        EntityMetadata metadata = kunderaQuery.getEntityMetadata();
        MetamodelImpl metaModel = (MetamodelImpl)kunderaMetadata.getApplicationMetadata().getMetamodel(metadata.getPersistenceUnit());
        Class valueClazz = null;
        EntityType<?> entity = metaModel.entity(metadata.getEntityClazz());
        boolean partitionKeyCheck = true;
        for (Object object : kunderaQuery.getFilterClauseQueue()) {
            if (object instanceof KunderaQuery.FilterClause) {
                KunderaQuery.FilterClause filter = (KunderaQuery.FilterClause)object;
                String property = filter.getProperty();
                String condition2 = filter.getCondition();
                String valueAsString = filter.getValue().get(0).toString();
                String fieldName = metadata.getFieldName(property);
                boolean isEmbeddedId = metaModel.isEmbeddable(metadata.getIdAttribute().getBindableJavaType());
                String idColumn = ((AbstractAttribute)metadata.getIdAttribute()).getJPAColumnName();
                valueClazz = KunderaCoreUtils.getValueType(entity, fieldName);
                if (isEmbeddedId) {
                    if (idColumn.equals(property)) {
                        valueAsString = KunderaCoreUtils.prepareCompositeKey(metadata.getIdAttribute(), metaModel, filter.getValue().get(0));
                        queryBuilder.appendIndexName(metadata.getIndexName()).appendPropertyName(idColumn).buildQuery(condition2, valueAsString, valueClazz);
                        continue;
                    }
                    valueClazz = metadata.getIdAttribute().getBindableJavaType();
                    if (property.lastIndexOf(46) != property.indexOf(46) && partitionKeyCheck) {
                        KunderaCoreUtils.isCompletePartitionKeyPresentInQuery(kunderaQuery.getFilterClauseQueue(), metaModel, metadata);
                        partitionKeyCheck = false;
                    }
                    if (metaModel.isEmbeddable(filter.getValue().get(0).getClass())) {
                        KunderaCoreUtils.prepareLuceneQueryForPartitionKey(queryBuilder, filter.getValue().get(0), metaModel, metadata.getIndexName(), valueClazz);
                        continue;
                    }
                    property = property.substring(property.lastIndexOf(".") + 1);
                    queryBuilder.appendIndexName(metadata.getIndexName()).appendPropertyName(KunderaCoreUtils.getPropertyName(metadata, property, kunderaMetadata)).buildQuery(condition2, valueAsString, valueClazz);
                    continue;
                }
                queryBuilder.appendIndexName(metadata.getIndexName()).appendPropertyName(KunderaCoreUtils.getPropertyName(metadata, property, kunderaMetadata)).buildQuery(condition2, valueAsString, valueClazz);
                continue;
            }
            queryBuilder.buildQuery(object.toString(), object.toString(), String.class);
        }
        queryBuilder.appendEntityName(kunderaQuery.getEntityClass().getCanonicalName().toLowerCase());
        return queryBuilder.getQuery();
    }

    private static void isCompletePartitionKeyPresentInQuery(Queue filterQueue, MetamodelImpl metaModel, EntityMetadata metadata) {
        HashSet<String> partitionKeyFields = new HashSet<String>();
        KunderaCoreUtils.populateEmbeddedIdFields(metaModel.embeddable(metadata.getIdAttribute().getBindableJavaType()).getAttributes(), metaModel, partitionKeyFields);
        HashSet<String> queryAttributes = new HashSet<String>();
        for (Object object : filterQueue) {
            String[] filterAttr;
            if (!(object instanceof KunderaQuery.FilterClause)) continue;
            KunderaQuery.FilterClause filter = (KunderaQuery.FilterClause)object;
            String property = filter.getProperty();
            for (String s : filterAttr = property.split("\\.")) {
                queryAttributes.add(s);
            }
        }
        if (!queryAttributes.containsAll(partitionKeyFields)) {
            throw new QueryHandlerException("Incomplete partition key fields in query");
        }
    }

    private static void populateEmbeddedIdFields(Set<Attribute> embeddedAttributes, MetamodelImpl metaModel, Set<String> embeddedIdFields) {
        for (Attribute attribute : embeddedAttributes) {
            if (ReflectUtils.isTransientOrStatic((Field)attribute.getJavaMember()) || !metaModel.isEmbeddable(attribute.getJavaType())) continue;
            EmbeddableType embeddable = metaModel.embeddable(attribute.getJavaType());
            KunderaCoreUtils.populateEmbeddedIdFieldsUtil(embeddable.getAttributes(), metaModel, embeddedIdFields);
        }
    }

    private static void populateEmbeddedIdFieldsUtil(Set<Attribute> embeddedAttributes, MetamodelImpl metaModel, Set<String> embeddedIdFields) {
        for (Attribute attribute : embeddedAttributes) {
            if (ReflectUtils.isTransientOrStatic((Field)attribute.getJavaMember())) continue;
            if (metaModel.isEmbeddable(attribute.getJavaType())) {
                EmbeddableType embeddable = metaModel.embeddable(attribute.getJavaType());
                KunderaCoreUtils.populateEmbeddedIdFieldsUtil(embeddable.getAttributes(), metaModel, embeddedIdFields);
                continue;
            }
            String columnName = ((AbstractAttribute)attribute).getJPAColumnName();
            embeddedIdFields.add(columnName);
        }
    }

    private static void prepareLuceneQueryForPartitionKey(LuceneQueryBuilder queryBuilder, Object key, MetamodelImpl metaModel, String indexName, Class valueClazz) {
        Field[] fields = key.getClass().getDeclaredFields();
        EmbeddableType<?> embeddable = metaModel.embeddable(key.getClass());
        boolean appendAnd = false;
        try {
            for (int i = 0; i < fields.length; ++i) {
                if (ReflectUtils.isTransientOrStatic(fields[i])) continue;
                if (metaModel.isEmbeddable(((AbstractAttribute)embeddable.getAttribute(fields[i].getName())).getBindableJavaType())) {
                    fields[i].setAccessible(true);
                    KunderaCoreUtils.prepareLuceneQueryForPartitionKey(queryBuilder, fields[i].get(key), metaModel, indexName, valueClazz);
                    continue;
                }
                if (appendAnd) {
                    queryBuilder.buildQuery("AND", "AND", String.class);
                }
                appendAnd = true;
                String fieldValue = PropertyAccessorHelper.getString(key, fields[i]);
                fieldValue = fieldValue.replaceAll("[^a-zA-Z0-9]", LUCENE_COMPOSITE_KEY_SEPERATOR);
                queryBuilder.appendIndexName(indexName).appendPropertyName(fields[i].getName()).buildQuery("=", fieldValue, valueClazz);
            }
        }
        catch (IllegalArgumentException e) {
            logger.error("Error during prepare composite key, Caused by {}.", (Throwable)e);
            throw new PersistenceException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage());
        }
    }

    private static Class getValueType(EntityType entity, String fieldName) {
        Class valueClazz = null;
        if (fieldName != null) {
            valueClazz = ((AbstractAttribute)entity.getAttribute(fieldName)).getBindableJavaType();
        }
        return valueClazz;
    }

    private static String getPropertyName(EntityMetadata metadata, String property, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        if (MetadataUtils.getEnclosingEmbeddedFieldName(metadata, property, true, kunderaMetadata) != null) {
            return property.substring(property.indexOf(".") + 1, property.length());
        }
        return property;
    }

    public static boolean isShowQueryEnabled(Map<String, Object> properties, String persistenceUnit, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        boolean showQuery = false;
        boolean bl = showQuery = properties != null ? Boolean.parseBoolean((String)properties.get("kundera.show.query")) : false;
        if (!showQuery) {
            showQuery = persistenceUnit != null ? Boolean.parseBoolean(kunderaMetadata.getApplicationMetadata().getPersistenceUnitMetadata(persistenceUnit).getProperties().getProperty("kundera.show.query")) : false;
        }
        return showQuery;
    }

    public static void printQuery(String query, boolean showQuery) {
        if (showQuery) {
            System.out.println(query);
        }
    }

    public static void printQueryWithFilterClause(Queue filterClausequeue, String tableName) {
        StringBuilder printQuery = new StringBuilder("Fetch data from ").append(tableName).append(" for ");
        for (Object clause : filterClausequeue) {
            if (clause instanceof KunderaQuery.FilterClause) {
                printQuery.append(((KunderaQuery.FilterClause)clause).getProperty()).append(" ").append(((KunderaQuery.FilterClause)clause).getCondition()).append(" ").append(((KunderaQuery.FilterClause)clause).getValue());
                continue;
            }
            printQuery.append(" ").append(clause.toString()).append(" ");
        }
        KunderaCoreUtils.printQuery(printQuery.toString(), true);
    }

    public static Object getEntity(Object e) {
        if (e != null) {
            return e.getClass().isAssignableFrom(EnhanceEntity.class) ? ((EnhanceEntity)e).getEntity() : e;
        }
        return null;
    }

    public static Object initialize(EntityMetadata m, Object entity, Object id) {
        try {
            if (entity == null) {
                entity = KunderaCoreUtils.createNewInstance(m.getEntityClazz());
            }
            if (id != null) {
                PropertyAccessorHelper.setId(entity, m, id);
            }
            return entity;
        }
        catch (Exception e) {
            throw new PersistenceException("Error occured while instantiating entity.", (Throwable)e);
        }
    }

    public static Object initialize(Class clazz, Object record) {
        try {
            if (record == null) {
                record = KunderaCoreUtils.createNewInstance(clazz);
            }
            return record;
        }
        catch (Exception e) {
            throw new PersistenceException("Error occured while instantiating entity.", (Throwable)e);
        }
    }

    public static Object createNewInstance(Class clazz) {
        Object target = null;
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                if (!Modifier.isProtected(constructor.getModifiers()) && !Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterTypes().length != 0) continue;
                constructor.setAccessible(true);
                target = constructor.newInstance(new Object[0]);
                constructor.setAccessible(false);
                break;
            }
            return target;
        }
        catch (InstantiationException iex) {
            logger.error("Error while creating an instance of {} .", (Object)clazz);
            throw new PersistenceException((Throwable)iex);
        }
        catch (IllegalAccessException iaex) {
            logger.error("Illegal Access while reading data from {}, Caused by: .", (Object)clazz, (Object)iaex);
            throw new PersistenceException((Throwable)iaex);
        }
        catch (Exception e) {
            logger.error("Error while creating an instance of {}, Caused by: .", (Object)clazz, (Object)e);
            throw new PersistenceException((Throwable)e);
        }
    }
}

