/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;

public final class NumericUtils {
    private static Map<Class, NumberType> numberTypes = new HashMap<Class, NumberType>();

    public static final boolean checkIfZero(String value, Class valueClazz) {
        boolean returnValue = false;
        if (value != null && NumberUtils.isNumber((String)value) && numberTypes.get(valueClazz) != null) {
            switch (numberTypes.get(valueClazz)) {
                case INTEGER: {
                    returnValue = Integer.parseInt(value) == NumberUtils.INTEGER_ZERO;
                    break;
                }
                case FLOAT: {
                    returnValue = Float.parseFloat(value) == NumberUtils.FLOAT_ZERO.floatValue();
                    break;
                }
                case LONG: {
                    returnValue = Long.parseLong(value) == NumberUtils.LONG_ZERO;
                    break;
                }
                case BIGDECIMAL: {
                    returnValue = new BigDecimal(value) == BigDecimal.ZERO;
                    break;
                }
                case BIGINTEGER: {
                    returnValue = new BigInteger(value) == BigInteger.ZERO;
                    break;
                }
                case SHORT: {
                    returnValue = new Short(value) == NumberUtils.SHORT_ZERO;
                }
            }
        }
        return returnValue;
    }

    static {
        numberTypes.put(Integer.TYPE, NumberType.INTEGER);
        numberTypes.put(Integer.class, NumberType.INTEGER);
        numberTypes.put(Float.TYPE, NumberType.FLOAT);
        numberTypes.put(Float.class, NumberType.FLOAT);
        numberTypes.put(Long.TYPE, NumberType.LONG);
        numberTypes.put(Long.class, NumberType.LONG);
        numberTypes.put(Double.TYPE, NumberType.DOUBLE);
        numberTypes.put(Double.class, NumberType.DOUBLE);
        numberTypes.put(BigDecimal.class, NumberType.BIGDECIMAL);
        numberTypes.put(Short.TYPE, NumberType.SHORT);
        numberTypes.put(Short.class, NumberType.SHORT);
        numberTypes.put(BigInteger.class, NumberType.BIGINTEGER);
    }

    static enum NumberType {
        INTEGER,
        FLOAT,
        LONG,
        DOUBLE,
        BIGDECIMAL,
        SHORT,
        BIGINTEGER;

    }
}

