/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.utils;

import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.property.PropertyAccessor;
import com.impetus.kundera.property.PropertyAccessorFactory;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.proxy.KunderaProxy;
import com.impetus.kundera.proxy.ProxyHelper;
import com.impetus.kundera.proxy.collection.ProxyCollection;
import com.impetus.kundera.utils.KunderaCoreUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtils {
    private static Logger log = LoggerFactory.getLogger(ObjectUtils.class);

    public static final Object deepCopy(Object source, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        HashMap<Object, Object> copiedObjectMap = new HashMap<Object, Object>();
        Object target = ObjectUtils.deepCopyUsingMetadata(source, copiedObjectMap, kunderaMetadata);
        copiedObjectMap.clear();
        copiedObjectMap = null;
        return target;
    }

    private static Object deepCopyUsingMetadata(Object source, Map<Object, Object> copiedObjectMap, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        Object target = null;
        try {
            if (source == null) {
                return null;
            }
            Class<?> sourceObjectClass = source.getClass();
            EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(kunderaMetadata, sourceObjectClass);
            if (metadata == null) {
                return source;
            }
            MetamodelImpl metaModel = (MetamodelImpl)kunderaMetadata.getApplicationMetadata().getMetamodel(metadata.getPersistenceUnit());
            EntityType<?> entityType = metaModel.entity(sourceObjectClass);
            Object id = null;
            if (metadata.getRelations() != null && !metadata.getRelations().isEmpty()) {
                id = PropertyAccessorHelper.getId(source, metadata);
                StringBuilder keyBuilder = new StringBuilder(sourceObjectClass.getName());
                keyBuilder.append("#");
                keyBuilder.append(id);
                Object copiedObjectInMap = copiedObjectMap.get(keyBuilder.toString());
                if (copiedObjectInMap != null) {
                    return copiedObjectInMap;
                }
            }
            target = KunderaCoreUtils.createNewInstance(sourceObjectClass);
            for (Attribute attrib : entityType.getAttributes()) {
                Field columnField = (Field)attrib.getJavaMember();
                if (attrib.getPersistentAttributeType().equals((Object)Attribute.PersistentAttributeType.EMBEDDED) || attrib.getPersistentAttributeType().equals((Object)Attribute.PersistentAttributeType.ELEMENT_COLLECTION)) {
                    EmbeddableType embeddedColumn = metaModel.embeddable(((AbstractAttribute)attrib).getBindableJavaType());
                    Object sourceEmbeddedObj = PropertyAccessorHelper.getObject(source, columnField);
                    if (sourceEmbeddedObj == null) continue;
                    if (metaModel.isEmbeddable(((AbstractAttribute)attrib).getBindableJavaType())) {
                        if (attrib.isCollection()) {
                            Class<?> ecDeclaredClass = columnField.getType();
                            Class<?> actualEcObjectClass = sourceEmbeddedObj.getClass();
                            Object targetCollectionObject = actualEcObjectClass.newInstance();
                            if (sourceEmbeddedObj instanceof Collection) {
                                Class<?> genericClass = PropertyAccessorHelper.getGenericClass(columnField);
                                for (Object sourceEcObj : (Collection)sourceEmbeddedObj) {
                                    Method m;
                                    Object targetEcObj = null;
                                    if (sourceEcObj != null && Type.PersistenceType.BASIC.equals((Object)embeddedColumn.getPersistenceType())) {
                                        PropertyAccessor accessor = PropertyAccessorFactory.getPropertyAccessor(sourceEcObj.getClass());
                                        if (accessor != null) {
                                            targetEcObj = accessor.getCopy(sourceEcObj);
                                        }
                                    } else if (sourceEcObj != null && Type.PersistenceType.EMBEDDABLE.equals((Object)embeddedColumn.getPersistenceType())) {
                                        targetEcObj = genericClass.newInstance();
                                        for (Field f : genericClass.getDeclaredFields()) {
                                            if (f == null || Modifier.isStatic(f.getModifiers())) continue;
                                            PropertyAccessorHelper.set(targetEcObj, f, PropertyAccessorHelper.getObjectCopy(sourceEcObj, f));
                                        }
                                    }
                                    if (List.class.isAssignableFrom(ecDeclaredClass)) {
                                        m = actualEcObjectClass.getMethod("add", Object.class);
                                        m.invoke(targetCollectionObject, targetEcObj);
                                        continue;
                                    }
                                    if (!Set.class.isAssignableFrom(ecDeclaredClass)) continue;
                                    m = actualEcObjectClass.getMethod("add", Object.class);
                                    m.invoke(targetCollectionObject, targetEcObj);
                                }
                            } else if (sourceEmbeddedObj instanceof Map) {
                                for (Object sourceKey : ((Map)sourceEmbeddedObj).keySet()) {
                                    Object targetKey = null;
                                    Object targetValue = null;
                                    if (!Type.PersistenceType.BASIC.equals((Object)embeddedColumn.getPersistenceType()) && !Type.PersistenceType.EMBEDDABLE.equals((Object)embeddedColumn.getPersistenceType())) continue;
                                    if (sourceKey != null) {
                                        PropertyAccessor keyAccessor = PropertyAccessorFactory.getPropertyAccessor(sourceKey.getClass());
                                        if (keyAccessor != null) {
                                            targetKey = keyAccessor.getCopy(sourceKey);
                                        }
                                    } else {
                                        targetKey = null;
                                    }
                                    Object sourceValue = ((Map)sourceEmbeddedObj).get(sourceKey);
                                    if (sourceValue != null) {
                                        PropertyAccessor valueAccessor = PropertyAccessorFactory.getPropertyAccessor(sourceValue.getClass());
                                        if (valueAccessor != null) {
                                            targetValue = valueAccessor.getCopy(sourceValue);
                                        }
                                    } else {
                                        targetValue = null;
                                    }
                                    if (!Map.class.isAssignableFrom(ecDeclaredClass)) continue;
                                    Method m = actualEcObjectClass.getMethod("put", Object.class, Object.class);
                                    m.invoke(targetCollectionObject, new Object[]{targetKey, targetValue});
                                }
                            }
                            PropertyAccessorHelper.set(target, columnField, targetCollectionObject);
                            continue;
                        }
                        Class<?> embeddedColumnClass = columnField.getType();
                        Object targetEmbeddedObj = embeddedColumnClass.newInstance();
                        Set columns = embeddedColumn.getAttributes();
                        for (Attribute column : columns) {
                            PropertyAccessorHelper.set(targetEmbeddedObj, (Field)column.getJavaMember(), PropertyAccessorHelper.getObjectCopy(sourceEmbeddedObj, (Field)column.getJavaMember()));
                        }
                        PropertyAccessorHelper.set(target, columnField, targetEmbeddedObj);
                        continue;
                    }
                    if (((AbstractAttribute)attrib).getJPAColumnName() == null) continue;
                    PropertyAccessorHelper.set(target, columnField, sourceEmbeddedObj);
                    continue;
                }
                if (!attrib.getPersistentAttributeType().equals((Object)Attribute.PersistentAttributeType.BASIC)) continue;
                PropertyAccessorHelper.set(target, columnField, PropertyAccessorHelper.getObjectCopy(source, columnField));
            }
            if (id != null) {
                StringBuilder keyBuilder = new StringBuilder(sourceObjectClass.getName());
                keyBuilder.append("#");
                keyBuilder.append(id);
                copiedObjectMap.put(keyBuilder.toString(), target);
            }
            for (Relation relation : metadata.getRelations()) {
                Method m;
                Field relationField;
                Object sourceRelationObject;
                if (relation == null || (sourceRelationObject = PropertyAccessorHelper.getObject(source, relationField = relation.getProperty())) == null) continue;
                if (sourceRelationObject instanceof KunderaProxy) {
                    PropertyAccessorHelper.set(target, relationField, sourceRelationObject);
                    continue;
                }
                if (ProxyHelper.isPersistentCollection(sourceRelationObject)) {
                    PropertyAccessorHelper.set(target, relationField, sourceRelationObject);
                    continue;
                }
                if (ProxyHelper.isKunderaProxyCollection(sourceRelationObject)) {
                    ProxyCollection pc = ((ProxyCollection)sourceRelationObject).getCopy();
                    pc.setOwner(target);
                    PropertyAccessorHelper.set(target, relationField, pc);
                    continue;
                }
                Object targetRelationObject = null;
                Class<?> relationObjectClass = relation.getProperty().getType();
                Class<?> actualRelationObjectClass = sourceRelationObject.getClass();
                if (Collection.class.isAssignableFrom(relationObjectClass)) {
                    targetRelationObject = actualRelationObjectClass.newInstance();
                    m = actualRelationObjectClass.getMethod("add", Object.class);
                    for (Object obj : (Collection)sourceRelationObject) {
                        Object copyTargetRelObj = ObjectUtils.searchInCacheThenCopy(copiedObjectMap, obj, kunderaMetadata);
                        m.invoke(targetRelationObject, copyTargetRelObj);
                    }
                } else if (Map.class.isAssignableFrom(relationObjectClass)) {
                    targetRelationObject = actualRelationObjectClass.newInstance();
                    m = actualRelationObjectClass.getMethod("put", Object.class, Object.class);
                    for (Object keyObj : ((Map)sourceRelationObject).keySet()) {
                        Object valObj = ((Map)sourceRelationObject).get(keyObj);
                        Object copyTargetKeyObj = ObjectUtils.searchInCacheThenCopy(copiedObjectMap, keyObj, kunderaMetadata);
                        Object copyTargetValueObj = ObjectUtils.searchInCacheThenCopy(copiedObjectMap, valObj, kunderaMetadata);
                        m.invoke(targetRelationObject, copyTargetKeyObj, copyTargetValueObj);
                    }
                } else {
                    targetRelationObject = ObjectUtils.searchInCacheThenCopy(copiedObjectMap, sourceRelationObject, kunderaMetadata);
                }
                PropertyAccessorHelper.set(target, relationField, targetRelationObject);
            }
        }
        catch (InstantiationException e) {
            log.warn("Error while instantiating entity/ embeddable class, did you define no-arg constructor?, Caused by:" + e.getMessage());
            return null;
        }
        catch (Exception e) {
            log.warn("Returning null as error during clone, Caused by:" + e.getMessage());
            return null;
        }
        return target;
    }

    private static Object searchInCacheThenCopy(Map<Object, Object> copiedObjectMap, Object sourceObject, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        Object copyTargetRelObj = null;
        copyTargetRelObj = ObjectUtils.deepCopyUsingMetadata(sourceObject, copiedObjectMap, kunderaMetadata);
        return copyTargetRelObj;
    }

    public static Object getFieldInstance(List chids, Field f) {
        if (Set.class.isAssignableFrom(f.getType())) {
            HashSet col = new HashSet(chids);
            return col;
        }
        return chids;
    }
}

