/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.utils;

import com.impetus.kundera.KunderaException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javassist.Modifier;
import javax.persistence.Transient;

public class ReflectUtils {
    private ReflectUtils() {
    }

    public static boolean hasInterface(Class<?> has, Class<?> in) {
        if (has.equals(in)) {
            return true;
        }
        boolean match = false;
        for (Class<?> intrface : in.getInterfaces()) {
            match = intrface.getInterfaces().length > 0 ? ReflectUtils.hasInterface(has, intrface) : intrface.equals(has);
            if (!match) continue;
            return true;
        }
        return false;
    }

    public static Type[] getTypeArguments(Field property) {
        Type type = property.getGenericType();
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return null;
    }

    public static boolean hasSuperClass(Class<?> has, Class<?> in) {
        if (in.equals(has)) {
            return true;
        }
        boolean match = false;
        if (in.getSuperclass() != null && in.getSuperclass().equals(Object.class)) {
            return match;
        }
        match = in.getSuperclass() != null ? ReflectUtils.hasSuperClass(has, in.getSuperclass()) : false;
        return match;
    }

    public static Class<?> classForName(String className, ClassLoader classLoader) {
        try {
            Class<?> c = null;
            try {
                c = Class.forName(className, true, ReflectUtils.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                try {
                    c = Class.forName(className);
                }
                catch (ClassNotFoundException e1) {
                    if (classLoader == null) {
                        throw e1;
                    }
                    c = classLoader.loadClass(className);
                }
            }
            return c;
        }
        catch (ClassNotFoundException e) {
            throw new KunderaException(e);
        }
    }

    public static Class<?> stripEnhancerClass(Class<?> c) {
        String className = c.getName();
        int enhancedIndex = className.indexOf("$$EnhancerByCGLIB");
        if (enhancedIndex != -1) {
            className = className.substring(0, enhancedIndex);
        }
        if (className.equals(c.getName())) {
            return c;
        }
        c = ReflectUtils.classForName(className, c.getClassLoader());
        return c;
    }

    public static boolean isTransientOrStatic(Field field) {
        return field != null && (Modifier.isStatic((int)field.getModifiers()) || Modifier.isTransient((int)field.getModifiers()) || field.isAnnotationPresent(Transient.class));
    }
}

