/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.validation;

import com.impetus.kundera.validation.ValidationFactory;
import com.impetus.kundera.validation.rules.EntityRule;
import com.impetus.kundera.validation.rules.FieldRule;
import com.impetus.kundera.validation.rules.IRule;
import com.impetus.kundera.validation.rules.RuleValidationException;
import java.lang.reflect.Field;

public abstract class AbstractValidationFactory {
    protected ValidationFactory.RuleFactory ruleFactory = new ValidationFactory.RuleFactory();

    public boolean validate(Class clazz, IRule ... rules) throws RuleValidationException {
        for (IRule rule : rules) {
            ((EntityRule)rule).validate(clazz);
        }
        return true;
    }

    public boolean validate(Field field, IRule ... rules) throws RuleValidationException {
        for (IRule rule : rules) {
            ((FieldRule)rule).validate(field);
        }
        return true;
    }

    public boolean validate(Field field, Object fieldValue, IRule ... rules) throws RuleValidationException {
        for (IRule rule : rules) {
            ((FieldRule)rule).validate(field, fieldValue);
        }
        return true;
    }

    public boolean validate(Class clazz) throws RuleValidationException {
        throw new UnsupportedOperationException("Bootstrap level validations are not supported at operation level!");
    }
}

