/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.validation.rules;

import com.impetus.kundera.validation.rules.AbstractEntityRule;
import com.impetus.kundera.validation.rules.EntityRule;
import com.impetus.kundera.validation.rules.RuleValidationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityAnnotationRule
extends AbstractEntityRule
implements EntityRule {
    private static final Logger log = LoggerFactory.getLogger(EntityAnnotationRule.class);

    @Override
    public void validate(Class<?> clazz) {
        if (log.isDebugEnabled()) {
            log.debug("Validating " + clazz.getName());
        }
        if (!this.checkValidClass(clazz)) {
            throw new RuleValidationException(clazz.getName() + " is not a valid jpa entity.");
        }
        boolean flag = false;
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                if (!Modifier.isPublic(constructor.getModifiers()) && !Modifier.isProtected(constructor.getModifiers()) || constructor.getParameterTypes().length != 0) continue;
                flag = true;
                break;
            }
            if (!flag) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new RuleValidationException(clazz.getName() + " must have a default public or protected no-argument constructor.");
        }
    }

    private boolean checkValidClass(Class<?> clazz) {
        return clazz.isAnnotationPresent(Entity.class) || clazz.isAnnotationPresent(MappedSuperclass.class) || clazz.isAnnotationPresent(Embeddable.class);
    }
}

