/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.classreading;

import com.impetus.kundera.classreading.AnnotationDiscoveryListener;
import com.impetus.kundera.classreading.ClassFileIterator;
import com.impetus.kundera.classreading.Filter;
import com.impetus.kundera.classreading.JarFileIterator;
import com.impetus.kundera.classreading.ResourceIterator;
import com.impetus.kundera.classreading.ResourceReadingException;
import com.impetus.kundera.loader.PersistenceXMLLoader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;

public abstract class Reader {
    private List<String> validAnnotations = new ArrayList<String>();
    private List<AnnotationDiscoveryListener> annotationDiscoveryListeners = new ArrayList<AnnotationDiscoveryListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanClass(InputStream bits) throws IOException {
        DataInputStream dstream = new DataInputStream(new BufferedInputStream(bits));
        ClassFile cf = null;
        try {
            cf = new ClassFile(dstream);
            String className = cf.getName();
            ArrayList<String> annotations = new ArrayList<String>();
            this.accumulateAnnotations(annotations, (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations"));
            this.accumulateAnnotations(annotations, (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations"));
            for (String validAnn : this.getValidAnnotations()) {
                if (!annotations.contains(validAnn)) continue;
                for (AnnotationDiscoveryListener listener : this.getAnnotationDiscoveryListeners()) {
                    listener.discovered(className);
                }
            }
        }
        finally {
            dstream.close();
            bits.close();
        }
    }

    public void accumulateAnnotations(List<String> annotations, AnnotationsAttribute annatt) {
        if (null == annatt) {
            return;
        }
        for (Annotation ann : annatt.getAnnotations()) {
            annotations.add(ann.getTypeName());
        }
    }

    public ResourceIterator getResourceIterator(URL url, Filter filter) {
        String urlString = url.toString();
        try {
            if (urlString.endsWith("!/")) {
                urlString = urlString.substring(4);
                urlString = urlString.substring(0, urlString.length() - 2);
                url = new URL(urlString);
            }
            if (urlString.endsWith(".class")) {
                File f = new File(url.getPath());
                return new ClassFileIterator(f);
            }
            if (!urlString.endsWith("/")) {
                return new JarFileIterator(url.openStream(), filter);
            }
            if (!url.getProtocol().equals("file")) {
                throw new ResourceReadingException("Unable to understand protocol: " + url.getProtocol());
            }
            File f = new File(url.getPath());
            if (f.isDirectory() || url.getProtocol().toUpperCase().equals(PersistenceXMLLoader.AllowedProtocol.VFS.name())) {
                return new ClassFileIterator(f, filter);
            }
            return new JarFileIterator(url.openStream(), filter);
        }
        catch (MalformedURLException e) {
            throw new ResourceReadingException(e);
        }
        catch (IOException e) {
            throw new ResourceReadingException(e);
        }
    }

    public List<String> getValidAnnotations() {
        return this.validAnnotations;
    }

    public void addValidAnnotations(String annotation) {
        this.validAnnotations.add(annotation);
    }

    public List<AnnotationDiscoveryListener> getAnnotationDiscoveryListeners() {
        return this.annotationDiscoveryListeners;
    }

    public void addAnnotationDiscoveryListeners(AnnotationDiscoveryListener annotationDiscoveryListener) {
        this.annotationDiscoveryListeners.add(annotationDiscoveryListener);
    }

    public abstract void read();

    public abstract Filter getFilter();

    public abstract URL[] findResources();

    public abstract InputStream[] findResourcesAsStream();

    public abstract URL[] findResourcesByClasspath();
}

