/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.client;

import com.impetus.kundera.db.RelationHolder;
import com.impetus.kundera.graph.Node;
import com.impetus.kundera.graph.NodeLink;
import com.impetus.kundera.index.IndexManager;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.ClientMetadata;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.utils.KunderaCoreUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ClientBase {
    protected IndexManager indexManager;
    protected String persistenceUnit;
    protected boolean isUpdate;
    protected ClientMetadata clientMetadata;
    protected final EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata;
    protected final boolean showQuery;
    protected Map<String, Object> externalProperties;

    public String getAutoGenerator() {
        return this.getClientMetadata() != null ? this.getClientMetadata().getAutoGenImplementor() : null;
    }

    protected ClientBase(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, Map<String, Object> properties, String persistenceUnit) {
        this.kunderaMetadata = kunderaMetadata;
        this.externalProperties = properties;
        this.persistenceUnit = persistenceUnit;
        this.showQuery = KunderaCoreUtils.isShowQueryEnabled(properties, persistenceUnit, kunderaMetadata);
    }

    public final IndexManager getIndexManager() {
        return this.indexManager;
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void persist(Node node) {
        Object entity = node.getData();
        Object id = node.getEntityId();
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, node.getDataClass());
        this.isUpdate = node.isUpdate();
        List<RelationHolder> relationHolders = this.getRelationHolders(node);
        this.onPersist(metadata, entity, id, relationHolders);
        id = PropertyAccessorHelper.getId(entity, metadata);
        node.setEntityId(id);
        this.indexNode(node, metadata);
    }

    public void remove(Object entity, Object pKey) {
        this.delete(entity, pKey);
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, entity.getClass());
        this.unIndexNode(metadata, entity, pKey);
    }

    protected void unIndexNode(EntityMetadata metadata, Object entity, Object pKey) {
        if (this.indexManager != null) {
            this.indexManager.remove(metadata, entity, pKey);
        }
    }

    protected List<RelationHolder> getRelationHolders(Node node) {
        RelationHolder relationHolder;
        Relation.ForeignKey multiplicity;
        boolean isSharedByPrimaryKey;
        Object linkValue;
        String linkName;
        ArrayList<RelationHolder> relationsHolder = new ArrayList<RelationHolder>();
        Map<NodeLink, Node> parents = node.getParents();
        Map<NodeLink, Node> children = node.getChildren();
        if (parents != null && !parents.isEmpty()) {
            for (NodeLink parentNodeLink : parents.keySet()) {
                linkName = (String)parentNodeLink.getLinkProperty(NodeLink.LinkProperty.LINK_NAME);
                linkValue = parentNodeLink.getLinkProperty(NodeLink.LinkProperty.LINK_VALUE) != null ? parentNodeLink.getLinkProperty(NodeLink.LinkProperty.LINK_VALUE) : parents.get(parentNodeLink).getEntityId();
                isSharedByPrimaryKey = (Boolean)parentNodeLink.getLinkProperty(NodeLink.LinkProperty.IS_SHARED_BY_PRIMARY_KEY);
                multiplicity = parentNodeLink.getMultiplicity();
                if (linkName == null || linkValue == null || isSharedByPrimaryKey || !multiplicity.equals((Object)Relation.ForeignKey.ONE_TO_MANY)) continue;
                relationHolder = new RelationHolder(linkName, linkValue);
                relationsHolder.add(relationHolder);
            }
        }
        if (children != null && !children.isEmpty()) {
            for (NodeLink childNodeLink : children.keySet()) {
                linkName = (String)childNodeLink.getLinkProperty(NodeLink.LinkProperty.LINK_NAME);
                linkValue = childNodeLink.getLinkProperty(NodeLink.LinkProperty.LINK_VALUE) != null ? childNodeLink.getLinkProperty(NodeLink.LinkProperty.LINK_VALUE) : children.get(childNodeLink).getEntityId();
                isSharedByPrimaryKey = (Boolean)childNodeLink.getLinkProperty(NodeLink.LinkProperty.IS_SHARED_BY_PRIMARY_KEY);
                multiplicity = childNodeLink.getMultiplicity();
                if (linkName == null || linkValue == null || isSharedByPrimaryKey) continue;
                if (multiplicity.equals((Object)Relation.ForeignKey.ONE_TO_ONE) || multiplicity.equals((Object)Relation.ForeignKey.MANY_TO_ONE)) {
                    relationHolder = new RelationHolder(linkName, linkValue);
                    relationsHolder.add(relationHolder);
                    continue;
                }
                if (!multiplicity.equals((Object)Relation.ForeignKey.MANY_TO_MANY) || !((Field)childNodeLink.getLinkProperty(NodeLink.LinkProperty.PROPERTY)).getType().isAssignableFrom(Map.class)) continue;
                Object relationTo = children.get(childNodeLink).getData();
                RelationHolder relationHolder2 = new RelationHolder(linkName, relationTo, linkValue);
                relationsHolder.add(relationHolder2);
            }
        }
        return relationsHolder;
    }

    protected void indexNode(Node node, EntityMetadata entityMetadata) {
        if (this.indexManager != null && !MetadataUtils.useSecondryIndex(this.getClientMetadata())) {
            Map<NodeLink, Node> parents = node.getParents();
            if (parents != null) {
                for (NodeLink parentNodeLink : parents.keySet()) {
                    this.indexManager.update(entityMetadata, node.getData(), parentNodeLink.getLinkProperty(NodeLink.LinkProperty.LINK_VALUE), parents.get(parentNodeLink).getDataClass());
                }
            } else if (node.getChildren() != null) {
                Map<NodeLink, Node> children = node.getChildren();
                for (NodeLink childNodeLink : children.keySet()) {
                    if (childNodeLink.getMultiplicity().equals((Object)Relation.ForeignKey.MANY_TO_ONE)) {
                        this.indexManager.update(entityMetadata, node.getData(), children.get(childNodeLink).getEntityId(), children.get(childNodeLink).getDataClass());
                        continue;
                    }
                    this.indexManager.update(entityMetadata, node.getData(), node.getEntityId(), node.getDataClass());
                }
            } else {
                this.indexManager.update(entityMetadata, node.getData(), node.getEntityId(), node.getDataClass());
            }
        }
    }

    protected abstract void onPersist(EntityMetadata var1, Object var2, Object var3, List<RelationHolder> var4);

    protected abstract void delete(Object var1, Object var2);

    public ClientMetadata getClientMetadata() {
        return this.clientMetadata;
    }

    public boolean useSecondryIndex() {
        return this.clientMetadata != null ? this.clientMetadata.isUseSecondryIndex() : false;
    }

    public Object executeScript(String script) {
        throw new UnsupportedOperationException("Execute script is not supported by this client");
    }
}

