/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.client;

import com.impetus.kundera.client.ClientResolverException;
import com.impetus.kundera.loader.ClientFactory;
import com.impetus.kundera.loader.GenericClientFactory;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientResolver {
    static Map<String, ClientFactory> clientFactories = new ConcurrentHashMap<String, ClientFactory>();
    private static final Logger logger = LoggerFactory.getLogger(ClientResolver.class);

    public static ClientFactory getClientFactory(String persistenceUnit, Map<String, Object> puProperties, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        ClientFactory clientFactory = ClientResolver.instantiateClientFactory(persistenceUnit, puProperties, kunderaMetadata);
        clientFactories.put(persistenceUnit, clientFactory);
        return clientFactory;
    }

    private static ClientFactory instantiateClientFactory(String persistenceUnit, Map<String, Object> puProperties, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        String kunderaClientFactory;
        ClientFactory clientFactory = null;
        logger.info("Initializing client factory for: " + persistenceUnit);
        PersistenceUnitMetadata persistenceUnitMetadata = kunderaMetadata.getApplicationMetadata().getPersistenceUnitMetadata(persistenceUnit);
        String string = kunderaClientFactory = puProperties != null ? (String)puProperties.get("kundera.client.lookup.class") : null;
        if (kunderaClientFactory == null) {
            kunderaClientFactory = persistenceUnitMetadata.getProperties().getProperty("kundera.client.lookup.class");
        }
        if (kunderaClientFactory == null) {
            throw new ClientResolverException("<kundera.client.lookup.class> is missing from persistence.xml, please provide specific client factory. e.g., <property name=\"kundera.client.lookup.class\" value=\"com.impetus.client.cassandra.pelops.PelopsClientFactory\" />");
        }
        try {
            clientFactory = (ClientFactory)Class.forName(kunderaClientFactory).newInstance();
            Method m = GenericClientFactory.class.getDeclaredMethod("setPersistenceUnit", String.class);
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            m.invoke((Object)clientFactory, persistenceUnit);
            m = GenericClientFactory.class.getDeclaredMethod("setExternalProperties", Map.class);
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            m.invoke((Object)clientFactory, puProperties);
            m = GenericClientFactory.class.getDeclaredMethod("setKunderaMetadata", EntityManagerFactoryImpl.KunderaMetadata.class);
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            m.invoke((Object)clientFactory, kunderaMetadata);
        }
        catch (InstantiationException e) {
            ClientResolver.onError(e);
        }
        catch (IllegalAccessException e) {
            ClientResolver.onError(e);
        }
        catch (ClassNotFoundException e) {
            ClientResolver.onError(e);
        }
        catch (SecurityException e) {
            ClientResolver.onError(e);
        }
        catch (NoSuchMethodException e) {
            ClientResolver.onError(e);
        }
        catch (IllegalArgumentException e) {
            ClientResolver.onError(e);
        }
        catch (InvocationTargetException e) {
            ClientResolver.onError(e);
        }
        if (clientFactory == null) {
            logger.error("Client Factory Not Configured For Specified Client Type : ");
            throw new ClientResolverException("Client Factory Not Configured For Specified Client Type.");
        }
        logger.info("Finishing factory initialization");
        return clientFactory;
    }

    public static ClientFactory getClientFactory(String pu) {
        ClientFactory clientFactory = clientFactories.get(pu);
        if (clientFactory != null) {
            return clientFactory;
        }
        logger.error("Client Factory Not Configured For Specified Client Type : ");
        throw new ClientResolverException("Client Factory Not Configured For Specified Client Type.");
    }

    private static void onError(Exception e) {
        logger.error("Error while initializing client factory, Caused by: .", (Object)e.getMessage());
        throw new ClientResolverException(e);
    }
}

