/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.configure;

import com.impetus.kundera.classreading.ClasspathReader;
import com.impetus.kundera.classreading.Reader;
import com.impetus.kundera.classreading.ResourceIterator;
import com.impetus.kundera.configure.AbstractSchemaConfiguration;
import com.impetus.kundera.configure.Configuration;
import com.impetus.kundera.loader.MetamodelLoaderException;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.MetadataBuilder;
import com.impetus.kundera.metadata.model.ApplicationMetadata;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.IdDiscriptor;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.metadata.processor.GeneratedValueProcessor;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.utils.KunderaCoreUtils;
import com.impetus.kundera.validation.ValidationFactory;
import com.impetus.kundera.validation.ValidationFactoryGenerator;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Table;
import javax.persistence.metamodel.Metamodel;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetamodelConfiguration
extends AbstractSchemaConfiguration
implements Configuration {
    private static Logger log = LoggerFactory.getLogger(MetamodelConfiguration.class);
    private ValidationFactory factory;

    public MetamodelConfiguration(Map properties, EntityManagerFactoryImpl.KunderaMetadata metadata, String ... persistenceUnits) {
        super(persistenceUnits, properties, metadata);
        ValidationFactoryGenerator generator = new ValidationFactoryGenerator();
        this.factory = generator.getFactory(ValidationFactoryGenerator.ValidationFactoryType.BOOT_STRAP_VALIDATION);
    }

    @Override
    public void configure() {
        log.debug("Loading Entity Metadata...");
        ApplicationMetadata appMetadata = this.kunderaMetadata.getApplicationMetadata();
        for (String persistenceUnit : this.persistenceUnits) {
            if (appMetadata.getMetamodelMap().get(persistenceUnit.trim()) != null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Metadata already exists for the Persistence Unit " + persistenceUnit + ". Nothing to do");
                continue;
            }
            this.loadEntityMetadata(persistenceUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEntityMetadata(String persistenceUnit) {
        ClasspathReader reader;
        if (persistenceUnit == null) {
            throw new IllegalArgumentException("Must have a persistenceUnitName in order to load entity metadata, you provided :" + persistenceUnit);
        }
        Map<String, PersistenceUnitMetadata> persistentUnitMetadataMap = this.kunderaMetadata.getApplicationMetadata().getPersistenceUnitMetadataMap();
        URL[] resources = null;
        String client = null;
        List<URL> managedURLs = null;
        if (persistentUnitMetadataMap == null || persistentUnitMetadataMap.isEmpty()) {
            log.error("It is necessary to load Persistence Unit metadata  for persistence unit " + persistenceUnit + " first before loading entity metadata.");
            throw new MetamodelLoaderException("load Persistence Unit metadata  for persistence unit " + persistenceUnit + " first before loading entity metadata.");
        }
        PersistenceUnitMetadata puMetadata = persistentUnitMetadataMap.get(persistenceUnit);
        List<String> classesToScan = puMetadata.getManagedClassNames();
        managedURLs = puMetadata.getManagedURLs();
        client = this.getClientFactoryName(persistenceUnit);
        ApplicationMetadata appMetadata = this.kunderaMetadata.getApplicationMetadata();
        if (classesToScan == null || classesToScan.isEmpty()) {
            log.info("No class to scan for persistence unit " + persistenceUnit + ". Entities will be loaded from classpath/ context-path");
            if (appMetadata.getMetamodelMap().get(persistenceUnit) != null) {
                log.info("All common entitity metadata already loaded, nothing need to be done");
                return;
            }
            reader = new ClasspathReader();
        } else {
            reader = new ClasspathReader(classesToScan);
        }
        InputStream[] iStreams = null;
        PersistenceUnitMetadata puMetadata2 = persistentUnitMetadataMap.get(persistenceUnit);
        if (this.getClass().getClassLoader() instanceof URLClassLoader && !puMetadata2.getExcludeUnlistedClasses()) {
            URL[] managedClasses = ((Reader)reader).findResources();
            if (managedClasses != null) {
                List<URL> managedResources = Arrays.asList(managedClasses);
                managedURLs.addAll(managedResources);
            }
        } else {
            iStreams = ((Reader)reader).findResourcesAsStream();
        }
        if (managedURLs != null) {
            resources = managedURLs.toArray(new URL[0]);
        }
        reader.addValidAnnotations(Entity.class.getName());
        Metamodel metamodel = appMetadata.getMetamodel(persistenceUnit);
        if (metamodel == null) {
            metamodel = new MetamodelImpl();
        }
        Map<String, EntityMetadata> entityMetadataMap = ((MetamodelImpl)metamodel).getEntityMetadataMap();
        Map<String, Class<?>> entityNameToClassMap = ((MetamodelImpl)metamodel).getEntityNameToClassMap();
        HashMap<String, List<String>> puToClazzMap = new HashMap<String, List<String>>();
        HashMap<String, IdDiscriptor> entityNameToKeyDiscriptorMap = new HashMap<String, IdDiscriptor>();
        ArrayList classes = new ArrayList();
        if (resources != null && resources.length > 0) {
            for (URL resource : resources) {
                try {
                    ResourceIterator itr = reader.getResourceIterator(resource, ((Reader)reader).getFilter());
                    InputStream is = null;
                    while ((is = itr.next()) != null) {
                        classes.addAll(this.scanClassAndPutMetadata(is, reader, entityMetadataMap, entityNameToClassMap, persistenceUnit, client, puToClazzMap, entityNameToKeyDiscriptorMap));
                    }
                }
                catch (IOException e) {
                    log.error("Error while retreiving and storing entity metadata. Details:", (Throwable)e);
                    throw new MetamodelLoaderException("Error while retreiving and storing entity metadata");
                }
            }
        } else if (iStreams != null) {
            try {
                for (InputStream is : iStreams) {
                    try {
                        classes.addAll(this.scanClassAndPutMetadata(is, reader, entityMetadataMap, entityNameToClassMap, persistenceUnit, client, puToClazzMap, entityNameToKeyDiscriptorMap));
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                log.error("Error while retreiving and storing entity metadata. Details:", (Throwable)e);
                throw new MetamodelLoaderException("Error while retreiving and storing entity metadata, Caused by : .", e);
            }
        }
        ((MetamodelImpl)metamodel).setEntityMetadataMap(entityMetadataMap);
        appMetadata.getMetamodelMap().put(persistenceUnit, metamodel);
        appMetadata.setClazzToPuMap(puToClazzMap);
        ((MetamodelImpl)metamodel).addKeyValues(entityNameToKeyDiscriptorMap);
        ((MetamodelImpl)metamodel).assignEmbeddables(this.kunderaMetadata.getApplicationMetadata().getMetaModelBuilder(persistenceUnit).getEmbeddables());
        ((MetamodelImpl)metamodel).assignManagedTypes(this.kunderaMetadata.getApplicationMetadata().getMetaModelBuilder(persistenceUnit).getManagedTypes());
        ((MetamodelImpl)metamodel).assignMappedSuperClass(this.kunderaMetadata.getApplicationMetadata().getMetaModelBuilder(persistenceUnit).getMappedSuperClassTypes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Class<?>> scanClassAndPutMetadata(InputStream bits, Reader reader, Map<String, EntityMetadata> entityMetadataMap, Map<String, Class<?>> entityNameToClassMap, String persistenceUnit, String client, Map<String, List<String>> clazzToPuMap, Map<String, IdDiscriptor> entityNameToKeyDiscriptorMap) throws IOException {
        DataInputStream dstream = new DataInputStream(new BufferedInputStream(bits));
        ClassFile cf = null;
        String className = null;
        ArrayList classes = new ArrayList();
        try {
            cf = new ClassFile(dstream);
            className = cf.getName();
            ArrayList<String> annotations = new ArrayList<String>();
            reader.accumulateAnnotations(annotations, (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations"));
            reader.accumulateAnnotations(annotations, (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations"));
            for (String validAnn : reader.getValidAnnotations()) {
                if (!annotations.contains(validAnn)) continue;
                Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                this.factory.validate(clazz);
                String entityName = this.getEntityName(clazz);
                if (entityNameToClassMap.containsKey(entityName) && !entityNameToClassMap.get(entityName).getName().equals(clazz.getName())) {
                    throw new MetamodelLoaderException("Name conflict between classes " + entityNameToClassMap.get(entityName).getName() + " and " + clazz.getName() + ". Make sure no two entity classes with the same name " + " are specified for persistence unit " + persistenceUnit);
                }
                entityNameToClassMap.put(entityName, clazz);
                EntityMetadata metadata = entityMetadataMap.get(clazz);
                if (null == metadata) {
                    log.debug("Metadata not found in cache for " + clazz.getName());
                    Class<?> clazz2 = clazz;
                    synchronized (clazz2) {
                        MetadataBuilder metadataBuilder;
                        if (null == metadata && (metadata = (metadataBuilder = new MetadataBuilder(persistenceUnit, client, KunderaCoreUtils.getExternalProperties(persistenceUnit, this.externalPropertyMap, this.persistenceUnits), this.kunderaMetadata)).buildEntityMetadata(clazz)) != null) {
                            entityMetadataMap.put(clazz.getName(), metadata);
                            this.mapClazztoPu(clazz, persistenceUnit, clazzToPuMap);
                            this.processGeneratedValueAnnotation(clazz, persistenceUnit, metadata, entityNameToKeyDiscriptorMap);
                        }
                    }
                }
                this.onValidateClientProperties(classes, clazz, persistenceUnit);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Class " + className + " not found, it won't be loaded as entity");
        }
        finally {
            if (dstream != null) {
                dstream.close();
            }
            if (bits != null) {
                bits.close();
            }
        }
        return classes;
    }

    private String getEntityName(Class<?> clazz) {
        return !StringUtils.isBlank((String)clazz.getAnnotation(Entity.class).name()) ? clazz.getAnnotation(Entity.class).name() : clazz.getSimpleName();
    }

    private List<Class<?>> onValidateClientProperties(List<Class<?>> classes, Class<?> clazz, String persistenceUnit) {
        if (clazz.isAnnotationPresent(Entity.class) && clazz.isAnnotationPresent(Table.class)) {
            classes.add(clazz);
        }
        return classes;
    }

    private Map<String, List<String>> mapClazztoPu(Class<?> clazz, String pu, Map<String, List<String>> clazzToPuMap) {
        List<String> puCol = new ArrayList<String>(1);
        if (clazzToPuMap == null) {
            clazzToPuMap = new HashMap<String, List<String>>();
        } else if (clazzToPuMap.containsKey(clazz.getName())) {
            puCol = clazzToPuMap.get(clazz.getName());
        }
        if (!puCol.contains(pu)) {
            puCol.add(pu);
            clazzToPuMap.put(clazz.getName(), puCol);
            String annotateEntityName = clazz.getAnnotation(Entity.class).name();
            if (!StringUtils.isBlank((String)annotateEntityName)) {
                clazzToPuMap.put(annotateEntityName, puCol);
            }
        }
        return clazzToPuMap;
    }

    private void processGeneratedValueAnnotation(Class<?> clazz, String persistenceUnit, EntityMetadata m, Map<String, IdDiscriptor> entityNameToKeyDiscriptorMap) {
        Field f;
        GeneratedValueProcessor processer = new GeneratedValueProcessor();
        String pu = m.getPersistenceUnit();
        String clientFactoryName = this.getClientFactoryName(persistenceUnit);
        if ((pu != null && pu.equals(persistenceUnit) || clientFactoryName.equalsIgnoreCase("com.impetus.client.rdbms.RDBMSClientFactory")) && (f = (Field)m.getIdAttribute().getJavaMember()).isAnnotationPresent(GeneratedValue.class)) {
            processer.process(clazz, f, m, entityNameToKeyDiscriptorMap);
        }
    }

    private String getClientFactoryName(String persistenceUnit) {
        String clientFactoryName;
        Map<String, Object> externalProperties = KunderaCoreUtils.getExternalProperties(persistenceUnit, this.externalPropertyMap, this.persistenceUnits);
        String string = clientFactoryName = externalProperties != null ? (String)externalProperties.get("kundera.client.lookup.class") : null;
        if (clientFactoryName == null) {
            clientFactoryName = KunderaMetadataManager.getPersistenceUnitMetadata(this.kunderaMetadata, persistenceUnit).getClient();
        }
        return clientFactoryName;
    }
}

