/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.configure;

import com.impetus.kundera.client.ClientResolver;
import com.impetus.kundera.configure.AbstractSchemaConfiguration;
import com.impetus.kundera.configure.Configuration;
import com.impetus.kundera.configure.schema.CollectionColumnInfo;
import com.impetus.kundera.configure.schema.ColumnInfo;
import com.impetus.kundera.configure.schema.EmbeddedColumnInfo;
import com.impetus.kundera.configure.schema.IndexInfo;
import com.impetus.kundera.configure.schema.SchemaGenerationException;
import com.impetus.kundera.configure.schema.TableInfo;
import com.impetus.kundera.configure.schema.api.SchemaManager;
import com.impetus.kundera.loader.ClientFactory;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.ApplicationMetadata;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.IdDiscriptor;
import com.impetus.kundera.metadata.model.JoinTableMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.metadata.model.PropertyIndex;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.metadata.model.type.AbstractManagedType;
import com.impetus.kundera.metadata.processor.IndexProcessor;
import com.impetus.kundera.metadata.validator.EntityValidatorImpl;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.utils.KunderaCoreUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Lob;
import javax.persistence.OrderBy;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaConfiguration
extends AbstractSchemaConfiguration
implements Configuration {
    private static Logger log = LoggerFactory.getLogger(SchemaConfiguration.class);
    private Map<String, List<TableInfo>> puToSchemaMetadata = new HashMap<String, List<TableInfo>>();

    public SchemaConfiguration(Map externalProperties, EntityManagerFactoryImpl.KunderaMetadata metadata, String ... persistenceUnits) {
        super(persistenceUnits, externalProperties, metadata);
    }

    @Override
    public void configure() {
        ApplicationMetadata appMetadata = this.kunderaMetadata.getApplicationMetadata();
        for (String persistenceUnit : this.persistenceUnits) {
            EntityValidatorImpl validator = new EntityValidatorImpl(KunderaCoreUtils.getExternalProperties(persistenceUnit, this.externalPropertyMap, this.persistenceUnits));
            log.info("Configuring schema export for : " + persistenceUnit);
            List<TableInfo> tableInfos = this.getSchemaInfo(persistenceUnit);
            Map<String, EntityMetadata> entityMetadataMap = this.getEntityMetadataCol(appMetadata, persistenceUnit);
            PersistenceUnitMetadata puMetadata = appMetadata.getPersistenceUnitMetadata(persistenceUnit);
            for (EntityMetadata entityMetadata : entityMetadataMap.values()) {
                boolean found = false;
                EntityMetadata.Type type = entityMetadata.getType();
                Class idClassName = entityMetadata.getIdAttribute() != null ? entityMetadata.getIdAttribute().getJavaType() : null;
                String idName = entityMetadata.getIdAttribute() != null ? ((AbstractAttribute)entityMetadata.getIdAttribute()).getJPAColumnName() : null;
                TableInfo tableInfo = new TableInfo(entityMetadata.getTableName(), type.name(), idClassName, idName);
                if (!tableInfos.isEmpty() && tableInfos.contains(tableInfo)) {
                    found = true;
                    int idx = tableInfos.indexOf(tableInfo);
                    tableInfo = tableInfos.get(idx);
                    this.addColumnToTableInfo(entityMetadata, type, tableInfo);
                } else {
                    this.addColumnToTableInfo(entityMetadata, type, tableInfo);
                }
                List<Relation> relations = entityMetadata.getRelations();
                this.parseRelations(persistenceUnit, tableInfos, entityMetadata, tableInfo, relations);
                if (!found) {
                    tableInfos.add(tableInfo);
                }
                this.addTableGenerator(appMetadata, persistenceUnit, tableInfos, entityMetadata);
                validator.validateEntity(entityMetadata.getEntityClazz(), this.kunderaMetadata);
            }
            this.puToSchemaMetadata.put(persistenceUnit, tableInfos);
        }
        for (String persistenceUnit : this.persistenceUnits) {
            SchemaManager schemaManager;
            PersistenceUnitMetadata puMetadata = appMetadata.getPersistenceUnitMetadata(persistenceUnit);
            Map externalPuMap = this.externalPropertyMap;
            if (this.persistenceUnits.length > 1 && this.externalPropertyMap != null) {
                externalPuMap = (Map)this.externalPropertyMap.get(persistenceUnit);
            }
            if ((externalPuMap == null || externalPuMap.get("kundera.ddl.auto.prepare") == null) && puMetadata.getProperty("kundera.ddl.auto.prepare") == null || (schemaManager = this.getSchemaManagerForPu(persistenceUnit)) == null) continue;
            schemaManager.exportSchema(persistenceUnit, this.puToSchemaMetadata.get(persistenceUnit));
        }
    }

    private SchemaManager getSchemaManagerForPu(String persistenceUnit) {
        SchemaManager schemaManager = null;
        Map<String, Object> externalProperties = KunderaCoreUtils.getExternalProperties(persistenceUnit, this.externalPropertyMap, this.persistenceUnits);
        if (this.getSchemaProperty(persistenceUnit, externalProperties) != null && !this.getSchemaProperty(persistenceUnit, externalProperties).isEmpty()) {
            ClientFactory clientFactory = ClientResolver.getClientFactory(persistenceUnit);
            schemaManager = clientFactory != null ? clientFactory.getSchemaManager(externalProperties) : null;
        }
        return schemaManager;
    }

    private void addTableGenerator(ApplicationMetadata appMetadata, String persistenceUnit, List<TableInfo> tableInfos, EntityMetadata entityMetadata) {
        TableInfo tableGeneratorDiscriptor;
        Metamodel metamodel = appMetadata.getMetamodel(persistenceUnit);
        IdDiscriptor keyValue = ((MetamodelImpl)metamodel).getKeyValue(entityMetadata.getEntityClazz().getName());
        if (keyValue != null && keyValue.getTableDiscriptor() != null && !tableInfos.contains(tableGeneratorDiscriptor = new TableInfo(keyValue.getTableDiscriptor().getTable(), "CounterColumnType", String.class, keyValue.getTableDiscriptor().getPkColumnName()))) {
            tableGeneratorDiscriptor.addColumnInfo(this.getJoinColumn(tableGeneratorDiscriptor, keyValue.getTableDiscriptor().getValueColumnName(), Long.class));
            tableInfos.add(tableGeneratorDiscriptor);
        }
    }

    private void parseRelations(String persistenceUnit, List<TableInfo> tableInfos, EntityMetadata entityMetadata, TableInfo tableInfo, List<Relation> relations) {
        for (Relation relation : relations) {
            String inverseJoinColumnName;
            if (relation == null) continue;
            Class<?> entityClass = relation.getTargetEntity();
            EntityMetadata targetEntityMetadata = KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, entityClass);
            if (targetEntityMetadata == null) {
                log.error("Persistence unit for class : " + entityClass + " is not loaded");
                throw new SchemaGenerationException("Persistence unit for class : " + entityClass + " is not loaded");
            }
            Relation.ForeignKey relationType = relation.getType();
            if (targetEntityMetadata != null && relationType.equals((Object)Relation.ForeignKey.ONE_TO_MANY) && relation.getJoinColumnName(this.kunderaMetadata) != null) {
                if (targetEntityMetadata.equals(entityMetadata)) {
                    tableInfo.addColumnInfo(this.getJoinColumn(tableInfo, relation.getJoinColumnName(this.kunderaMetadata), entityMetadata.getIdAttribute().getJavaType()));
                    continue;
                }
                String pu = targetEntityMetadata.getPersistenceUnit();
                EntityMetadata.Type targetEntityType = targetEntityMetadata.getType();
                Class idClass = targetEntityMetadata.getIdAttribute().getJavaType();
                String idName = ((AbstractAttribute)targetEntityMetadata.getIdAttribute()).getJPAColumnName();
                TableInfo targetTableInfo = new TableInfo(targetEntityMetadata.getTableName(), targetEntityType.name(), idClass, idName);
                if (!pu.equals(persistenceUnit)) {
                    List<TableInfo> targetTableInfos = this.getSchemaInfo(pu);
                    this.addJoinColumnToInfo(relation.getJoinColumnName(this.kunderaMetadata), targetTableInfo, targetTableInfos, entityMetadata);
                    this.puToSchemaMetadata.put(pu, targetTableInfos);
                    continue;
                }
                this.addJoinColumnToInfo(relation.getJoinColumnName(this.kunderaMetadata), targetTableInfo, tableInfos, entityMetadata);
                continue;
            }
            if (relation.isUnary() && relation.getJoinColumnName(this.kunderaMetadata) != null) {
                if (relation.isJoinedByPrimaryKey()) continue;
                tableInfo.addColumnInfo(this.getJoinColumn(tableInfo, relation.getJoinColumnName(this.kunderaMetadata), targetEntityMetadata.getIdAttribute().getJavaType()));
                continue;
            }
            if (!relationType.equals((Object)Relation.ForeignKey.MANY_TO_MANY) || !entityMetadata.isRelationViaJoinTable()) continue;
            JoinTableMetadata joinTableMetadata = relation.getJoinTableMetadata();
            String joinTableName = joinTableMetadata != null ? joinTableMetadata.getJoinTableName() : null;
            String joinColumnName = joinTableMetadata != null ? (String)joinTableMetadata.getJoinColumns().toArray()[0] : null;
            String string = inverseJoinColumnName = joinTableMetadata != null ? (String)joinTableMetadata.getInverseJoinColumns().toArray()[0] : null;
            if (joinTableName == null) continue;
            TableInfo joinTableInfo = new TableInfo(joinTableName, EntityMetadata.Type.COLUMN_FAMILY.name(), String.class, "key");
            if ((tableInfos.isEmpty() || tableInfos.contains(joinTableInfo)) && !tableInfos.isEmpty()) continue;
            joinTableInfo.addColumnInfo(this.getJoinColumn(joinTableInfo, joinColumnName, entityMetadata.getIdAttribute().getJavaType()));
            joinTableInfo.addColumnInfo(this.getJoinColumn(joinTableInfo, inverseJoinColumnName, targetEntityMetadata.getIdAttribute().getJavaType()));
            tableInfos.add(joinTableInfo);
        }
    }

    private void addJoinColumnToInfo(String joinColumn, TableInfo targetTableInfo, List<TableInfo> targetTableInfos, EntityMetadata m) {
        if (!joinColumn.equals(targetTableInfo.getIdColumnName())) {
            if (!targetTableInfos.isEmpty() && targetTableInfos.contains(targetTableInfo)) {
                int idx = targetTableInfos.indexOf(targetTableInfo);
                targetTableInfo = targetTableInfos.get(idx);
                ColumnInfo columnInfoOfJoinColumn = this.getJoinColumn(targetTableInfo, joinColumn, m.getIdAttribute().getBindableJavaType());
                if (!targetTableInfo.getColumnMetadatas().contains(columnInfoOfJoinColumn)) {
                    targetTableInfo.addColumnInfo(columnInfoOfJoinColumn);
                }
            } else {
                ColumnInfo columnInfoOfJoinColumn = this.getJoinColumn(targetTableInfo, joinColumn, m.getIdAttribute().getBindableJavaType());
                if (!targetTableInfo.getColumnMetadatas().contains(columnInfoOfJoinColumn)) {
                    targetTableInfo.addColumnInfo(columnInfoOfJoinColumn);
                }
                targetTableInfos.add(targetTableInfo);
            }
        }
    }

    private void addColumnToTableInfo(EntityMetadata entityMetadata, EntityMetadata.Type type, TableInfo tableInfo) {
        Metamodel metaModel = this.kunderaMetadata.getApplicationMetadata().getMetamodel(entityMetadata.getPersistenceUnit());
        EntityType entityType = metaModel.entity(entityMetadata.getEntityClazz());
        Map<String, PropertyIndex> columns = entityMetadata.getIndexProperties();
        for (Map.Entry<String, PropertyIndex> c : columns.entrySet()) {
            PropertyIndex indexedColumn = c.getValue();
            if (indexedColumn.getIndexType() == null || !indexedColumn.getIndexType().toLowerCase().equals("composite")) continue;
            IndexInfo indexInfo = new IndexInfo(c.getKey(), indexedColumn.getMax(), indexedColumn.getMin(), indexedColumn.getIndexType(), indexedColumn.getName());
            tableInfo.addToIndexedColumnList(indexInfo);
        }
        Set attributes = entityType.getAttributes();
        for (Attribute attr : attributes) {
            IndexInfo indexInfo;
            PropertyIndex indexedColumn;
            String jpaName;
            if (attr.isAssociation()) continue;
            if (((MetamodelImpl)metaModel).isEmbeddable(attr.getJavaType())) {
                EmbeddableType embeddable = metaModel.embeddable(attr.getJavaType());
                EmbeddedColumnInfo embeddedColumnInfo = this.getEmbeddedColumn(tableInfo, embeddable, attr.getName(), attr.getJavaType(), (Field)attr.getJavaMember());
                if (tableInfo.getEmbeddedColumnMetadatas().contains(embeddedColumnInfo)) continue;
                tableInfo.addEmbeddedColumnInfo(embeddedColumnInfo);
                continue;
            }
            if (!attr.isCollection() && !((SingularAttribute)attr).isId()) {
                if (((Field)attr.getJavaMember()).getAnnotation(Lob.class) != null) {
                    tableInfo.addLobColumnInfo(((AbstractAttribute)attr).getJPAColumnName());
                }
                ColumnInfo columnInfo = this.getColumn(tableInfo, attr, columns != null ? columns.get(((AbstractAttribute)attr).getJPAColumnName()) : null, null);
                if (tableInfo.getColumnMetadatas().contains(columnInfo)) continue;
                tableInfo.addColumnInfo(columnInfo);
                continue;
            }
            if (attr.isCollection() && MetadataUtils.isBasicElementCollectionField((Field)attr.getJavaMember())) {
                CollectionColumnInfo cci = new CollectionColumnInfo();
                cci.setCollectionColumnName(((AbstractAttribute)attr).getJPAColumnName());
                cci.setType(attr.getJavaType());
                cci.setGenericClasses(PropertyAccessorHelper.getGenericClasses((Field)attr.getJavaMember()));
                tableInfo.addCollectionColumnMetadata(cci);
                jpaName = ((AbstractAttribute)attr).getJPAColumnName();
                indexedColumn = columns.get(jpaName);
                if (indexedColumn == null || indexedColumn.getName() == null) continue;
                indexInfo = new IndexInfo(jpaName, indexedColumn.getMax(), indexedColumn.getMin(), indexedColumn.getIndexType(), indexedColumn.getName());
                tableInfo.addToIndexedColumnList(indexInfo);
                continue;
            }
            if (!attr.isCollection() || MetadataUtils.isBasicElementCollectionField((Field)attr.getJavaMember())) continue;
            CollectionColumnInfo eci = new CollectionColumnInfo();
            eci.setCollectionColumnName(((AbstractAttribute)attr).getJPAColumnName());
            eci.setType(attr.getJavaType());
            eci.setGenericClasses(PropertyAccessorHelper.getGenericClasses((Field)attr.getJavaMember()));
            tableInfo.addElementCollectionMetadata(eci);
            jpaName = ((AbstractAttribute)attr).getJPAColumnName();
            indexedColumn = columns.get(jpaName);
            if (indexedColumn == null || indexedColumn.getName() == null) continue;
            indexInfo = new IndexInfo(jpaName, indexedColumn.getMax(), indexedColumn.getMin(), indexedColumn.getIndexType(), indexedColumn.getName());
            tableInfo.addToIndexedColumnList(indexInfo);
        }
        this.onInheritedProperty(tableInfo, entityType);
    }

    private void onInheritedProperty(TableInfo tableInfo, EntityType entityType) {
        String discrColumn = ((AbstractManagedType)entityType).getDiscriminatorColumn();
        if (discrColumn != null) {
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.setColumnName(discrColumn);
            columnInfo.setType(String.class);
            columnInfo.setIndexable(true);
            IndexInfo idxInfo = new IndexInfo(discrColumn);
            tableInfo.addColumnInfo(columnInfo);
            tableInfo.addToIndexedColumnList(idxInfo);
        }
    }

    private List<TableInfo> getSchemaInfo(String persistenceUnit) {
        List<TableInfo> tableInfos = this.puToSchemaMetadata.get(persistenceUnit);
        if (tableInfos == null) {
            tableInfos = new ArrayList<TableInfo>();
        }
        return tableInfos;
    }

    private Map<String, EntityMetadata> getEntityMetadataCol(ApplicationMetadata appMetadata, String persistenceUnit) {
        Metamodel metaModel = appMetadata.getMetamodel(persistenceUnit);
        Map<String, EntityMetadata> entityMetadataMap = ((MetamodelImpl)metaModel).getEntityMetadataMap();
        return entityMetadataMap;
    }

    private EmbeddedColumnInfo getEmbeddedColumn(TableInfo tableInfo, EmbeddableType embeddableType, String embeddableColName, Class embeddedEntityClass, Field field) {
        String[] orderByColumns = null;
        if (field.isAnnotationPresent(OrderBy.class)) {
            OrderBy order = field.getAnnotation(OrderBy.class);
            orderByColumns = order.value().split("\\s*,\\s*");
        }
        EmbeddedColumnInfo embeddedColumnInfo = new EmbeddedColumnInfo(embeddableType);
        embeddedColumnInfo.setEmbeddedColumnName(embeddableColName);
        Map<String, PropertyIndex> indexedColumns = IndexProcessor.getIndexesOnEmbeddable(embeddedEntityClass);
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        Set attributes = embeddableType.getAttributes();
        for (Attribute attr : attributes) {
            columns.add(this.getColumn(tableInfo, attr, indexedColumns.get(attr.getName()), orderByColumns));
        }
        embeddedColumnInfo.setColumns(columns);
        return embeddedColumnInfo;
    }

    private ColumnInfo getColumn(TableInfo tableInfo, Attribute column, PropertyIndex indexedColumn, String[] orderByColumns) {
        ColumnInfo columnInfo = new ColumnInfo();
        if (column.getJavaType().isAnnotationPresent(OrderBy.class)) {
            OrderBy order = column.getJavaType().getAnnotation(OrderBy.class);
            orderByColumns = order.value().split("\\s*,\\s*");
        }
        columnInfo.setOrderBy(this.getOrderByColumn(orderByColumns, column));
        if (column.getJavaType().isEnum()) {
            columnInfo.setType(String.class);
        } else {
            columnInfo.setType(column.getJavaType());
        }
        columnInfo.setColumnName(((AbstractAttribute)column).getJPAColumnName());
        if (indexedColumn != null && indexedColumn.getName() != null) {
            columnInfo.setIndexable(true);
            IndexInfo indexInfo = new IndexInfo(((AbstractAttribute)column).getJPAColumnName(), indexedColumn.getMax(), indexedColumn.getMin(), indexedColumn.getIndexType(), indexedColumn.getName());
            tableInfo.addToIndexedColumnList(indexInfo);
        }
        return columnInfo;
    }

    private String getOrderByColumn(String[] orderByColumns, Attribute column) {
        if (orderByColumns != null) {
            for (String orderColumn : orderByColumns) {
                String[] orderValue = orderColumn.split("\\s");
                String orderColumnName = orderValue[0].substring(orderValue[0].lastIndexOf(46) + 1);
                String orderColumnValue = orderValue[1];
                if (!orderColumnName.equals(((AbstractAttribute)column).getName()) && !orderColumnName.equals(((AbstractAttribute)column).getJPAColumnName())) continue;
                return orderColumnValue;
            }
        }
        return null;
    }

    private ColumnInfo getJoinColumn(TableInfo tableInfo, String joinColumnName, Class columnType) {
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setColumnName(joinColumnName);
        columnInfo.setIndexable(true);
        IndexInfo indexInfo = new IndexInfo(joinColumnName);
        tableInfo.addToIndexedColumnList(indexInfo);
        columnInfo.setType(columnType);
        return columnInfo;
    }

    private String getSchemaProperty(String persistenceUnit, Map<String, Object> externalProperties) {
        String autoDdlOption;
        PersistenceUnitMetadata persistenceUnitMetadata = this.kunderaMetadata.getApplicationMetadata().getPersistenceUnitMetadata(persistenceUnit);
        String string = autoDdlOption = externalProperties != null ? (String)externalProperties.get("kundera.ddl.auto.prepare") : null;
        if (autoDdlOption == null) {
            autoDdlOption = persistenceUnitMetadata != null ? persistenceUnitMetadata.getProperty("kundera.ddl.auto.prepare") : null;
        }
        return autoDdlOption;
    }
}

