/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.configure.schema.api;

import com.impetus.kundera.configure.ClientProperties;
import com.impetus.kundera.configure.schema.TableInfo;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.utils.KunderaCoreUtils;
import java.util.List;
import java.util.Map;

public abstract class AbstractSchemaManager {
    protected PersistenceUnitMetadata puMetadata;
    protected String port;
    protected String[] hosts;
    protected String clientFactory;
    protected String databaseName;
    protected List<TableInfo> tableInfos;
    protected String operation;
    protected boolean showQuery;
    protected List<ClientProperties.DataStore.Schema> schemas = null;
    protected ClientProperties.DataStore.Connection conn = null;
    protected ClientProperties.DataStore dataStore = null;
    protected Map<String, Object> externalProperties;
    protected String userName = null;
    protected String password = null;
    protected final EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata;

    protected AbstractSchemaManager(String clientFactory, Map<String, Object> externalProperties, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        this.clientFactory = clientFactory;
        this.externalProperties = externalProperties;
        this.kunderaMetadata = kunderaMetadata;
    }

    protected void exportSchema(String persistenceUnit, List<TableInfo> tables) {
        String paramString;
        this.puMetadata = this.kunderaMetadata.getApplicationMetadata().getPersistenceUnitMetadata(persistenceUnit);
        String string = paramString = this.externalProperties != null ? (String)this.externalProperties.get("kundera.client.lookup.class") : null;
        if (this.clientFactory != null && (this.clientFactory.equalsIgnoreCase(this.puMetadata.getProperties().getProperty("kundera.client.lookup.class")) || paramString != null && this.clientFactory.equalsIgnoreCase(paramString))) {
            this.readConfigProperties(this.puMetadata);
            if (this.operation != null && this.initiateClient()) {
                this.tableInfos = tables;
                this.handleOperations(tables);
            }
        }
    }

    private void readConfigProperties(PersistenceUnitMetadata puMetadata) {
        String hostName = null;
        String portName = null;
        String operationType = null;
        String schemaName = null;
        if (this.externalProperties != null) {
            portName = (String)this.externalProperties.get("kundera.port");
            hostName = (String)this.externalProperties.get("kundera.nodes");
            this.userName = (String)this.externalProperties.get("kundera.username");
            this.password = (String)this.externalProperties.get("kundera.password");
            schemaName = (String)this.externalProperties.get("kundera.keyspace");
            operationType = (String)this.externalProperties.get("kundera.ddl.auto.prepare");
            this.showQuery = KunderaCoreUtils.isShowQueryEnabled(this.externalProperties, puMetadata.getPersistenceUnitName(), this.kunderaMetadata);
        }
        if (portName == null) {
            portName = puMetadata.getProperties().getProperty("kundera.port");
        }
        if (hostName == null) {
            hostName = puMetadata.getProperties().getProperty("kundera.nodes");
        }
        if (schemaName == null) {
            schemaName = puMetadata.getProperties().getProperty("kundera.keyspace");
        }
        if (operationType == null) {
            operationType = puMetadata.getProperty("kundera.ddl.auto.prepare");
        }
        if (this.userName == null) {
            this.userName = puMetadata.getProperty("kundera.username");
            this.password = puMetadata.getProperty("kundera.password");
        }
        String[] hostArray = hostName.split(",");
        this.hosts = new String[hostArray.length];
        for (int i = 0; i < hostArray.length; ++i) {
            this.hosts[i] = hostArray[i].trim();
        }
        this.port = portName;
        this.databaseName = schemaName;
        this.operation = operationType;
    }

    protected abstract boolean initiateClient();

    protected abstract void validate(List<TableInfo> var1);

    protected abstract void update(List<TableInfo> var1);

    protected abstract void create(List<TableInfo> var1);

    protected abstract void create_drop(List<TableInfo> var1);

    private void handleOperations(List<TableInfo> tableInfos) {
        SchemaOperationType operationType = SchemaOperationType.getInstance(this.operation);
        switch (operationType) {
            case createdrop: {
                this.create_drop(tableInfos);
                break;
            }
            case create: {
                this.create(tableInfos);
                break;
            }
            case update: {
                this.update(tableInfos);
                break;
            }
            case validate: {
                this.validate(tableInfos);
            }
        }
    }

    public static enum SchemaOperationType {
        createdrop,
        create,
        validate,
        update;


        public static SchemaOperationType getInstance(String operation) {
            if (operation.equalsIgnoreCase("create-drop")) {
                return createdrop;
            }
            return SchemaOperationType.valueOf(SchemaOperationType.class, operation);
        }
    }
}

