/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.graph;

import com.impetus.kundera.graph.GraphGenerator;
import com.impetus.kundera.graph.Node;
import com.impetus.kundera.graph.NodeLink;
import com.impetus.kundera.graph.ObjectGraph;
import com.impetus.kundera.graph.ObjectGraphUtils;
import com.impetus.kundera.lifecycle.states.ManagedState;
import com.impetus.kundera.lifecycle.states.NodeState;
import com.impetus.kundera.lifecycle.states.TransientState;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.persistence.context.PersistenceCache;
import com.impetus.kundera.proxy.ProxyHelper;
import com.impetus.kundera.utils.DeepEquals;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import javax.persistence.EmbeddedId;
import javax.persistence.MapKeyJoinColumn;
import org.apache.commons.lang.StringUtils;

public class GraphBuilder {
    private ObjectGraph graph = new ObjectGraph();
    private GraphGenerator generator;

    public void assign(GraphGenerator generator) {
        this.generator = generator;
    }

    public final Node buildNode(Object entity, PersistenceDelegator pd, Object entityId, NodeState nodeState) {
        String nodeId = ObjectGraphUtils.getNodeId(entityId, entity.getClass());
        Node node = this.graph.getNode(nodeId);
        if (node != null) {
            if (this.generator.traversedNodes.contains(node)) {
                return node;
            }
            return null;
        }
        node = new NodeBuilder().assignState(nodeState).buildNode(entity, pd, entityId, nodeId).node;
        this.graph.addNode(node.getNodeId(), node);
        return node;
    }

    public GraphBuilder assignHeadNode(Node headNode) {
        this.graph.setHeadNode(headNode);
        return this;
    }

    RelationBuilder getRelationBuilder(Object target, Relation relation, Node source) {
        RelationBuilder relationBuilder = new RelationBuilder(target, relation, source);
        relationBuilder.assignGraphGenerator(this.generator);
        return relationBuilder;
    }

    ObjectGraph getGraph() {
        return this.graph;
    }

    private class NodeBuilder {
        private Node node;
        private NodeState state;

        private NodeBuilder() {
        }

        private NodeBuilder assignState(NodeState state) {
            this.state = state;
            return this;
        }

        private NodeBuilder buildNode(Object entity, PersistenceDelegator pd, Object entityId, String nodeId) {
            Node nodeInPersistenceCache = pd.getPersistenceCache().getMainCache().getNodeFromCache(nodeId, pd);
            EntityMetadata entityMetadata = KunderaMetadataManager.getEntityMetadata(pd.getKunderaMetadata(), entity.getClass());
            if (nodeInPersistenceCache == null) {
                this.state = this.state != null ? this.state : new TransientState();
                this.node = new Node(nodeId, entity, ((Field)entityMetadata.getIdAttribute().getJavaMember()).isAnnotationPresent(EmbeddedId.class) ? new ManagedState() : this.state, pd.getPersistenceCache(), entityId, pd);
            } else {
                this.node = nodeInPersistenceCache;
                this.node.setPersistenceCache(pd.getPersistenceCache());
                this.node.setTraversed(false);
            }
            this.onDirtyCheck(entity, this.node);
            this.node.setData(entity);
            return this;
        }

        private void onDirtyCheck(Object entity, Node node) {
            if (!node.isInState(TransientState.class)) {
                if (!DeepEquals.deepEquals(node.getData(), entity)) {
                    node.setDirty(true);
                } else if (node.isProcessed()) {
                    node.setDirty(false);
                }
            }
        }
    }

    class RelationBuilder {
        private GraphGenerator generator;
        private Object target;
        private Node source;
        private EntityMetadata metadata;
        private PersistenceDelegator pd;
        private PersistenceCache pc;
        private Relation relation;

        private RelationBuilder(Object target, Relation relation, Node source) {
            this.target = target;
            this.relation = relation;
            this.source = source;
        }

        private RelationBuilder assignGraphGenerator(GraphGenerator generator) {
            this.generator = generator;
            return this;
        }

        RelationBuilder assignResources(PersistenceDelegator pd, PersistenceCache pc, EntityMetadata metadata) {
            this.pc = pc;
            this.pd = pd;
            this.metadata = metadata;
            return this;
        }

        RelationBuilder build() {
            if (!this.onNonUnaryRelation()) {
                this.generator.onBuildChildNode(this.target, this.metadata, this.pd, this.pc, this.source, this.relation);
            }
            return this;
        }

        private boolean onNonUnaryRelation() {
            if (!this.relation.isUnary()) {
                Map childrenObjects;
                if (Collection.class.isAssignableFrom(this.target.getClass())) {
                    Collection childrenObjects2 = (Collection)this.target;
                    for (Object childObj : childrenObjects2) {
                        if (childObj == null) continue;
                        this.generator.onBuildChildNode(childObj, this.metadata, this.pd, this.pc, this.source, this.relation);
                    }
                } else if (Map.class.isAssignableFrom(this.target.getClass()) && (childrenObjects = (Map)this.target) != null && !ProxyHelper.isProxyCollection(childrenObjects)) {
                    for (Map.Entry entry : childrenObjects.entrySet()) {
                        Node childNode;
                        Object relObject = entry.getKey();
                        Object entityObject = entry.getValue();
                        if (entityObject == null || (childNode = this.generator.generate(entityObject, this.pd, this.pc, null)) == null || !StringUtils.isEmpty((String)this.relation.getMappedBy()) || this.relation.getProperty().getAnnotation(MapKeyJoinColumn.class) == null) continue;
                        NodeLink nodeLink = new NodeLink(this.source.getNodeId(), childNode.getNodeId());
                        this.generator.setLink(this.source, this.relation, childNode, nodeLink);
                        nodeLink.addLinkProperty(NodeLink.LinkProperty.LINK_VALUE, relObject);
                    }
                }
                return true;
            }
            return false;
        }

        Node getNode() {
            return this.source;
        }
    }
}

