/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.graph;

import com.impetus.kundera.graph.GraphBuilder;
import com.impetus.kundera.graph.Node;
import com.impetus.kundera.graph.NodeLink;
import com.impetus.kundera.graph.ObjectGraph;
import com.impetus.kundera.graph.ObjectGraphUtils;
import com.impetus.kundera.lifecycle.states.NodeState;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.IdGenerator;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.persistence.PersistenceValidator;
import com.impetus.kundera.persistence.context.PersistenceCache;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.proxy.ProxyHelper;
import com.impetus.kundera.validation.rules.NullOrInvalidEntityRule;
import com.impetus.kundera.validation.rules.PrimaryKeyNullCheck;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class GraphGenerator {
    private GraphBuilder builder = new GraphBuilder();
    Set<Node> traversedNodes = new HashSet<Node>();
    private PersistenceValidator validator = new PersistenceValidator();

    public <E> ObjectGraph generateGraph(E entity, PersistenceDelegator delegator) {
        this.builder.assign(this);
        Node node = this.generate(entity, delegator, delegator.getPersistenceCache(), null);
        this.builder.assignHeadNode(node);
        return this.builder.getGraph();
    }

    public <E> ObjectGraph generateGraph(E entity, PersistenceDelegator delegator, NodeState state) {
        this.builder.assign(this);
        Node node = this.generate(entity, delegator, delegator.getPersistenceCache(), state);
        this.builder.assignHeadNode(node);
        return this.builder.getGraph();
    }

    <E> Node generate(E entity, PersistenceDelegator delegator, PersistenceCache pc, NodeState state) {
        EntityMetadata entityMetadata = KunderaMetadataManager.getEntityMetadata(delegator.getKunderaMetadata(), entity.getClass());
        if (!new NullOrInvalidEntityRule<E>(entityMetadata).validate(entity)) {
            Object entityId = this.onPreChecks(entity, delegator);
            Node node = this.builder.buildNode(entity, delegator, entityId, state);
            node = this.traverseNode(entity, delegator, pc, entityId, node);
            return node;
        }
        return null;
    }

    private <E> Node traverseNode(E entity, PersistenceDelegator delegator, PersistenceCache pc, Object entityId, Node node) {
        if (node != null && !this.traversedNodes.contains(node)) {
            EntityMetadata entityMetadata = KunderaMetadataManager.getEntityMetadata(delegator.getKunderaMetadata(), entity.getClass());
            for (Relation relation : entityMetadata.getRelations()) {
                Object childObject;
                if (relation == null || (childObject = PropertyAccessorHelper.getObject(entity, relation.getProperty())) == null || ProxyHelper.isProxyOrCollection(childObject)) continue;
                EntityMetadata childMetadata = KunderaMetadataManager.getEntityMetadata(delegator.getKunderaMetadata(), PropertyAccessorHelper.getGenericClass(relation.getProperty()));
                childObject = this.onIfSharedByPK(relation, childObject, childMetadata, entityId);
                node = this.builder.getRelationBuilder(childObject, relation, node).assignResources(delegator, pc, childMetadata).build().getNode();
            }
            this.traversedNodes.add(node);
        }
        return node;
    }

    private Object onIfSharedByPK(Relation relation, Object childObject, EntityMetadata childMetadata, Object entityId) {
        if (relation.isJoinedByPrimaryKey()) {
            PropertyAccessorHelper.setId(childObject, childMetadata, entityId);
        }
        return childObject;
    }

    private <E> Object onPreChecks(E entity, PersistenceDelegator delegator) {
        Object id = null;
        EntityMetadata entityMetadata = KunderaMetadataManager.getEntityMetadata(delegator.getKunderaMetadata(), entity.getClass());
        id = PropertyAccessorHelper.getId(entity, entityMetadata);
        if (ObjectGraphUtils.onAutoGenerateId((Field)entityMetadata.getIdAttribute().getJavaMember(), id)) {
            id = new IdGenerator().generateAndSetId(entity, entityMetadata, delegator, delegator.getKunderaMetadata());
        }
        new PrimaryKeyNullCheck<Object>().validate(id);
        this.validator.validate(entity, delegator.getKunderaMetadata());
        return id;
    }

    void onBuildChildNode(Object childObject, EntityMetadata childMetadata, PersistenceDelegator delegator, PersistenceCache pc, Node node, Relation relation) {
        Node childNode = this.generate(childObject, delegator, pc, null);
        if (childNode != null) {
            this.assignNodeLinkProperty(node, relation, childNode);
        }
    }

    private void assignNodeLinkProperty(Node node, Relation relation, Node childNode) {
        NodeLink nodeLink = new NodeLink(node.getNodeId(), childNode.getNodeId());
        this.setLink(node, relation, childNode, nodeLink);
    }

    void setLink(Node node, Relation relation, Node childNode, NodeLink nodeLink) {
        nodeLink.setMultiplicity(relation.getType());
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(node.getPersistenceDelegator().getKunderaMetadata(), node.getDataClass());
        nodeLink.setLinkProperties(this.getLinkProperties(metadata, relation, node.getPersistenceDelegator().getKunderaMetadata()));
        childNode.addParentNode(nodeLink, node);
        node.addChildNode(nodeLink, childNode);
    }

    private Map<NodeLink.LinkProperty, Object> getLinkProperties(EntityMetadata metadata, Relation relation, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        HashMap<NodeLink.LinkProperty, Object> linkProperties = new HashMap<NodeLink.LinkProperty, Object>();
        linkProperties.put(NodeLink.LinkProperty.LINK_NAME, MetadataUtils.getMappedName(metadata, relation, kunderaMetadata));
        linkProperties.put(NodeLink.LinkProperty.IS_SHARED_BY_PRIMARY_KEY, relation.isJoinedByPrimaryKey());
        linkProperties.put(NodeLink.LinkProperty.IS_BIDIRECTIONAL, !relation.isUnary());
        linkProperties.put(NodeLink.LinkProperty.IS_RELATED_VIA_JOIN_TABLE, relation.isRelatedViaJoinTable());
        linkProperties.put(NodeLink.LinkProperty.PROPERTY, relation.getProperty());
        linkProperties.put(NodeLink.LinkProperty.CASCADE, relation.getCascades());
        if (relation.isRelatedViaJoinTable()) {
            linkProperties.put(NodeLink.LinkProperty.JOIN_TABLE_METADATA, relation.getJoinTableMetadata());
        }
        return linkProperties;
    }
}

