/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.graph;

import com.impetus.kundera.metadata.model.Relation;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;

public class NodeLink {
    private String sourceNodeId;
    private String targetNodeId;
    private Relation.ForeignKey multiplicity;
    private Map<LinkProperty, Object> linkProperties;

    public NodeLink() {
    }

    public NodeLink(String sourceNodeId, String targetNodeId) {
        this.sourceNodeId = sourceNodeId;
        this.targetNodeId = targetNodeId;
    }

    public String getSourceNodeId() {
        return this.sourceNodeId;
    }

    public void setSourceNodeId(String sourceNodeId) {
        this.sourceNodeId = sourceNodeId;
    }

    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    public void setTargetNodeId(String targetNodeId) {
        this.targetNodeId = targetNodeId;
    }

    public Relation.ForeignKey getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(Relation.ForeignKey multiplicity) {
        this.multiplicity = multiplicity;
    }

    public Map<LinkProperty, Object> getLinkProperties() {
        return this.linkProperties;
    }

    public void setLinkProperties(Map<LinkProperty, Object> linkProperties) {
        this.linkProperties = linkProperties;
    }

    public Object getLinkProperty(LinkProperty name) {
        if (this.linkProperties == null || this.linkProperties.isEmpty()) {
            throw new IllegalStateException("Link properties not initialized");
        }
        return this.linkProperties.get((Object)name);
    }

    public void addLinkProperty(LinkProperty name, Object propertyValue) {
        if (this.linkProperties == null) {
            this.linkProperties = new HashMap<LinkProperty, Object>();
        }
        this.linkProperties.put(name, propertyValue);
    }

    public int hashCode() {
        int n = this.getSourceNodeId().hashCode() * this.getTargetNodeId().hashCode();
        return n;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NodeLink)) {
            return false;
        }
        NodeLink targetNodeLink = (NodeLink)obj;
        return new EqualsBuilder().append((Object)this.getSourceNodeId(), (Object)targetNodeLink.getSourceNodeId()).append((Object)this.getTargetNodeId(), (Object)targetNodeLink.getTargetNodeId()).isEquals();
    }

    public String toString() {
        return this.sourceNodeId + "---(" + (Object)((Object)this.multiplicity) + ")--->" + this.targetNodeId;
    }

    public static enum LinkProperty {
        LINK_NAME,
        LINK_VALUE,
        IS_SHARED_BY_PRIMARY_KEY,
        IS_BIDIRECTIONAL,
        IS_RELATED_VIA_JOIN_TABLE,
        PROPERTY,
        BIDIRECTIONAL_PROPERTY,
        CASCADE,
        JOIN_TABLE_METADATA;

    }
}

