/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.graph;

import com.impetus.kundera.graph.Node;
import com.impetus.kundera.graph.NodeLink;
import com.impetus.kundera.graph.ObjectGraph;
import com.impetus.kundera.graph.ObjectGraphUtils;
import com.impetus.kundera.lifecycle.states.NodeState;
import com.impetus.kundera.lifecycle.states.TransientState;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.persistence.IdGenerator;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.persistence.PersistenceValidator;
import com.impetus.kundera.persistence.context.PersistenceCache;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.proxy.KunderaProxy;
import com.impetus.kundera.proxy.ProxyHelper;
import com.impetus.kundera.proxy.collection.ProxyCollection;
import com.impetus.kundera.utils.DeepEquals;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.GeneratedValue;
import javax.persistence.MapKeyJoinColumn;
import org.apache.commons.lang.StringUtils;

public class ObjectGraphBuilder {
    private PersistenceCache persistenceCache;
    private PersistenceDelegator pd;
    private IdGenerator idGenerator;
    private PersistenceValidator validator;

    public ObjectGraphBuilder(PersistenceCache pcCache, PersistenceDelegator pd) {
        this.persistenceCache = pcCache;
        this.pd = pd;
        this.idGenerator = new IdGenerator();
        this.validator = new PersistenceValidator();
    }

    public ObjectGraph getObjectGraph(Object entity, NodeState initialNodeState) {
        ObjectGraph objectGraph = new ObjectGraph();
        Node headNode = this.getNode(entity, objectGraph, initialNodeState);
        if (headNode != null) {
            objectGraph.setHeadNode(headNode);
        }
        return objectGraph;
    }

    private Node getNode(Object entity, ObjectGraph graph, NodeState initialNodeState) {
        if (entity == null) {
            return null;
        }
        EntityMetadata entityMetadata = KunderaMetadataManager.getEntityMetadata(this.pd.getKunderaMetadata(), entity.getClass());
        if (entityMetadata == null) {
            throw new IllegalArgumentException("Entity object is invalid, operation failed. Please check previous log message for details");
        }
        Object id = PropertyAccessorHelper.getId(entity, entityMetadata);
        if (((Field)entityMetadata.getIdAttribute().getJavaMember()).isAnnotationPresent(GeneratedValue.class) && !this.isIdSet(id)) {
            id = this.idGenerator.generateAndSetId(entity, entityMetadata, this.pd, this.pd.getKunderaMetadata());
        }
        if (!this.validator.isValidEntityObject(entity, entityMetadata)) {
            throw new IllegalArgumentException("Entity object is invalid, operation failed. Please check previous log message for details");
        }
        String nodeId = ObjectGraphUtils.getNodeId(id, entity.getClass());
        Node node = graph.getNode(nodeId);
        if (node != null) {
            if (node.isGraphCompleted()) {
                return node;
            }
            return null;
        }
        Node nodeInPersistenceCache = this.persistenceCache.getMainCache().getNodeFromCache(nodeId, this.pd);
        if (nodeInPersistenceCache == null) {
            node = new Node(nodeId, entity, initialNodeState, this.persistenceCache, id, this.pd);
        } else {
            node = nodeInPersistenceCache;
            node.setPersistenceCache(this.persistenceCache);
            if (!DeepEquals.deepEquals(node.getData(), entity)) {
                node.setDirty(true);
            } else if (node.isProcessed()) {
                node.setDirty(false);
            }
            node.setData(entity);
        }
        graph.addNode(nodeId, node);
        for (Relation relation : entityMetadata.getRelations()) {
            Object childrenObjects;
            Object childObject;
            if (relation == null || (childObject = PropertyAccessorHelper.getObject(entity, relation.getProperty())) == null || ProxyHelper.isProxy(childObject)) continue;
            EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(this.pd.getKunderaMetadata(), PropertyAccessorHelper.getGenericClass(relation.getProperty()));
            if (metadata != null && relation.isJoinedByPrimaryKey()) {
                PropertyAccessorHelper.setId(childObject, metadata, PropertyAccessorHelper.getId(entity, entityMetadata));
            }
            if (Collection.class.isAssignableFrom(childObject.getClass())) {
                childrenObjects = (Collection)childObject;
                if (childrenObjects == null || ProxyHelper.isProxyCollection(childrenObjects)) continue;
                Iterator<Object> i$ = childrenObjects.iterator();
                while (i$.hasNext()) {
                    Object e = i$.next();
                    if (e == null) continue;
                    this.addChildNodesToGraph(graph, node, relation, e, metadata != null ? this.getChildNodeState(metadata, e) : initialNodeState);
                }
                continue;
            }
            if (Map.class.isAssignableFrom(childObject.getClass())) {
                childrenObjects = (Map)childObject;
                if (childrenObjects == null || ProxyHelper.isProxyCollection(childrenObjects)) continue;
                for (Map.Entry entry : childrenObjects.entrySet()) {
                    this.addChildNodesToGraph(graph, node, relation, entry, metadata != null ? this.getChildNodeState(metadata, entry) : initialNodeState);
                }
                continue;
            }
            this.addChildNodesToGraph(graph, node, relation, childObject, metadata != null ? this.getChildNodeState(metadata, childObject) : initialNodeState);
        }
        node.setGraphCompleted(true);
        return node;
    }

    private NodeState getChildNodeState(EntityMetadata metadata, Object childObj) {
        Object childId = PropertyAccessorHelper.getId(childObj, metadata);
        String childNodeId = ObjectGraphUtils.getNodeId(childId, childObj.getClass());
        Node childNodeInCache = this.persistenceCache.getMainCache().getNodeFromCache(childNodeId, this.pd);
        return childNodeInCache != null ? childNodeInCache.getCurrentNodeState() : new TransientState();
    }

    private void addChildNodesToGraph(ObjectGraph graph, Node node, Relation relation, Object childObject, NodeState initialNodeState) {
        if (childObject instanceof KunderaProxy || childObject instanceof ProxyCollection) {
            return;
        }
        if (childObject instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)childObject;
            Object relObject = entry.getKey();
            Object entityObject = entry.getValue();
            Node childNode = this.getNode(entityObject, graph, initialNodeState);
            if (childNode != null) {
                if (!StringUtils.isEmpty((String)relation.getMappedBy()) && relation.getProperty().getAnnotation(MapKeyJoinColumn.class) == null) {
                    return;
                }
                NodeLink nodeLink = new NodeLink(node.getNodeId(), childNode.getNodeId());
                nodeLink.setMultiplicity(relation.getType());
                EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(this.pd.getKunderaMetadata(), node.getDataClass());
                nodeLink.setLinkProperties(this.getLinkProperties(metadata, relation));
                nodeLink.addLinkProperty(NodeLink.LinkProperty.LINK_VALUE, relObject);
                childNode.addParentNode(nodeLink, node);
                node.addChildNode(nodeLink, childNode);
            }
        } else {
            Node childNode = this.getNode(childObject, graph, initialNodeState);
            if (childNode != null) {
                NodeLink nodeLink = new NodeLink(node.getNodeId(), childNode.getNodeId());
                nodeLink.setMultiplicity(relation.getType());
                EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(this.pd.getKunderaMetadata(), node.getDataClass());
                nodeLink.setLinkProperties(this.getLinkProperties(metadata, relation));
                childNode.addParentNode(nodeLink, node);
                node.addChildNode(nodeLink, childNode);
            }
        }
    }

    private Map<NodeLink.LinkProperty, Object> getLinkProperties(EntityMetadata metadata, Relation relation) {
        HashMap<NodeLink.LinkProperty, Object> linkProperties = new HashMap<NodeLink.LinkProperty, Object>();
        linkProperties.put(NodeLink.LinkProperty.LINK_NAME, MetadataUtils.getMappedName(metadata, relation, this.pd.getKunderaMetadata()));
        linkProperties.put(NodeLink.LinkProperty.IS_SHARED_BY_PRIMARY_KEY, relation.isJoinedByPrimaryKey());
        linkProperties.put(NodeLink.LinkProperty.IS_BIDIRECTIONAL, !relation.isUnary());
        linkProperties.put(NodeLink.LinkProperty.IS_RELATED_VIA_JOIN_TABLE, relation.isRelatedViaJoinTable());
        linkProperties.put(NodeLink.LinkProperty.PROPERTY, relation.getProperty());
        linkProperties.put(NodeLink.LinkProperty.CASCADE, relation.getCascades());
        if (relation.isRelatedViaJoinTable()) {
            linkProperties.put(NodeLink.LinkProperty.JOIN_TABLE_METADATA, relation.getJoinTableMetadata());
        }
        return linkProperties;
    }

    private boolean isIdSet(Object id) {
        if (id == null) {
            return false;
        }
        return !id.getClass().isPrimitive() && !(id instanceof Number) || !id.toString().equals("0") && !id.toString().equals("0.0") && !id.toString().equals("");
    }
}

